/*
 * Decompiled with CFR 0.152.
 */
package pub.doric;

import android.animation.AnimatorSet;
import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import androidx.fragment.app.Fragment;
import com.github.pengfeizhou.jscore.JSDecoder;
import com.github.pengfeizhou.jscore.JSONBuilder;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import org.json.JSONObject;
import pub.doric.DoricContextManager;
import pub.doric.DoricNativeDriver;
import pub.doric.IDoricDriver;
import pub.doric.async.AsyncResult;
import pub.doric.navbar.IDoricNavBar;
import pub.doric.navigator.IDoricNavigator;
import pub.doric.plugin.DoricJavaPlugin;
import pub.doric.shader.RootNode;
import pub.doric.shader.ViewNode;
import pub.doric.utils.DoricMetaInfo;
import pub.doric.utils.ThreadMode;

public class DoricContext {
    private final String mContextId;
    private final Map<String, DoricJavaPlugin> mPluginMap = new HashMap<String, DoricJavaPlugin>();
    private final Context mContext;
    private RootNode mRootNode = new RootNode(this);
    private final String source;
    private String script;
    private String extra;
    private JSONObject initParams;
    private IDoricDriver doricDriver;
    private final Map<String, Map<String, ViewNode>> mHeadNodes = new HashMap<String, Map<String, ViewNode>>();
    private IDoricNavigator doricNavigator;
    private IDoricNavBar doricNavBar;
    private AnimatorSet animatorSet;

    public Collection<ViewNode> allHeadNodes(String type) {
        return this.mHeadNodes.get(type).values();
    }

    public void addHeadNode(String type, ViewNode viewNode) {
        Map<String, ViewNode> map = this.mHeadNodes.get(type);
        if (map != null) {
            map.put(viewNode.getId(), viewNode);
        } else {
            map = new HashMap<String, ViewNode>();
            map.put(viewNode.getId(), viewNode);
            this.mHeadNodes.put(type, map);
        }
    }

    public void removeHeadNode(String type, ViewNode viewNode) {
        Map<String, ViewNode> map = this.mHeadNodes.get(type);
        if (map != null) {
            map.remove(viewNode.getId());
        }
    }

    public void clearHeadNodes(String type) {
        Map<String, ViewNode> map = this.mHeadNodes.get(type);
        if (map != null) {
            map.clear();
        }
    }

    public ViewNode targetViewNode(String id2) {
        if (id2.equals(this.mRootNode.getId())) {
            return this.mRootNode;
        }
        for (Map<String, ViewNode> map : this.mHeadNodes.values()) {
            if (!map.containsKey(id2)) continue;
            return map.get(id2);
        }
        return null;
    }

    protected DoricContext(Context context, String contextId, String source, String extra) {
        this.mContext = context;
        this.mContextId = contextId;
        this.source = source;
        this.extra = extra;
    }

    public String getSource() {
        return this.source;
    }

    public String getScript() {
        return this.script;
    }

    public static DoricContext create(Context context, String script, String source, String extra) {
        DoricContext doricContext = DoricContextManager.getInstance().createContext(context, script, source, extra);
        doricContext.script = script;
        doricContext.init(extra);
        doricContext.callEntity("__onCreate__", new Object[0]);
        return doricContext;
    }

    public void init(String initData) {
        this.extra = initData;
        if (!TextUtils.isEmpty((CharSequence)initData)) {
            this.callEntity("__init__", initData);
        }
    }

    public void build(float width, float height) {
        this.initParams = new JSONBuilder().put("width", (Object)Float.valueOf(width)).put("height", (Object)Float.valueOf(height)).toJSONObject();
        this.callEntity("__build__", this.initParams);
    }

    public AsyncResult<JSDecoder> callEntity(String methodName, Object ... args) {
        return this.getDriver().invokeContextEntityMethod(this.mContextId, methodName, args);
    }

    public IDoricDriver getDriver() {
        if (this.doricDriver == null) {
            this.doricDriver = DoricNativeDriver.getInstance();
        }
        return this.doricDriver;
    }

    public void setDriver(IDoricDriver doricDriver) {
        this.doricDriver = doricDriver;
    }

    public RootNode getRootNode() {
        return this.mRootNode;
    }

    public Context getContext() {
        return this.mContext;
    }

    public String getContextId() {
        return this.mContextId;
    }

    public void teardown() {
        this.callEntity("__onDestroy__", new Object[0]).setCallback(new AsyncResult.Callback<JSDecoder>(){

            @Override
            public void onResult(JSDecoder result) {
            }

            @Override
            public void onError(Throwable t) {
            }

            @Override
            public void onFinish() {
                DoricContext.this.getDriver().asyncCall(new Callable<Object>(){

                    @Override
                    public Object call() {
                        for (DoricJavaPlugin javaPlugin : DoricContext.this.mPluginMap.values()) {
                            javaPlugin.onTearDown();
                        }
                        DoricContext.this.mPluginMap.clear();
                        return null;
                    }
                }, ThreadMode.UI);
            }
        });
        DoricContextManager.getInstance().destroyContext(this);
    }

    public DoricJavaPlugin obtainPlugin(DoricMetaInfo<DoricJavaPlugin> doricMetaInfo) {
        DoricJavaPlugin plugin = this.mPluginMap.get(doricMetaInfo.getName());
        if (plugin == null) {
            plugin = doricMetaInfo.createInstance(this);
            this.mPluginMap.put(doricMetaInfo.getName(), plugin);
        }
        return plugin;
    }

    public void reload(String script) {
        this.getDriver().destroyContext(this.getContextId());
        for (DoricJavaPlugin javaPlugin : this.mPluginMap.values()) {
            javaPlugin.onTearDown();
        }
        this.mPluginMap.clear();
        this.script = script;
        this.mRootNode.setId("");
        this.mRootNode.clearSubModel();
        this.getDriver().createContext(this.mContextId, script, this.source);
        this.init(this.extra);
        this.callEntity("__onCreate__", new Object[0]);
        this.callEntity("__build__", this.initParams);
        this.onShow();
    }

    public void onShow() {
        this.callEntity("__onShow__", new Object[0]);
    }

    public void onHidden() {
        this.callEntity("__onHidden__", new Object[0]);
    }

    public void setDoricNavigator(IDoricNavigator doricNavigator) {
        this.doricNavigator = doricNavigator;
    }

    public IDoricNavigator getDoricNavigator() {
        return this.doricNavigator;
    }

    public void setDoricNavBar(IDoricNavBar navBar) {
        this.doricNavBar = navBar;
    }

    public IDoricNavBar getDoricNavBar() {
        return this.doricNavBar;
    }

    public void setAnimatorSet(AnimatorSet animatorSet) {
        this.animatorSet = animatorSet;
    }

    public AnimatorSet getAnimatorSet() {
        return this.animatorSet;
    }

    public JSONObject getInitParams() {
        return this.initParams;
    }

    public String getExtra() {
        return this.extra;
    }

    public void startActivityForResult(Intent intent, int requestCode) {
        if (this.doricNavigator instanceof Fragment) {
            ((Fragment)this.doricNavigator).startActivityForResult(intent, requestCode);
        }
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        for (DoricJavaPlugin javaPlugin : this.mPluginMap.values()) {
            javaPlugin.onActivityResult(requestCode, resultCode, data);
        }
    }
}

