/*
 * Decompiled with CFR 0.152.
 */
package pro.siper.adept.core.endless;

import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import pro.siper.adept.core.endless.EndlessScrollingCallback;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0006H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lpro/siper/adept/core/endless/EndlessScrollingListener;", "Landroidx/recyclerview/widget/RecyclerView$OnScrollListener;", "endlessScrollingCallback", "Lpro/siper/adept/core/endless/EndlessScrollingCallback;", "(Lpro/siper/adept/core/endless/EndlessScrollingCallback;)V", "currentPage", "", "hasNextPage", "", "getHasNextPage", "()Z", "setHasNextPage", "(Z)V", "loading", "previousTotalItemCount", "startingPageIndex", "visibleThreshold", "onScrolled", "", "recyclerView", "Landroidx/recyclerview/widget/RecyclerView;", "dx", "dy", "adept-core_release"})
public final class EndlessScrollingListener
extends RecyclerView.OnScrollListener {
    private boolean hasNextPage;
    private boolean loading;
    private int previousTotalItemCount;
    private int currentPage;
    private final int visibleThreshold = 10;
    private final int startingPageIndex = 1;
    private final EndlessScrollingCallback endlessScrollingCallback;

    public final boolean getHasNextPage() {
        return this.hasNextPage;
    }

    public final void setHasNextPage(boolean bl) {
        this.hasNextPage = bl;
    }

    public void onScrolled(@NotNull RecyclerView recyclerView, int dx, int dy) {
        Intrinsics.checkParameterIsNotNull((Object)recyclerView, (String)"recyclerView");
        super.onScrolled(recyclerView, dx, dy);
        RecyclerView.Adapter adapter = recyclerView.getAdapter();
        if (adapter == null) {
            return;
        }
        int totalItemCount = adapter.getItemCount();
        RecyclerView.LayoutManager layoutManager = recyclerView.getLayoutManager();
        if (layoutManager == null) {
            throw new TypeCastException("null cannot be cast to non-null type androidx.recyclerview.widget.LinearLayoutManager");
        }
        LinearLayoutManager layoutManager2 = (LinearLayoutManager)layoutManager;
        int firstVisibleItem = layoutManager2.findFirstVisibleItemPosition();
        int visibleItemCount = layoutManager2.findLastVisibleItemPosition() - firstVisibleItem;
        if (totalItemCount < this.previousTotalItemCount) {
            this.currentPage = this.startingPageIndex;
            this.previousTotalItemCount = totalItemCount;
            if (totalItemCount == 0) {
                this.loading = true;
            }
        }
        if (this.loading && totalItemCount > this.previousTotalItemCount) {
            this.loading = false;
            this.previousTotalItemCount = totalItemCount;
            int n = this.currentPage;
            this.currentPage = n + 1;
        }
        if (!this.loading && firstVisibleItem + visibleItemCount + this.visibleThreshold >= totalItemCount) {
            boolean hasNextPage;
            this.loading = hasNextPage = this.endlessScrollingCallback.onLoadMore(this.currentPage, totalItemCount);
            if (!hasNextPage) {
                this.hasNextPage = hasNextPage;
            }
        }
    }

    public EndlessScrollingListener(@NotNull EndlessScrollingCallback endlessScrollingCallback) {
        Intrinsics.checkParameterIsNotNull((Object)endlessScrollingCallback, (String)"endlessScrollingCallback");
        this.endlessScrollingCallback = endlessScrollingCallback;
        this.hasNextPage = true;
        this.currentPage = 1;
        this.visibleThreshold = 10;
        this.startingPageIndex = 1;
    }
}

