package pro.siper.adept.core

import android.util.SparseArray

fun <T> SparseArray<T>.forEachWithKey(action: (item: T, key: Int) -> Unit) {
    for (i in 0 until this.size()) {
        action.invoke(this.valueAt(i), this.keyAt(i))
    }
}

fun <T> SparseArray<T>.filter(predicate: (T) -> Boolean): SparseArray<T> {
    this.forEachWithKey { item, key ->
        if (!predicate.invoke(item)) {
            this.remove(key)
        }
    }
    return this
}

fun <T, R> SparseArray<T>.map(transformer: (T) -> R): SparseArray<R> {
    val r = SparseArray<R>()
    this.forEachWithKey { item, key ->
        r.put(key, transformer.invoke(item))
    }
    return r
}