package pro.siper.adept.core

import android.os.Parcelable
import android.util.SparseArray
import android.view.View
import androidx.recyclerview.widget.LinearLayoutManager
import androidx.recyclerview.widget.RecyclerView

class AdeptViewHolder(itemView: View, val viewType: Int) : RecyclerView.ViewHolder(itemView) {
    private val views = SparseArray<View>()
    internal var hasNestedRv = false

    @Suppress("UNCHECKED_CAST")
    fun <T : View> findView(id: Int): T {
        if (views[id] == null) {
            val view = itemView.findViewById<T>(id)
            if (!hasNestedRv && view is RecyclerView) {
                hasNestedRv = true
            }
            views.put(id, view)
        }
        return views[id] as T
    }

    fun getRvStates(): SparseArray<Parcelable> {
        val states = SparseArray<Parcelable>()
        val rv = views
                .filter { it is RecyclerView }
                .map { it as RecyclerView }
        rv.forEachWithKey { item, key ->
            val lm = item.layoutManager
            if (lm is LinearLayoutManager) {
                states.put(key, lm.onSaveInstanceState())
            }
        }
        return states
    }

    fun setRvStates(states: SparseArray<Parcelable>) {
        states.forEachWithKey { item, key ->
            (findView<RecyclerView>(key).layoutManager as LinearLayoutManager)
                    .onRestoreInstanceState(item)
        }
    }
}