/*
 * Decompiled with CFR 0.152.
 */
package playfun.ads.android.sdk.component.factory.rewards;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Fragment;
import android.app.FragmentTransaction;
import android.content.Context;
import android.util.AttributeSet;
import android.util.Log;
import playfun.ads.android.sdk.component.callback.AdsFunListener;
import playfun.ads.android.sdk.component.factory.popupfactory.BasePopUp;
import playfun.ads.android.sdk.component.factory.popupfactory.PopUpFactory;
import playfun.ads.android.sdk.component.model.networkmodel.Data;
import playfun.ads.android.sdk.component.observer.AdsServices;
import playfun.ads.android.sdk.component.sate.FunAdsView;
import playfun.ads.android.sdk.component.util.PopUpEnum;

public class RewardVideoPopup
extends FunAdsView {
    private static final String TAG = RewardVideoPopup.class.getSimpleName();
    private FragmentTransaction fragmentTransaction;
    private BasePopUp popUp;
    private Fragment fragment;
    private Data data;
    private final Context context;
    private PopUpEnum popUpEnum;

    public RewardVideoPopup(Context context) {
        super(context);
        this.context = context;
    }

    public RewardVideoPopup(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.context = context;
        this.initView();
    }

    public RewardVideoPopup(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.context = context;
    }

    public RewardVideoPopup(Context context, PopUpEnum popUpEnum, Data data) {
        super(context);
        System.out.printf("playfun.ads.android.sdk.component", "PopUpAds init : PopUpAds");
        this.context = context;
        this.popUpEnum = popUpEnum;
        this.data = data;
    }

    @Override
    public void hideFunAds() {
    }

    @Override
    public void showFunAds() {
        this.initView();
    }

    @Override
    @SuppressLint(value={"LongLogTag"})
    public void loadFunAds(int inventoryId, String inventoryCode, int raaid) {
        Log.e((String)"playfun.ads.android.sdk.component", (String)"showFunAds: popUpAds");
    }

    private void initView() {
        if (this.context == null) {
            return;
        }
        Log.i((String)TAG, (String)"PopUpAds: initView()");
        try {
            Activity activity = (Activity)this.context;
            this.fragmentTransaction = activity.getFragmentManager().beginTransaction();
            this.fragment = activity.getFragmentManager().findFragmentByTag("dialog");
            this.popUp = PopUpFactory.createPopUp(this.popUpEnum);
        }
        catch (Exception e) {
            System.out.println("can not cast context to Activity");
            e.printStackTrace();
        }
        if (this.fragment != null && this.fragment.isAdded()) {
            this.popUp.show(this.fragmentTransaction, "dialog");
            return;
        }
        try {
            this.fragmentTransaction.addToBackStack(null);
            this.popUp.show(this.fragmentTransaction, "dialog");
        }
        catch (Exception e) {
            System.out.println("Popup is null");
            e.printStackTrace();
        }
    }

    @Override
    public void updateAds(Data data) {
        super.updateAds(data);
        this.data = data;
    }

    @Override
    public void sendListener(AdsFunListener listener) {
        super.sendListener(listener);
        Log.e((String)"adsView", (String)"updateAds_popup_ads");
        AdsServices adsServices = new AdsServices(this.data, listener);
        adsServices.attach(this.popUp);
        adsServices.notifyAllObserver();
    }
}

