package playfun.ads.android.sdk.component.model.networkmodel;

import android.os.Parcel;
import android.os.Parcelable;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
public class MetaData implements Parcelable {
    @SerializedName("longTitle")
    @Expose
    private LongTitle longTitle;
    @SerializedName("shortTitle")
    @Expose
    private ShortTitle shortTitle;
    @SerializedName("longDescription")
    @Expose
    private LongDescription longDescription;
    @SerializedName("shortDescription")
    @Expose
    private ShortDescription shortDescription;
    @SerializedName("logoImage")
    @Expose
    private LogoImage logoImage;
    @SerializedName("cta0")
    @Expose
    private Cta0 cta0;
    @SerializedName("cta1")
    @Expose
    private Cta1 cta1;
    @SerializedName("cta2")
    @Expose
    private Cta2 cta2;
    @SerializedName("cta3")
    @Expose
    private Cta3 cta3;
    @SerializedName("cta4")
    @Expose
    private Cta4 cta4;
    @SerializedName("video")
    @Expose
    private Video video;
    @SerializedName("image")
    @Expose
    private ImageModel image;
    @SerializedName("imageBanner")
    @Expose
    private ImageBanner imageBanner;
    @SerializedName("multipleFile")
    @Expose
    private MultipleFile multipleFile;
    @SerializedName("isTracking")
    @Expose
    private IsTracking isTracking;
    @SerializedName("waitingTime")
    @Expose
    private WaitingTime waitingTime;


    protected MetaData(Parcel in) {
        longTitle = (LongTitle) in.readParcelable(LongTitle.class.getClassLoader());
        shortTitle = (ShortTitle) in.readParcelable(ShortTitle.class.getClassLoader());
        longDescription = (LongDescription) in.readParcelable(LongDescription.class.getClassLoader());
        shortDescription = (ShortDescription) in.readParcelable(ShortDescription.class.getClassLoader());
        logoImage = (LogoImage) in.readParcelable(LogoImage.class.getClassLoader());
        cta0 = (Cta0) in.readParcelable(Cta0.class.getClassLoader());
        cta1 = (Cta1) in.readParcelable(Cta1.class.getClassLoader());
        video = (Video) in.readParcelable(Video.class.getClassLoader());
        image = (ImageModel) in.readParcelable(ImageModel.class.getClassLoader());
        imageBanner = (ImageBanner) in.readParcelable(ImageBanner.class.getClassLoader());
        multipleFile = (MultipleFile) in.readParcelable(MultipleFile.class.getClassLoader());
        isTracking = (IsTracking) in.readParcelable(IsTracking.class.getClassLoader());
        waitingTime = (WaitingTime) in.readParcelable(WaitingTime.class.getClassLoader());
    }

    public static final Creator<MetaData> CREATOR = new Creator<MetaData>() {
        @Override
        public MetaData createFromParcel(Parcel in) {
            return new MetaData(in);
        }

        @Override
        public MetaData[] newArray(int size) {
            return new MetaData[size];
        }
    };

    public LongTitle getLongTitle() {
        return longTitle;
    }

    public void setLongTitle(LongTitle longTitle) {
        this.longTitle = longTitle;
    }

    public ShortTitle getShortTitle() {
        return shortTitle;
    }

    public void setShortTitle(ShortTitle shortTitle) {
        this.shortTitle = shortTitle;
    }

    public LongDescription getLongDescription() {
        return longDescription;
    }

    public void setLongDescription(LongDescription longDescription) {
        this.longDescription = longDescription;
    }
    public MultipleFile getMultipleFile() {
        return multipleFile;
    }

    public void setMultipleFile(MultipleFile multipleFile) {
        this.multipleFile = multipleFile;
    }

    public ShortDescription getShortDescription() {
        return shortDescription;
    }

    public void setShortDescription(ShortDescription shortDescription) {
        this.shortDescription = shortDescription;
    }

    public LogoImage getLogoImage() {
        return logoImage;
    }

    public void setLogoImage(LogoImage logoImage) {
        this.logoImage = logoImage;
    }

    public Cta0 getCta0() {
        return cta0;
    }

    public void setCta0(Cta0 cta0) {
        this.cta0 = cta0;
    }

    public Cta1 getCta1() {
        return cta1;
    }

    public void setCta1(Cta1 cta1) {
        this.cta1 = cta1;
    }

    public Video getVideo() {
        return video;
    }

    public void setVideo(Video video) {
        this.video = video;
    }

    public ImageModel getImage() {
        return image;
    }

    public void setImage(ImageModel image) {
        this.image = image;
    }

    public ImageBanner getImageBanner() {
        return imageBanner;
    }

    public void setImageBanner(ImageBanner imageBanner) {
        this.imageBanner = imageBanner;
    }

    public Cta2 getCta2() {
        return cta2;
    }

    public void setCta2(Cta2 cta2) {
        this.cta2 = cta2;
    }

    public Cta3 getCta3() {
        return cta3;
    }

    public void setCta3(Cta3 cta3) {
        this.cta3 = cta3;
    }

    public Cta4 getCta4() {
        return cta4;
    }

    public void setCta4(Cta4 cta4) {
        this.cta4 = cta4;
    }

    public IsTracking getIsTracking() {
        return isTracking;
    }

    public void setIsTracking(IsTracking isTracking) {
        this.isTracking = isTracking;
    }

    public WaitingTime getWaitingTime() {
        return waitingTime;
    }

    public void setWaitingTime(WaitingTime waitingTime) {
        this.waitingTime = waitingTime;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int i) {
        parcel.writeParcelable(longTitle , i);
        parcel.writeParcelable(shortTitle , i);
        parcel.writeParcelable(longDescription , i);
        parcel.writeParcelable(shortDescription , i);
        parcel.writeParcelable(logoImage , i);
        parcel.writeParcelable(cta0 , i);
        parcel.writeParcelable(cta1, i);
        parcel.writeParcelable(video , i);
        parcel.writeParcelable(image , i);
        parcel.writeParcelable(imageBanner , i);
        parcel.writeParcelable(multipleFile , i);
        parcel.writeParcelable(isTracking , i);
        parcel.writeParcelable(waitingTime , i);
    }
}
