package playfun.ads.android.sdk.component.factory.rewards;

import android.annotation.SuppressLint;
import android.app.Dialog;
import android.app.DialogFragment;
import android.app.FragmentManager;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.Typeface;
import android.net.Uri;
import android.os.Bundle;
import android.os.CountDownTimer;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.Spanned;
import android.text.style.ForegroundColorSpan;
import android.text.style.StyleSpan;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;

import com.ankushgrover.hourglass.Hourglass;
import com.bumptech.glide.Glide;
import com.bumptech.glide.request.target.SimpleTarget;
import com.bumptech.glide.request.transition.Transition;
import com.google.android.exoplayer2.ExoPlayerFactory;
import com.google.android.exoplayer2.Player;
import com.google.android.exoplayer2.SimpleExoPlayer;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.ui.PlayerView;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.Util;

import playfun.ads.android.sdk.R;
import playfun.ads.android.sdk.component.factory.popupfactory.BasePopUp;
import playfun.ads.android.sdk.component.util.AdsUtils;
import playfun.ads.android.sdk.component.util.ImageHelper;
import playfun.ads.android.sdk.component.util.MediaSourseInstance;
import playfun.ads.android.sdk.component.util.ScreenUtil;
import playfun.ads.android.sdk.component.view.TimerView;

public class PopupAdsRewardVideo extends BasePopUp implements Player.EventListener{
    private static final String TAG = PopupAdsRewardVideo.class.getSimpleName();
    public PlayerView playerView;

    public SimpleExoPlayer player;
    private View view;
    private FrameLayout mFrameLayout , layout_countdown_reward_ads;
    private RelativeLayout mButtonDownload, frame_layout_reward_finish , frame_layout_pause;
    private TextView mTvTitle, mTvContent, mTv_Download;
    private ImageView mImageIcon , img_close_reward;
    private MediaSource mediaSource;

    private ImageView img_mute_reward_ads, img_unmute_reward_ads;
    private TextView text_countdown_finish_video_reward, text_countdown_reward;
    private LinearLayout layout_text_countdown_finish_video;
    Hourglass hourglass;

    //TODO khai báo component cho màn ngang
    private ImageView image_icon_reward_finish, btn_close_reward_finish;
    private Button btn_playnow_reward_ads;
    private TextView tv_description_reward_finish, tv_title_reward_finish;

    private TextView text_time_amount_reminding;
    private Button btn_off_reward_ads , btn_continue_reward_ads;
    private String mAction;


    TimeAmountRemind timeAmountRemind = new TimeAmountRemind() {
        @Override
        public void getTimeAmount(int timeAmount) {
            if(ScreenUtil.isLandScape(getActivity())){
                text_time_amount_reminding.setText(timeAmount + "s");
            }else{
                String text = "Xem thêm "+ timeAmount +"s \n" +
                        "để nhận phần quà hấp dẫn";
                SpannableString ss = new SpannableString(text);
                StyleSpan boldSpan = new StyleSpan(Typeface.BOLD);
                ss.setSpan(new ForegroundColorSpan(Color.RED), 9, 12, Spannable.SPAN_EXCLUSIVE_EXCLUSIVE);
                ss.setSpan(boldSpan , 9 , 12 , Spanned.SPAN_EXCLUSIVE_EXCLUSIVE);
                text_time_amount_reminding.setText(ss);
            }
        }
    };



    @Override
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        Dialog dialog = super.onCreateDialog(savedInstanceState);
        dialog.getWindow().requestFeature(Window.FEATURE_NO_TITLE);
        dialog.getWindow().setFlags(WindowManager.LayoutParams.FLAG_FULLSCREEN, WindowManager.LayoutParams.FLAG_FULLSCREEN);
        dialog.getWindow().setLayout(ViewGroup.LayoutParams.MATCH_PARENT , ViewGroup.LayoutParams.MATCH_PARENT);
        dialog.setCanceledOnTouchOutside(false);
        dialog.setCancelable(false);
        return dialog;
    }
    @SuppressLint("LongLogTag")
    @Override
    public void onCreate( Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Log.i(TAG,"PopUpAdsDialogVideo: " + "onCreate");
        setStyle(DialogFragment.STYLE_NO_TITLE, R.style.FullDialogStyle);
        this.setCancelable(false);
    }

    @Override
    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
    }
    @Override
    public void onAttach(Context context) {
        super.onAttach(context);
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        view = inflater.inflate(R.layout.popup_reward_video, container , true);

        initViewVideo(view);
        initBottomViewInVideo(view);

        //TODO End
        //TODO khai báo finish screen reward
        initViewFinish(view);

        initPlayer();
        img_mute_reward_ads.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                Log.d(TAG , "click mute reward ads");
                if(player != null)
                    player.setVolume(100f);
                img_mute_reward_ads.setVisibility(View.GONE);
                img_unmute_reward_ads.setVisibility(View.VISIBLE);
            }
        });
        img_unmute_reward_ads.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                Log.d(TAG , "click unmute reward ads");
                if(player != null)
                    player.setVolume(0f);
                img_unmute_reward_ads.setVisibility(View.GONE);
                img_mute_reward_ads.setVisibility(View.VISIBLE);
            }
        });
        try {
            if (data.getMetaData().getCta0() != null && data.getMetaData().getCta0().getLink() != null) {
                mTv_Download.setText(cta0Action.getLabel());
                mAction = data.getMetaData().getCta0().getLink();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return view;
    }

    private void initBottomViewInVideo(View view){
        //TODO khai báo cho phần banner bottom
        mButtonDownload = view.findViewById(R.id.btn_download);
        mImageIcon = view.findViewById(R.id.image_small_content);
        mTvContent = view.findViewById(R.id.tv_content);
        mTvTitle = view.findViewById(R.id.tv_title);
        mTv_Download = view.findViewById(R.id.tv_download);
        //TODO set data to bottom banner
        mTv_Download.setText(data.getMetaData().getCta0().getLabel() != null ? data.getMetaData().getCta0().getLabel() : "");
        mTvContent.setText(data.getMetaData().getShortDescription().getData() != null ? data.getMetaData().getShortDescription().getData() : "");
        mTvTitle.setText(data.getMetaData().getShortTitle().getData() != null ? data.getMetaData().getShortTitle().getData() : "");
        Glide.with(getActivity()).asBitmap().load(data.getMetaData().getLogoImage().getData()  != null ? data.getMetaData().getLogoImage().getData() : "").into(new SimpleTarget<Bitmap>() {
            @Override
            public void onResourceReady(@NonNull Bitmap resource, @Nullable Transition<? super Bitmap> transition) {
                if (ScreenUtil.isLandScape(getActivity())) {
                    mImageIcon.setImageBitmap(ImageHelper.getRoundedCornerBitmap(resource, ImageHelper.getCornerPixel(resource,28)));
                } else {
                    mImageIcon.setImageBitmap(ImageHelper.getRoundedCornerBitmap(resource, ImageHelper.getCornerPixel(resource,28)));
                }

            }
        });

        mButtonDownload.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                goToStore();
            }
        });
        mTvTitle.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                goToStore();
            }
        });
        mTvContent.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                goToStore();
            }
        });
        mImageIcon.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                goToStore();
            }
        });
    }

    private void initViewVideo (View view){
        playerView = view.findViewById(R.id.reward_video_view);
        mFrameLayout = view.findViewById(R.id.frame_reward_ads);
        playerView.setShutterBackgroundColor(Color.TRANSPARENT);
        playerView.setKeepContentOnPlayerReset(true);

        img_mute_reward_ads = view.findViewById(R.id.img_mute_reward_ads);
        img_unmute_reward_ads = view.findViewById(R.id.img_unmute_reward_ads);

        text_countdown_finish_video_reward = view.findViewById(R.id.text_countdown_finish_video_reward);
        layout_text_countdown_finish_video = view.findViewById(R.id.layout_text_countdown_finish_video);


        layout_countdown_reward_ads = view.findViewById(R.id.layout_countdown_reward_ads);
        layout_countdown_reward_ads.setVisibility(View.VISIBLE);
        img_close_reward = view.findViewById(R.id.img_close_reward);
        img_close_reward.setVisibility(View.GONE);
        text_countdown_reward = view.findViewById(R.id.text_countdown_reward);
        TimerView crpv = view.findViewById(R.id.timer_view_reward);
        crpv.start(data.getCountdownOff().getValue());
        //TODO khai báo màn hình pause
        frame_layout_pause = view.findViewById(R.id.frame_layout_pause);

        new CountDownTimer(data.getCountdownOff().getValue() *1000 , 1000){

            @Override
            public void onTick(long l) {
                text_countdown_reward.setText(" " + l/1000);
            }

            @Override
            public void onFinish() {
                img_close_reward.setVisibility(View.VISIBLE);
                layout_countdown_reward_ads.setVisibility(View.GONE);
            }
        }.start();
        int countdownVideoTime = Integer.parseInt(data.getMetaData().getWaitingTime().getData());

        hourglass = new Hourglass(countdownVideoTime * 1000, 1000) {
            @Override
            public void onTimerTick(long timeRemaining) {
                // Update UI
                Log.d(TAG , "timeRemaining " + timeRemaining);
                text_countdown_finish_video_reward.setText(timeRemaining/1000 + "s ");
                timeAmountRemind.getTimeAmount((int)timeRemaining/1000);
//                Log.d(TAG, "timeAmount" + timeRemaining/1000);
            }

            @Override
            public void onTimerFinish() {
                // Timer finished
                layout_text_countdown_finish_video.setVisibility(View.GONE);
            }
        };
        hourglass.setInterval(1000);
        hourglass.startTimer();
        img_close_reward.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                Log.d(TAG , "click to close ");
                playerView.onPause();
                player.setPlayWhenReady(false);
                hourglass.pauseTimer();
                frame_layout_pause.setVisibility(View.VISIBLE);
                img_close_reward.setVisibility(View.GONE);
                img_unmute_reward_ads.setVisibility(View.GONE);
                img_mute_reward_ads.setVisibility(View.GONE);
                layout_text_countdown_finish_video.setVisibility(View.GONE);
            }
        });
    }

    private void initViewFinish(View view) {
        //TODO khai báo các view trong form finish
        frame_layout_reward_finish = view.findViewById(R.id.frame_layout_reward_finish);
        image_icon_reward_finish = view.findViewById(R.id.image_icon_reward_finish);
        btn_close_reward_finish = view.findViewById(R.id.btn_close_reward_finish);
        btn_playnow_reward_ads = view.findViewById(R.id.btn_playnow_reward_ads);
        tv_description_reward_finish = view.findViewById(R.id.tv_description_reward_finish);
        tv_title_reward_finish = view.findViewById(R.id.tv_title_reward_finish);

        btn_close_reward_finish.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                dismiss();
                //TODO show ads dialog
                FragmentManager fm = getActivity().getFragmentManager();
                ResultRewardItem alertDialog = ResultRewardItem.newInstance("Some title");
                alertDialog.show(fm, "fragment_alert");
            }
        });
        //TODO khai báo các view trong form pause
        text_time_amount_reminding = view.findViewById(R.id.text_time_amount_reminding);
        btn_off_reward_ads = view.findViewById(R.id.btn_off_reward_ads);
        btn_continue_reward_ads = view.findViewById(R.id.btn_continue_reward_ads);
        btn_off_reward_ads.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                dismiss();
            }
        });

        btn_continue_reward_ads.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                playerView.onResume();
                player.setPlayWhenReady(true);
                hourglass.resumeTimer();

                frame_layout_pause.setVisibility(View.GONE);
                img_close_reward.setVisibility(View.VISIBLE);
                img_unmute_reward_ads.setVisibility(View.VISIBLE);
                img_mute_reward_ads.setVisibility(View.GONE);
                layout_text_countdown_finish_video.setVisibility(View.VISIBLE);
            }
        });
    }

    @Override
    public void onStart() {
        super.onStart();
        if (Util.SDK_INT > 23) {
            initializePlayer();
            if (playerView != null) {
                playerView.onResume();
            }
        }
    }
    @SuppressLint("NewApi")
    private void initPlayer() {
        if (getActivity() == null) {
            return;
        }

        try {
            if (player == null) {
                player = ExoPlayerFactory.newSimpleInstance(getActivity());
                playerView.setPlayer(player);
                player.addListener(this);
            }
            player.setVolume(0f);

        } catch (Exception e) {
            System.out.println("can not initalize, Player view is null");
        }

        Log.i(AdsUtils.TAG,"PopUpAdsDialogVideo: " + "initPlayer");
    }

    private synchronized void initializePlayer() {
        new Thread(new Runnable() {
            @Override
            public void run() {
                mediaSource = buildMediaSource();
                try {
                    if (mediaSource != null) {
                        if (player == null) {
                            initPlayer();
                        }
                        player.prepare(mediaSource);
                        player.setPlayWhenReady(true);
                    }
                    Log.i(AdsUtils.TAG,"PopUpAdsDialogVideo: " + "initializePlayer" + mediaSource.toString());
                } catch (Exception e) {
                    System.out.println("player is null");
                }
            }
        }).start();
    }
    @Override
    public void onPause() {
        Log.d(TAG , "onPause");
        super.onPause();
        hourglass.pauseTimer();
        player.setPlayWhenReady(false);
        playerView.onPause();
        if (Util.SDK_INT <= 23) {
            if (playerView != null) {
                playerView.onPause();
            }
//            releasePlayer();
        }
    }

    @Override
    public void onResume() {
        Log.d(TAG , "onResume");
        super.onResume();
        if(isClick)
            hourglass.resumeTimer();
        player.setPlayWhenReady(true);
        playerView.onResume();
        if (Util.SDK_INT <= 23 || player == null) {
            initPlayer();
            initializePlayer();
            if (playerView != null) {
                playerView.onResume();
            }
        }
        handleViewStatePlay();
    }

    private MediaSource buildMediaSource() {
        MediaSource videoSource = null;
        try {
            videoSource = MediaSourseInstance.getInstance().getVideoSource();
        } catch (Exception e) {
            System.out.println("Media sourse is null");
        }
        return videoSource;
    }

    @Override
    public void onStop() {
        Log.d(TAG , "onStop");
        super.onStop();
        if (Util.SDK_INT > 23) {
            if (playerView != null) {
                playerView.onPause();
            }
//            releasePlayer();
        }
    }

    @Override
    public void onPlayerStateChanged(boolean playWhenReady, int playbackState) {
        Log.d("Exodebug","onPlayerStateChanged" + playWhenReady + "/" + playbackState);

        switch (playbackState) {
            case Player.STATE_READY:
            case Player.STATE_BUFFERING:
                break;
            case Player.STATE_ENDED:
                initFrameFinishVideo();
                break;
            default:
                break;
        }
    }

    private void handleViewStatePlay() {
        if (getActivity()== null) {
            return;
        }
        frame_layout_reward_finish.setVisibility(View.GONE);

    }

    private void initFrameFinishVideo() {
        try {
            Log.d(TAG , "end video");
            player.seekTo(player.getDuration()-4000);
            playerView.onPause();
            player.setPlayWhenReady(false);

            tv_title_reward_finish.setText(data.getMetaData().getShortTitle().getData() != null ? data.getMetaData().getShortTitle().getData() : "");
            frame_layout_reward_finish.setVisibility(View.VISIBLE);
            tv_description_reward_finish.setText(data.getMetaData().getShortDescription().getData() != null ? data.getMetaData().getShortDescription().getData() : "");
            btn_playnow_reward_ads.setText(data.getMetaData().getCta0().getLabel() != null ? data.getMetaData().getCta0().getLabel() : "");
            Glide.with(getActivity()).asBitmap().load(data.getMetaData().getLogoImage().getData()  != null ? data.getMetaData().getLogoImage().getData() : "").into(new SimpleTarget<Bitmap>() {
                @Override
                public void onResourceReady(@NonNull Bitmap resource, @Nullable Transition<? super Bitmap> transition) {
                    if (ScreenUtil.isLandScape(getActivity())) {
                        image_icon_reward_finish.setImageBitmap(ImageHelper.getRoundedCornerBitmap(resource, ImageHelper.getCornerPixel(resource,24)));
                    } else {
                        image_icon_reward_finish.setImageBitmap(ImageHelper.getRoundedCornerBitmap(resource, ImageHelper.getCornerPixel(resource,24)));
                    }

                }
            });

            btn_playnow_reward_ads.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    goToStore();
                }
            });

            img_close_reward.setVisibility(View.GONE);
            img_unmute_reward_ads.setVisibility(View.GONE);
            img_mute_reward_ads.setVisibility(View.GONE);
        } catch (Exception e) {
            e.printStackTrace();
        }

    }
    boolean isClick = false;
    private void goToStore() {
        isClick = true;
        try {
            Intent intent = new Intent(Intent.ACTION_VIEW);
            intent.setFlags(Intent.FLAG_ACTIVITY_SINGLE_TOP|Intent.FLAG_ACTIVITY_NEW_TASK);
            intent.setData(Uri.parse(mAction));
            getActivity().startActivity(intent);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
    @Override
    public void onDestroy() {
        Log.d(TAG , "onDestroy");
        super.onDestroy();
        releasePlayer();
    }

    private void releasePlayer() {
        if (player != null) {
            player.release();
            player = null;
        }
    }

    @Override
    public void onLoadingChanged(boolean isLoading) {
        if (isLoading) {
            mFrameLayout.postDelayed(new Runnable() {
                @Override
                public void run() {
                    mFrameLayout.setVisibility(View.VISIBLE);
                }
            },400);
        }
    }


    interface TimeAmountRemind{
        void getTimeAmount(int timeAmount);

    }
}
