package playfun.ads.android.sdk.component.view;

import java.util.ArrayList;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.View.OnTouchListener;

import playfun.ads.android.sdk.R;

public class DrawView extends View implements OnTouchListener {
    private Canvas mCanvas;
    private Path mPath;
    public Paint mPaint;
    Rect rect;
    private ArrayList<Path> paths = new ArrayList<Path>();
    public Bitmap bmp,image;
    public int h = 0;
    public int w = 0;

    public DrawView(Context context) {
        super(context);
        setFocusable(true);
        setFocusableInTouchMode(true);

        this.setOnTouchListener(this);
        bmp = BitmapFactory.decodeResource(getResources(), R.drawable.imagescroll);
        mPaint = new Paint();
        mPaint.setAntiAlias(true);
        mPaint.setDither(true);
        mPaint.setColor(Color.BLUE);
        mPaint.setStyle(Paint.Style.STROKE);
        mPaint.setStrokeJoin(Paint.Join.ROUND);
        mPaint.setStrokeCap(Paint.Cap.ROUND);
        mPaint.setStrokeWidth(6);
        mCanvas = new Canvas();
        mPath = new Path();
        paths.add(mPath);
        h = bmp.getHeight()/2;
        rect = new Rect();
        rect.set(0,0,bmp.getWidth(),h);

    }

    @Override
    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
    }

    @Override
    protected void onDraw(Canvas canvas) {
        if (h > bmp.getHeight()) {
            return;
        }
            image = Bitmap.createBitmap(bmp,0,0,bmp.getWidth(),h);
            Rect bount = new Rect();
            bount.set(0,20,image.getWidth(),image.getHeight()-20);
            canvas.drawBitmap(image,bount,rect,mPaint);
            Log.d("canvast_ads","draw" + rect.height() + "-" + image.getHeight());
    }

    private float mX, mY;
    private static final float TOUCH_TOLERANCE = 0;
    private void touch_start(float x, float y) {
        mPath.reset();
        mPath.moveTo(x, y);
        mX = x;
        mY = y;

    }

    private void touch_move(float x, float y) {
        float dx = Math.abs(x - mX);
        float dy = Math.abs(y - mY);
        if (dx >= TOUCH_TOLERANCE || dy >= TOUCH_TOLERANCE) {
            mPath.quadTo(mX, mY, (x + mX) / 2, (y + mY) / 2);
            mX = x;
            mY = y;
        }
        Log.d("canvast_ads","touch_move" + dx + "/" + dy);

    }

    private void touch_up() {
        mPath.lineTo(mX, mY);
        // commit the path to our offscreen
        mCanvas.drawPath(mPath, mPaint);
        // kill this so we don't double draw
        mPath = new Path();
        paths.add(mPath);
        h = h + 20;
        Log.d("canvast_ads","touch_up" + mX + "/" + mY);

    }

    @Override
    public boolean onTouch(View arg0, MotionEvent event) {
        float x = event.getX();
        float y = event.getY();
        Log.d("canvast_ads","onTouch" + x + "/" + y);

        switch (event.getAction()) {
            case MotionEvent.ACTION_DOWN:
                touch_start(x, y);
                invalidate();
                break;
            case MotionEvent.ACTION_MOVE:
                touch_move(x, y);
                invalidate();
                break;
            case MotionEvent.ACTION_UP:
                touch_up();
                invalidate();
                break;
        }
        return true;
    }
}
