package playfun.ads.android.sdk.component.util;

import android.content.Context;
import android.content.res.Resources;

public class DeviceUtils {
    public static float getDensity(Context context) {
        return context.getResources().getDisplayMetrics().density;
    }
    public static int getStatusBarHeightInPixels(Context context) {
        Resources resources = context.getResources();
        int resourceId = resources.getIdentifier("status_bar_height", "dimen", "android");
        if (resourceId > 0) {
            return resources.getDimensionPixelSize(resourceId);
        }
        return 0;
    }

    public static int getScreenWidthInPixels(Context context) {
        return context.getResources().getDisplayMetrics().widthPixels;
    }

    public static int getScreenHeightInPixels(Context context) {
        return context.getResources().getDisplayMetrics().heightPixels;
    }
}
