package playfun.ads.android.sdk.component.util;

import android.content.Context;
import android.graphics.Color;
import android.graphics.Typeface;
import android.net.Uri;
import android.text.SpannableString;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.style.StyleSpan;
import android.util.TypedValue;

import com.google.android.exoplayer2.source.ExtractorMediaSource;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.upstream.DefaultDataSourceFactory;
import com.google.android.exoplayer2.util.Util;

import playfun.ads.android.sdk.component.view.PaddingBackgroundColorSpan;

public class AdsUtils {

    public static final String INLINE_BLUR = "inline-blur";
    public static final String INLINE_WHITE = "inline-white";

    public static final String POP_UP_SDK = "popup";

    public static final String PICTURE = "banner-call-action";
    public static final String ONLY_IMAGE = "only_image";

    public static final String TAG = "playfun.ads.android.sdk.component";

    public static final String LONG_IMAGES = "long-images";

    public static final String VIDEO = "videos";

    public static final String KEY_DATA = "DATA_ADS";
    public static final String REWARD_VIDEO = "reward-video";

    public static final SpannableStringBuilder setTexSpanBoder(String text, String textSpanBoder,
                                                               int texSize,Typeface typeface,
                                                               int marginRigth,int marginLeft
            ,int marginTop,int conner) {
        int flag = Spanned.SPAN_EXCLUSIVE_EXCLUSIVE;
        SpannableString staffTitleSpan = new SpannableString(text.trim());
        SpannableString staffNameSpan = new SpannableString(textSpanBoder.trim());
        staffNameSpan.setSpan(new StyleSpan(Typeface.BOLD), 0, staffNameSpan.length(), flag);
        PaddingBackgroundColorSpan paddingBackgroundColorSpan  =
                new PaddingBackgroundColorSpan
                        .PaddingBackGroundBuilder()
                        .setBackgroundColor(Color.parseColor("#C7C7CC"))
                        .setTextColor(Color.parseColor("#ffffff"))
                        .setCornerRadius(conner)
                        .setPaddingStart(marginRigth)
                        .setPadingEnd(marginLeft)
                        .setMarginStart(marginRigth)
                        .setMarginTop(marginTop)
                        .setTextSize(texSize)
                        .setTypeFace(typeface)
                .build();


        staffNameSpan.setSpan(paddingBackgroundColorSpan,0, staffNameSpan.length(), flag);
        SpannableStringBuilder builder = new SpannableStringBuilder();
        builder.append(staffTitleSpan);
        builder.append("\t" + "\t");
        builder.append(staffNameSpan);
        return builder;
    }

    public static int dpToPx(float dp, Context context) {
        return (int) TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, dp, context.getResources().getDisplayMetrics());
    }

    public static int spToPx(float sp, Context context) {
        return (int) TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_SP, sp, context.getResources().getDisplayMetrics());
    }

    public static int dpToSp(float dp, Context context) {
        return (int) (dpToPx(dp, context) / context.getResources().getDisplayMetrics().scaledDensity);
    }

}
