package playfun.ads.android.sdk.component.factory.rewards;

import android.app.Activity;
import android.util.Log;

import playfun.ads.android.sdk.component.callback.AdsFunListener;
import playfun.ads.android.sdk.component.factory.AttachViewService;
import playfun.ads.android.sdk.component.factory.RequestAdsFun;
import playfun.ads.android.sdk.component.model.networkmodel.Data;
import playfun.ads.android.sdk.component.network.Repo;
import playfun.ads.android.sdk.component.util.Constants;
import playfun.ads.android.sdk.component.util.Preference;

public class RewardVideoAds {
    private static final String TAG = RewardVideoAds.class.getSimpleName();
    public static RewardVideoAds INSTANCE;
    RequestAdsFun requestAdsFun;

    public static RewardVideoAds getInstance(){
        if(INSTANCE == null){
            INSTANCE = new RewardVideoAds();
        }
        return INSTANCE;
    }

    public void requestAds(Activity activity, String inventoryCode){
        try {
            AdsFunListener funListener = new AdsFunListener() {
                @Override
                public void reQuestAdsSuccess(Data data , int code) {
                    Log.d("TAG" , "reQuestAdsSuccess");
                    //                                                requestAdsFun.showAds();
                    if(data != null){
                        AttachViewService attachViewService = new AttachViewService() {
                            @Override
                            public void adShowing() {
                                //TODO dont call next function
                                Repo.getRePo().trackingView(data.getRaaId());
                            }

                            @Override
                            public void closeAds() {
                                //TODO can call next function
                            }
                        };
                        requestAdsFun.showAdsRewardsVideo(data , attachViewService, inventoryCode);
                    }
                }

                @Override
                public void requestAdsNativeSuccess(Data data) {

                }

                @Override
                public void isShowAds(boolean isShow) {
                    Log.d("TAG" , "isShowAds");
                }

                @Override
                public void isCloseAds(boolean isClose) {
                    Log.d("TAG" , "isCloseAds");
                }

                @Override
                public void isLoadAdsError() {
                    Log.d("TAG" , "isLoadAdsError");
                }
            };
            String packageName = Preference.getString(activity , Constants.PACKAGE_NAME);
            int versionCode = Preference.getInt(activity , Constants.VERSION_CODE , 1);
            String versionName = Preference.getString(activity , Constants.VERSION_NAME);
            String advertisingID = Preference.getString(activity , Constants.ADSVERTISING_ID);
            requestAdsFun = new RequestAdsFun.RequestAdsBuilder()
                    .adsCode(inventoryCode)
//                    .adsKey(adskey)
                    .of(activity)
                    .addListener(funListener)
                    .addPakageName(packageName)
                    .addAdsVertisingId(advertisingID)
                    .addVersionCode(versionCode)
                    .addVersionName(versionName)
                    .build();

            requestAdsFun.requestAds();
        }catch (Exception e){
            e.printStackTrace();
        }
    }
}
