package playfun.ads.android.sdk.component.factory.popupfactory;

import android.annotation.SuppressLint;
import android.content.Context;
import android.util.Log;

import playfun.ads.android.sdk.component.factory.bottomsheet.BottomSheetAds;
import playfun.ads.android.sdk.component.factory.rewards.PopupAdsRewardVideo;
import playfun.ads.android.sdk.component.util.AdsUtils;
import playfun.ads.android.sdk.component.util.PopUpEnum;

public class PopUpFactory {

    private static Context context;

    public PopUpFactory(Context context) {
        this.context = context;
    }

    @SuppressLint("LongLogTag")
    public static final BasePopUp createPopUp(PopUpEnum popUpEnum) {
        Log.i(AdsUtils.TAG,"PopUpFactory: " + "createPopUp");
        switch (popUpEnum) {
            case POPUP_WITH_VIDEO:
                return new PopUpAdsDialogVideo();
            case POPUP_WITHOUT_VIDEO:
                return new PopUpAdsDialog();
            case LONG_IMAGE:
                return new BottomSheetAds();
            case ONLY_IMAGE:
                return new PopupAdsOnlyImage();
            case REWARD_VIDEO:
                return new PopupAdsRewardVideo();
            default:
                throw new IllegalArgumentException("This Popup type is unsupported");
        }
    }
}
