/*
 * Decompiled with CFR 0.152.
 */
package playfun.ads.android.sdk.component.factory;

import android.content.Context;
import com.google.android.exoplayer2.upstream.DataSink;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.DefaultBandwidthMeter;
import com.google.android.exoplayer2.upstream.DefaultDataSourceFactory;
import com.google.android.exoplayer2.upstream.DefaultHttpDataSourceFactory;
import com.google.android.exoplayer2.upstream.FileDataSource;
import com.google.android.exoplayer2.upstream.TransferListener;
import com.google.android.exoplayer2.upstream.cache.Cache;
import com.google.android.exoplayer2.upstream.cache.CacheDataSink;
import com.google.android.exoplayer2.upstream.cache.CacheDataSource;
import com.google.android.exoplayer2.upstream.cache.CacheEvictor;
import com.google.android.exoplayer2.upstream.cache.LeastRecentlyUsedCacheEvictor;
import com.google.android.exoplayer2.upstream.cache.SimpleCache;
import com.google.android.exoplayer2.util.Util;
import java.io.File;

public class CacheDataSourceFactory
implements DataSource.Factory {
    private final Context context;
    private final DefaultDataSourceFactory defaultDatasourceFactory;
    private final long maxFileSize;
    private final long maxCacheSize;

    public CacheDataSourceFactory(Context context, long maxCacheSize, long maxFileSize) {
        this.context = context;
        this.maxCacheSize = maxCacheSize;
        this.maxFileSize = maxFileSize;
        String userAgent = Util.getUserAgent((Context)context, (String)"funads");
        DefaultBandwidthMeter bandwidthMeter = new DefaultBandwidthMeter();
        this.defaultDatasourceFactory = new DefaultDataSourceFactory(this.context, (TransferListener)bandwidthMeter, (DataSource.Factory)new DefaultHttpDataSourceFactory(userAgent, (TransferListener)bandwidthMeter));
    }

    public DataSource createDataSource() {
        LeastRecentlyUsedCacheEvictor evictor = new LeastRecentlyUsedCacheEvictor(this.maxCacheSize);
        SimpleCache simpleCache = new SimpleCache(new File(this.context.getCacheDir(), "media"), (CacheEvictor)evictor);
        return new CacheDataSource((Cache)simpleCache, (DataSource)this.defaultDatasourceFactory.createDataSource(), (DataSource)new FileDataSource(), (DataSink)new CacheDataSink((Cache)simpleCache, this.maxFileSize), 3, null);
    }
}

