package playfun.ads.android.sdk.component.factory.popupfactory;

import android.annotation.SuppressLint;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.CountDownTimer;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;

import com.bumptech.glide.Glide;
import com.bumptech.glide.request.RequestOptions;

import playfun.ads.android.sdk.R;
import playfun.ads.android.sdk.component.util.AdsUtils;

public class PopupAdsOnlyImage extends BasePopUp {
    ImageView onlyImageContent;
    Button btn_close_only_image;
    private String mAction;
    private FrameLayout view_countdown_off_only_image;
    private TextView txt_countdown_off_only_image;

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    @SuppressLint("LongLogTag")
    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.popup_only_image,container,true);
        initView(view);
        Log.i(AdsUtils.TAG,"PopUpAdsDialog: " + "onCreateView");
        return view;
    }

    private void initView(View view) {
        onlyImageContent = view.findViewById(R.id.only_image_content);
        btn_close_only_image = view.findViewById(R.id.btn_close_only_image);
        view_countdown_off_only_image = view.findViewById(R.id.view_countdown_off_only_image);
        txt_countdown_off_only_image = view.findViewById(R.id.txt_countdown_off_only_image);
        Glide.with(getActivity()).asBitmap().load(data.getMetaData().getImageBanner().getData() != null ? data.getMetaData().getImageBanner().getData() : "")
                .into(onlyImageContent);
        if(data.getMetaData().getCta0() != null && data.getMetaData().getCta0().getLink() != null) {
            mAction = data.getMetaData().getCta0().getLink();
        }
        if(data.getCountdownOff() != null){
            btn_close_only_image.setVisibility(View.GONE);
            view_countdown_off_only_image.setVisibility(View.VISIBLE);
            new CountDownTimer(data.getCountdownOff().getValue() * 1000, 1000){

                @Override
                public void onTick(long l) {
                    txt_countdown_off_only_image.setText("" + l/1000);
                }

                @Override
                public void onFinish() {
                    view_countdown_off_only_image.setVisibility(View.GONE);
                    if(data.getCountdownOff().getDoShowClose()){
                        btn_close_only_image.setVisibility(View.VISIBLE);
                    }else{
                        dismiss();
                    }
                }
            }.start();
        }

        onlyImageContent.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                try {
                    Intent intent = new Intent(Intent.ACTION_VIEW);
                    intent.setFlags(Intent.FLAG_ACTIVITY_SINGLE_TOP|Intent.FLAG_ACTIVITY_NEW_TASK);
                    intent.setData(Uri.parse(mAction));
                    startActivity(intent);
                }catch (Exception e){
                    e.printStackTrace();
                }
            }
        });

        btn_close_only_image.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                dismiss();
            }
        });
    }

    @Override
    public void onResume() {
        super.onResume();
    }

    @Override
    public void onPause() {
        super.onPause();
    }

    @Override
    public void onStop() {
        super.onStop();
    }

}
