/*
 * Decompiled with CFR 0.152.
 */
package playfun.ads.android.sdk.component.view;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.LinearInterpolator;
import java.util.concurrent.TimeUnit;
import playfun.ads.android.sdk.R;

public class TimerView
extends View {
    private static final int ARC_START_ANGLE = 270;
    private static final float THICKNESS_SCALE = 0.09f;
    private Bitmap mBitmap;
    private Canvas mCanvas;
    private RectF mCircleOuterBounds;
    private RectF mCircleInnerBounds;
    private Paint mCirclePaint;
    private Paint mEraserPaint;
    private float mCircleSweepAngle;
    private ValueAnimator mTimerAnimator;

    public TimerView(Context context) {
        this(context, null);
    }

    public TimerView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public TimerView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray ta;
        int circleColor = -65536;
        if (attrs != null && (ta = context.obtainStyledAttributes(attrs, R.styleable.TimerView)) != null) {
            circleColor = ta.getColor(R.styleable.TimerView_circleColor, circleColor);
            ta.recycle();
        }
        this.mCirclePaint = new Paint();
        this.mCirclePaint.setAntiAlias(true);
        this.mCirclePaint.setColor(circleColor);
        this.mEraserPaint = new Paint();
        this.mEraserPaint.setAntiAlias(true);
        this.mEraserPaint.setColor(0);
        this.mEraserPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.CLEAR));
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, widthMeasureSpec);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        if (w != oldw || h != oldh) {
            this.mBitmap = Bitmap.createBitmap((int)w, (int)h, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            this.mBitmap.eraseColor(0);
            this.mCanvas = new Canvas(this.mBitmap);
        }
        super.onSizeChanged(w, h, oldw, oldh);
        this.updateBounds();
    }

    protected void onDraw(Canvas canvas) {
        this.mCanvas.drawColor(0, PorterDuff.Mode.CLEAR);
        if (this.mCircleSweepAngle > 0.0f) {
            this.mCanvas.drawArc(this.mCircleOuterBounds, 270.0f, this.mCircleSweepAngle, true, this.mCirclePaint);
            this.mCanvas.drawOval(this.mCircleInnerBounds, this.mEraserPaint);
        }
        canvas.drawBitmap(this.mBitmap, 0.0f, 0.0f, null);
    }

    public void start(int secs) {
        this.stop();
        this.mTimerAnimator = ValueAnimator.ofFloat((float[])new float[]{1.0f, 0.0f});
        this.mTimerAnimator.setDuration(TimeUnit.SECONDS.toMillis(secs));
        this.mTimerAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
        this.mTimerAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                TimerView.this.drawProgress(((Float)animation.getAnimatedValue()).floatValue());
            }
        });
        this.mTimerAnimator.start();
    }

    public void stop() {
        if (this.mTimerAnimator != null && this.mTimerAnimator.isRunning()) {
            this.mTimerAnimator.cancel();
            this.mTimerAnimator = null;
            this.drawProgress(0.0f);
        }
    }

    private void drawProgress(float progress) {
        this.mCircleSweepAngle = 360.0f * progress;
        this.invalidate();
    }

    private void updateBounds() {
        float thickness = (float)this.getWidth() * 0.09f;
        this.mCircleOuterBounds = new RectF(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight());
        this.mCircleInnerBounds = new RectF(this.mCircleOuterBounds.left + thickness, this.mCircleOuterBounds.top + thickness, this.mCircleOuterBounds.right - thickness, this.mCircleOuterBounds.bottom - thickness);
        this.invalidate();
    }
}

