package playfun.ads.android.sdk.component.factory.nativeads;

import android.content.Context;
import android.content.Intent;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Handler;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageView;
import android.widget.RelativeLayout;

import com.bumptech.glide.Glide;

import playfun.ads.android.sdk.R;
import playfun.ads.android.sdk.component.callback.AdsFunListener;
import playfun.ads.android.sdk.component.factory.RequestAdsFun;
import playfun.ads.android.sdk.component.model.networkmodel.Data;

public class NativeAdsSmallImage extends RelativeLayout {
    private ImageView img_small_content;
    String code , packageName , versionName;
    int versionCode;

    public NativeAdsSmallImage(Context context) {
        this(context, null);
    }

    public NativeAdsSmallImage(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public NativeAdsSmallImage(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        LayoutInflater.from(context).inflate(R.layout.native_ads_small_image, this);
        img_small_content = (ImageView) findViewById(R.id.img_small_content);
    }

    public void setImageToView(Context context , String url , String urlAction){
        Glide.with(context).asBitmap().load(url != null ? url : "")
                .into(img_small_content);
        img_small_content.setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View view) {
                Log.d("TAG" , "click to here");
                Intent intent = new Intent(Intent.ACTION_VIEW);
                intent.setFlags(Intent.FLAG_ACTIVITY_SINGLE_TOP|Intent.FLAG_ACTIVITY_NEW_TASK);
                intent.setData(Uri.parse(urlAction));
                context.startActivity(intent);
            }
        });
    }
}
