/*
 * Decompiled with CFR 0.152.
 */
package playfun.ads.android.sdk.component.factory.nativeads;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.TypedArray;
import android.net.Uri;
import android.os.Handler;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.request.RequestOptions;
import com.google.android.exoplayer2.ExoPlayerFactory;
import com.google.android.exoplayer2.Player;
import com.google.android.exoplayer2.SimpleExoPlayer;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.ui.PlayerView;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.Util;
import com.google.gson.Gson;
import de.hdodenhof.circleimageview.CircleImageView;
import playfun.ads.android.sdk.R;
import playfun.ads.android.sdk.component.callback.AdsFunListener;
import playfun.ads.android.sdk.component.factory.RequestAdsFun;
import playfun.ads.android.sdk.component.model.networkmodel.Data;
import playfun.ads.android.sdk.component.util.MediaSourseInstance;

public class NativeAdsFeeds
extends RelativeLayout
implements Player.EventListener {
    RequestAdsFun requestAdsFun;
    String code;
    String packageName;
    String versionName;
    int idInventory;
    int versionCode;
    private final CircleImageView img_logo;
    private final ImageView image_content;
    private final ImageView image_thump_loading;
    private final TextView text_title;
    private final TextView text_description;
    private final TextView text_install;
    private final LinearLayout view_title;
    private final LinearLayout layout_install;
    private final Button btn_playnow;
    private MediaSource mediaSource;
    public PlayerView playerView;
    public SimpleExoPlayer player;
    private final RelativeLayout nativeFeedLayout;

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (Util.SDK_INT <= 23) {
            if (this.playerView != null) {
                this.playerView.onPause();
            }
            this.releasePlayer();
        }
    }

    private void releasePlayer() {
        if (this.player != null) {
            this.player.release();
            this.player = null;
        }
    }

    public NativeAdsFeeds(Context context) {
        this(context, null);
    }

    public NativeAdsFeeds(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public NativeAdsFeeds(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        LayoutInflater.from((Context)context).inflate(R.layout.native_ads_feed, (ViewGroup)this);
        this.nativeFeedLayout = (RelativeLayout)this.findViewById(R.id.layout_native_feed);
        this.img_logo = (CircleImageView)this.findViewById(R.id.img_logo);
        this.image_content = (ImageView)this.findViewById(R.id.image_content);
        this.image_thump_loading = (ImageView)this.findViewById(R.id.image_thump_loading);
        this.text_title = (TextView)this.findViewById(R.id.text_title);
        this.text_description = (TextView)this.findViewById(R.id.text_description);
        this.text_install = (TextView)this.findViewById(R.id.text_install);
        this.view_title = (LinearLayout)this.findViewById(R.id.view_title);
        this.layout_install = (LinearLayout)this.findViewById(R.id.layout_install);
        this.btn_playnow = (Button)this.findViewById(R.id.btn_playnow);
        this.playerView = (PlayerView)this.findViewById(R.id.video_view_video);
        this.playerView.setShutterBackgroundColor(0);
        this.requestNativeAds(context, attrs);
        android.util.Log.d((String)"TAG ", (String)("Something : " + this.code));
    }

    private void requestNativeAds(final Context context, AttributeSet attrs) {
        TypedArray typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.NativeAdsFeeds, 0, 0);
        this.code = typedArray.getString(R.styleable.NativeAdsFeeds_inventoryId);
        this.versionName = typedArray.getString(R.styleable.NativeAdsFeeds_versionName);
        this.packageName = typedArray.getString(R.styleable.NativeAdsFeeds_packagename);
        this.versionCode = typedArray.getInt(R.styleable.NativeAdsFeeds_versionCode, 1);
        AdsFunListener funListener = new AdsFunListener(){

            @Override
            public void reQuestAdsSuccess(Data data, int code) {
                android.util.Log.d((String)"TAG", (String)"reQuestAdsSuccess");
            }

            @Override
            public void requestAdsNativeSuccess(final Data data) {
                try {
                    if (data.getMetaData() != null) {
                        NativeAdsFeeds.this.nativeFeedLayout.setVisibility(0);
                        Gson gson = new Gson();
                        String dataStr = gson.toJson((Object)data);
                        android.util.Log.d((String)"TAG", (String)("Something data : " + dataStr));
                        Glide.with((Context)context).asBitmap().load(data.getMetaData().getLogoImage().getData() != null ? data.getMetaData().getLogoImage().getData() : "").apply(new RequestOptions().override((int)NativeAdsFeeds.this.getResources().getDimension(R.dimen._32sdp), (int)NativeAdsFeeds.this.getResources().getDimension(R.dimen._32sdp))).into((ImageView)NativeAdsFeeds.this.img_logo);
                        NativeAdsFeeds.this.text_title.setText((CharSequence)data.getMetaData().getLongTitle().getData());
                        NativeAdsFeeds.this.text_description.setText((CharSequence)data.getMetaData().getLongDescription().getData());
                        if (data.getMetaData().getImageBanner() != null) {
                            Glide.with((Context)context).asBitmap().load(data.getMetaData().getImageBanner().getData() != null ? data.getMetaData().getImageBanner().getData() : "").into(NativeAdsFeeds.this.image_content);
                        }
                        View.OnClickListener onClickListener = new View.OnClickListener(){

                            public void onClick(View view) {
                                android.util.Log.d((String)"TAG", (String)"click to here");
                                Intent intent = new Intent("android.intent.action.VIEW");
                                intent.setFlags(0x30000000);
                                intent.setData(Uri.parse((String)data.getMetaData().getCta0().getLink()));
                                context.startActivity(intent);
                            }
                        };
                        if (data.getMetaData().getImageBanner() != null) {
                            NativeAdsFeeds.this.image_content.setOnClickListener(onClickListener);
                            NativeAdsFeeds.this.image_content.setVisibility(0);
                            NativeAdsFeeds.this.image_thump_loading.setVisibility(8);
                            NativeAdsFeeds.this.playerView.setVisibility(8);
                        }
                        if (data.getMetaData().getVideo() != null) {
                            NativeAdsFeeds.this.image_content.setVisibility(8);
                            NativeAdsFeeds.this.image_thump_loading.setVisibility(0);
                            NativeAdsFeeds.this.playerView.setVisibility(0);
                        }
                        NativeAdsFeeds.this.img_logo.setOnClickListener(onClickListener);
                        NativeAdsFeeds.this.text_title.setOnClickListener(onClickListener);
                        NativeAdsFeeds.this.text_description.setOnClickListener(onClickListener);
                        NativeAdsFeeds.this.text_install.setOnClickListener(onClickListener);
                        NativeAdsFeeds.this.view_title.setOnClickListener(onClickListener);
                        NativeAdsFeeds.this.layout_install.setOnClickListener(onClickListener);
                        NativeAdsFeeds.this.btn_playnow.setOnClickListener(onClickListener);
                        if (data.getMetaData().getVideo() != null) {
                            if (data.getMetaData().getVideo().getData() != null) {
                                MediaSourseInstance.getInstance().buildMediaSource(context.getApplicationContext(), data.getMetaData().getVideo().getData().replace(" ", "%20"));
                            }
                            if (Util.SDK_INT > 23) {
                                Activity activity = (Activity)context;
                                NativeAdsFeeds.this.initializePlayer(activity);
                                if (NativeAdsFeeds.this.playerView != null) {
                                    NativeAdsFeeds.this.playerView.onResume();
                                }
                            }
                        }
                    } else {
                        NativeAdsFeeds.this.nativeFeedLayout.setVisibility(8);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void isShowAds(boolean isShow) {
                android.util.Log.d((String)"TAG", (String)"isShowAds");
            }

            @Override
            public void isCloseAds(boolean isClose) {
                android.util.Log.d((String)"TAG", (String)"isCloseAds");
            }

            @Override
            public void isLoadAdsError() {
                android.util.Log.d((String)"TAG", (String)"isLoadAdsError");
                NativeAdsFeeds.this.nativeFeedLayout.setVisibility(8);
            }
        };
        this.requestAdsFun = new RequestAdsFun.RequestAdsBuilder().adsCode(this.code).of(context).addListener(funListener).adsUserId("userId").addPakageName(this.packageName).addVersionCode(this.versionCode).addVersionName(this.versionName).build();
        this.requestAdsFun.requestAds();
    }

    private synchronized void initializePlayer(final Activity context) {
        new Handler().post(new Runnable(){

            @Override
            public void run() {
                NativeAdsFeeds.this.mediaSource = NativeAdsFeeds.this.buildMediaSource();
                try {
                    if (NativeAdsFeeds.this.mediaSource != null) {
                        if (NativeAdsFeeds.this.player == null) {
                            NativeAdsFeeds.this.initPlayer(context);
                        }
                        NativeAdsFeeds.this.player.prepare(NativeAdsFeeds.this.mediaSource);
                        NativeAdsFeeds.this.player.setPlayWhenReady(true);
                    }
                    Log.i((String)"playfun.ads.android.sdk.component", (String)("PopUpAdsDialogVideo: initializePlayer " + NativeAdsFeeds.this.mediaSource.toString()));
                }
                catch (Exception e) {
                    System.out.println("player is null");
                }
            }
        });
    }

    @SuppressLint(value={"NewApi"})
    private void initPlayer(Activity context) {
        if (context == null) {
            return;
        }
        try {
            if (this.player == null) {
                this.player = ExoPlayerFactory.newSimpleInstance((Context)context);
                this.playerView.setPlayer((Player)this.player);
                this.player.addListener((Player.EventListener)this);
            }
        }
        catch (Exception e) {
            System.out.println("can not initalize, Player view is null");
        }
        Log.i((String)"playfun.ads.android.sdk.component", (String)"PopUpAdsDialogVideo: initPlayer");
    }

    private MediaSource buildMediaSource() {
        MediaSource videoSource = null;
        try {
            videoSource = MediaSourseInstance.getInstance().getVideoSource();
        }
        catch (Exception e) {
            System.out.println("Media sourse is null");
        }
        return videoSource;
    }

    public void onPlayerStateChanged(boolean playWhenReady, int playbackState) {
        Log.d((String)"Exodebug", (String)("onPlayerStateChanged" + playWhenReady + "/" + playbackState));
        switch (playbackState) {
            case 3: {
                this.image_thump_loading.setVisibility(8);
            }
            case 2: {
                break;
            }
            case 4: {
                this.initFrameFinishVideo();
                break;
            }
        }
    }

    private void initFrameFinishVideo() {
        try {
            this.player.seekTo(this.player.getDuration() - 4000L);
            this.playerView.onPause();
            this.player.setPlayWhenReady(false);
        }
        catch (Exception e) {
            System.out.println("Player is null");
        }
    }
}

