/*
 * Decompiled with CFR 0.152.
 */
package playfun.ads.android.sdk.component.view;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.text.style.ReplacementSpan;
import androidx.annotation.NonNull;

public class PaddingBackgroundColorSpan
extends ReplacementSpan {
    private int mBackgroundColor;
    private int mTextColor;
    private float mCornerRadius;
    private float mPaddingStart;
    private float mPaddingEnd;
    private float mMarginStart;
    private float mMarginTop;
    private int textSize;
    private Typeface typeface;

    public PaddingBackgroundColorSpan(int backgroundColor, int textColor, float cornerRadius, float paddingStart, float paddingEnd, float marginStart, float mMarginTop, int textSize, Typeface typeface) {
        this.mBackgroundColor = backgroundColor;
        this.mTextColor = textColor;
        this.mCornerRadius = cornerRadius;
        this.mPaddingStart = paddingStart;
        this.mPaddingEnd = paddingEnd;
        this.mMarginStart = marginStart;
        this.mMarginTop = mMarginTop;
        this.textSize = textSize;
        this.typeface = typeface;
    }

    public int getSize(@NonNull Paint paint, CharSequence text, int start, int end, Paint.FontMetricsInt fm) {
        return (int)(this.mPaddingStart + paint.measureText(text.subSequence(start, end).toString()) + this.mPaddingEnd);
    }

    public void draw(@NonNull Canvas canvas, CharSequence text, int start, int end, float x, int top, int y, int bottom, @NonNull Paint paint) {
        float width = paint.measureText(text.subSequence(start, end).toString());
        RectF rect = new RectF(x, (float)top, x + width + this.mMarginStart, (float)bottom);
        paint.setColor(this.mBackgroundColor);
        canvas.drawRoundRect(rect, this.mCornerRadius, this.mCornerRadius, paint);
        paint.setColor(this.mTextColor);
        paint.setTextSize((float)this.textSize);
        paint.setTypeface(this.typeface);
        canvas.drawText(text, start, end, x + (this.mMarginStart - 3.0f), (float)y - this.mMarginTop, paint);
    }

    public static class PaddingBackGroundBuilder {
        private int mBackgroundColor;
        private int mTextColor;
        private float mCornerRadius;
        private float mPaddingStart;
        private float mPaddingEnd;
        private float mMarginStart;
        private float mMarginTop;
        private int mTextSize;
        private Typeface typeface;

        public PaddingBackGroundBuilder setBackgroundColor(int backgroundColor) {
            this.mBackgroundColor = backgroundColor;
            return this;
        }

        public PaddingBackGroundBuilder setTextColor(int textColor) {
            this.mTextColor = textColor;
            return this;
        }

        public PaddingBackGroundBuilder setCornerRadius(int cornerRadius) {
            this.mCornerRadius = cornerRadius;
            return this;
        }

        public PaddingBackGroundBuilder setPaddingStart(int paddingStart) {
            this.mPaddingStart = paddingStart;
            return this;
        }

        public PaddingBackGroundBuilder setPadingEnd(int mPaddingEnd) {
            this.mPaddingEnd = mPaddingEnd;
            return this;
        }

        public PaddingBackGroundBuilder setMarginStart(int marginStart) {
            this.mMarginStart = marginStart;
            return this;
        }

        public PaddingBackGroundBuilder setMarginTop(int marginTop) {
            this.mMarginTop = marginTop;
            return this;
        }

        public PaddingBackGroundBuilder setTextSize(int textSize) {
            this.mTextSize = textSize;
            return this;
        }

        public PaddingBackGroundBuilder setTypeFace(Typeface typeFace) {
            this.typeface = typeFace;
            return this;
        }

        public PaddingBackgroundColorSpan build() {
            return new PaddingBackgroundColorSpan(this.mBackgroundColor, this.mTextColor, this.mCornerRadius, this.mPaddingStart, this.mPaddingEnd, this.mMarginStart, this.mMarginTop, this.mTextSize, this.typeface);
        }
    }
}

