package playfun.ads.android.sdk.component.view;

import android.content.Context;
import android.content.res.TypedArray;
import androidx.annotation.Nullable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;

import playfun.ads.android.sdk.R;

public class DownloadView extends RelativeLayout {

    private TextView textView;
    private int mTextSize;
    private String mText;
    private int mWidth,mHeigth;
    public DownloadView(Context context) {
        super(context);
        initView(context);
    }

    public DownloadView(Context context,  @Nullable AttributeSet attrs) {
        super(context, attrs);
        TypedArray a = context.getTheme().obtainStyledAttributes(
                attrs,
                R.styleable.DownloadView,
                0, 0);
        mTextSize = a.getInt(R.styleable.DownloadView_buttonTextSize,0);
        mText = a.getString(R.styleable.DownloadView_buttonText);
        mHeigth = a.getInt(R.styleable.DownloadView_buttonHeigth,0);
        mWidth = a.getInt(R.styleable.DownloadView_buttonWith,0);
        initView(context);
    }

    public DownloadView(Context context,  @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        initView(context);
    }

    public void initView(Context context) {
        View view = LayoutInflater.from(context).inflate(R.layout.download_view,this,true);
        textView = view.findViewById(R.id.tv_download);
        textView.setText(mText);
        textView.setTextSize(mTextSize);
        LayoutParams layoutParams = new LayoutParams(ViewGroup.LayoutParams.WRAP_CONTENT, ViewGroup.LayoutParams.WRAP_CONTENT);
        layoutParams.rightMargin = 5;
        textView.setLayoutParams(layoutParams);
    }
}
