package playfun.ads.android.sdk.component.factory.bottomsheet;

import android.annotation.SuppressLint;
import android.app.DialogFragment;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.os.CountDownTimer;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.google.android.material.bottomsheet.BottomSheetBehavior;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.bumptech.glide.Glide;
import com.bumptech.glide.request.target.SimpleTarget;
import com.bumptech.glide.request.transition.Transition;

import playfun.ads.android.sdk.R;
import playfun.ads.android.sdk.component.blur.BlurLayout;
import playfun.ads.android.sdk.component.callback.AdsFunListener;
import playfun.ads.android.sdk.component.factory.popupfactory.BasePopUp;
import playfun.ads.android.sdk.component.util.AdsUtils;
import playfun.ads.android.sdk.component.util.ImageHelper;
import playfun.ads.android.sdk.component.util.ScreenUtil;
import playfun.ads.android.sdk.component.view.InteractiveScrollView;

public class BottomSheetAds extends BasePopUp implements InteractiveScrollView.OnBottomReachedListener {
    private
    BottomSheetBehavior bottomSheetBehavior;
    private InteractiveScrollView bottom_sheet_ads_scrollView;
    private RelativeLayout bottom_sheet_ads, bottom_sheet_ads_finish, bottomsheet_btn_download;
    private LinearLayout bottom_sheet_ads_footer_info_land;
    private ImageView bottomsheet_image_Content, bottom_sheet_ads_image_header, footer_image_icon, bottomsheet_image_icon, ic_scroll;
    private Button btn_close_scroll_image, footer_btn_download;
    private TextView footer_tv_title, footer_tv_content, bottomsheet_tv_title, bottomsheet_tv_content, bottomseet_tv_btndownload;
    private BlurLayout bottom_sheet_ads_footer;
    private boolean isShowFinishLayout, isShowFooter;
    private View view;
    private AdsFunListener listener;
    private FrameLayout view_countdown_off;
    private TextView txt_countdown_off;

    @SuppressLint("LongLogTag")
    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setStyle(DialogFragment.STYLE_NO_FRAME, R.style.Popup_scroll_image);
        Log.i(AdsUtils.TAG,"BottomSheetAds: " + "onCreate");
    }

    @SuppressLint("LongLogTag")
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        view = inflater.inflate(R.layout.popup_image_scroll, container, true);
        bottom_sheet_ads = view.findViewById(R.id.bottom_sheet_ads);
        btn_close_scroll_image = view.findViewById(R.id.bottom_sheet_ads_btn_close);
        bottom_sheet_ads_scrollView = view.findViewById(R.id.bottom_sheet_ads_scrollView);
        bottomsheet_image_Content = view.findViewById(R.id.bottom_sheet_ads_image_content);
        bottom_sheet_ads_finish = view.findViewById(R.id.bottom_sheet_ads_finish);

        view_countdown_off = view.findViewById(R.id.view_countdown_off);
        txt_countdown_off = view.findViewById(R.id.txt_countdown_off);

        if(!ScreenUtil.isLandScape(getActivity())){
            bottom_sheet_ads_footer = view.findViewById(R.id.bottom_sheet_ads_footer);
            footer_tv_title = view.findViewById(R.id.footer_tv_title);
            footer_tv_content = view.findViewById(R.id.footer_tv_content);
            footer_image_icon = view
                    .findViewById(R.id.footer_image_icon);
            bottom_sheet_ads_finish.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    sendAction();
                }
            });
        }

        ic_scroll = view
                .findViewById(R.id.ic_scroll);

        footer_btn_download = view.findViewById(R.id.footer_btn_download);

        bottom_sheet_ads_image_header = view.findViewById(R.id.bottom_sheet_ads_image_header);


        bottomsheet_image_icon = view.findViewById(R.id.bottom_sheet_ads_image_icon);
        bottomsheet_tv_title = view.findViewById(R.id.bottom_sheet_ads_tv_tittle);
        bottomsheet_tv_content = view.findViewById(R.id.bottom_sheet_ads_tv_content);


        bottomsheet_tv_title.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                sendAction();
            }
        });
        bottomsheet_tv_content.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                sendAction();
            }
        });
        bottomsheet_image_icon.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                sendAction();
            }
        });
        if(!ScreenUtil.isLandScape(getActivity())){
            bottomsheet_btn_download = view.findViewById(R.id.bottom_sheet_ads_btn_download);
            bottomseet_tv_btndownload = view.findViewById(R.id.bottom_sheet_ads_tv_btn_download);
            bottom_sheet_ads_footer = view.findViewById(R.id.bottom_sheet_ads_footer);
            bottom_sheet_ads_footer.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    sendAction();
                }
            });
            bottomsheet_image_icon.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    sendAction();
                }
            });
            footer_image_icon.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    sendAction();
                }
            });
            footer_tv_title.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    sendAction();
                }
            });
            footer_tv_content.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    sendAction();
                }
            });

        }else{
            bottom_sheet_ads_footer_info_land = view.findViewById(R.id.bottom_sheet_ads_footer_info_land);
            bottom_sheet_ads_footer_info_land.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    sendAction();
                }
            });
        }
        bottomSheetBehavior = BottomSheetBehavior.from(bottom_sheet_ads);
        bottomSheetBehavior.setPeekHeight((int) getResources().getDimension(R.dimen._297sdp));
        bottomSheetBehavior.setState(BottomSheetBehavior.STATE_COLLAPSED);
        bottomSheetBehavior.setSkipCollapsed(true);
        bottom_sheet_ads_scrollView.setOnBottomReachedListener(this);
        initView();
        btn_close_scroll_image.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                dismiss();
            }
        });
        if(!ScreenUtil.isLandScape(getActivity()))
        bottomsheet_btn_download.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                sendAction();
            }
        });

        footer_btn_download.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                sendAction();
            }
        });


        Log.i(AdsUtils.TAG,"BottomSheetAds: " + "onCreateView");
        return view;
    }

    @SuppressLint("LongLogTag")
    private void initView() {
        try {
            if(data.getCountdownOff() != null){
                view_countdown_off.setVisibility(View.VISIBLE);
                btn_close_scroll_image.setVisibility(View.GONE);
                new CountDownTimer(data.getCountdownOff().getValue() * 1000 , 1000){

                    @Override
                    public void onTick(long l) {
                        txt_countdown_off.setText("" + l/1000);
                    }

                    @Override
                    public void onFinish() {
                        view_countdown_off.setVisibility(View.GONE);
                        if(data.getCountdownOff().getDoShowClose()){
                            btn_close_scroll_image.setVisibility(View.VISIBLE);
                        }else{
                            dismiss();
                        }
                    }
                }.start();
            }


            bottomsheet_tv_title.setText(data.getMetaData().getShortTitle().getData() != null ? data.getMetaData().getShortTitle().getData() : "");
            bottomsheet_tv_content.setText(data.getMetaData().getShortDescription().getData() != null ? data.getMetaData().getShortDescription().getData() : "");
            if(!ScreenUtil.isLandScape(getActivity())){
                footer_tv_title.setText(data.getMetaData().getShortTitle().getData() != null ? data.getMetaData().getShortTitle().getData() : "");
                footer_tv_content.setText(data.getMetaData().getLongDescription().getData() != null ? data.getMetaData().getLongDescription().getData() : "");
            }
            Glide.with(this).asBitmap().load(data.getMetaData().getLogoImage().getData() != null ? data.getMetaData().getLogoImage().getData() : "").into(new SimpleTarget<Bitmap>() {
                @Override
                public void onResourceReady(@NonNull Bitmap resource, @Nullable Transition<? super Bitmap> transition) {
                    if(!ScreenUtil.isLandScape(getActivity())){
                        footer_image_icon.setImageBitmap(ImageHelper.getRoundedCornerBitmap(resource, ImageHelper.getCornerPixel(resource, 20)));
                    }
                    bottomsheet_image_icon.setImageBitmap(ImageHelper.getRoundedCornerBitmap(resource, ImageHelper.getCornerPixel(resource, 20)));
                }
            });

            Glide.with(this).load(data.getMetaData().getImageBanner().getData() != null ? data.getMetaData().getImageBanner().getData() : "").into(bottom_sheet_ads_image_header);
            Glide.with(this).asBitmap().load(data.getMetaData().getImage().getData() != null ? data.getMetaData().getImage().getData() : "").into(new SimpleTarget<Bitmap>() {
                @Override
                public void onResourceReady(@NonNull Bitmap resource, @Nullable Transition<? super Bitmap> transition) {
                    bottomsheet_image_Content.setImageBitmap(resource);
                }
            });

            if (data.getMetaData().getCta1() != null && data.getMetaData().getCta0() != null) {
                if(!ScreenUtil.isLandScape(getActivity()))
                bottomseet_tv_btndownload.setText(data.getMetaData().getCta1().getLabel());
                footer_btn_download.setText(data.getMetaData().getCta0().getLabel());
            } else {
                if(!ScreenUtil.isLandScape(getActivity()))
                bottomseet_tv_btndownload.setText(data.getMetaData().getCta0().getLabel() != null ? data.getMetaData().getCta0().getLabel() : "");
                footer_btn_download.setText(data.getMetaData().getCta0().getLabel() != null ? data.getMetaData().getCta0().getLabel() : "");
            }
            Log.i(AdsUtils.TAG,"BottomSheetAds: " + "initView");
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    @Override
    public void onBottomReached() {
        Log.d("adsView", "onBottomReached");
        if(!ScreenUtil.isLandScape(getActivity())){
            showFinishLayout();
        }
    }

    private void showFinishLayout() {
        if (isShowFinishLayout) {
            return;
        }
        bottom_sheet_ads_finish.postDelayed(new Runnable() {
            @Override
            public void run() {
                bottom_sheet_ads_footer.setVisibility(View.GONE);
                Animation animationfooter = AnimationUtils.loadAnimation(getActivity(),
                        R.anim.sidedown);
                bottom_sheet_ads_footer.setAnimation(animationfooter);
                isShowFinishLayout = true;
                isShowFooter = false;
            }
        }, 0);
    }

    @Override
    public void onTopReached(int scrollY) {
        if (ic_scroll.getVisibility() != View.VISIBLE) {
            ic_scroll.setVisibility(View.VISIBLE);
        }
    }

    @Override
    public void onScrolledDown(int scrollY) {
        if(!ScreenUtil.isLandScape(getActivity())){
            showFooter();
        }
    }

    @Override
    public void onScrolledUp(int scrollY) {
        if (ic_scroll.getVisibility() == View.VISIBLE) {
            ic_scroll.setVisibility(View.GONE);
        }
    }

    private void showFooter() {
        if (isShowFooter) {
            return;
        }
        bottom_sheet_ads_finish.postDelayed(new Runnable() {
            @Override
            public void run() {
                bottom_sheet_ads_footer.setVisibility(View.VISIBLE);
                Animation animationfooter = AnimationUtils.loadAnimation(getActivity(),
                        R.anim.bottom_to_top);
                bottom_sheet_ads_footer.setAnimation(animationfooter);
                isShowFinishLayout = false;
                isShowFooter = true;
            }
        }, 0);
    }

}
