package playfun.ads.android.sdk.component.factory;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.CountDownTimer;
import androidx.appcompat.app.AppCompatActivity;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;

import com.bumptech.glide.Glide;

import playfun.ads.android.sdk.R;
import playfun.ads.android.sdk.component.callback.AdsFunListener;
import playfun.ads.android.sdk.component.callback.FundAdsRequestCallBackImpl;
import playfun.ads.android.sdk.component.factory.bannerfactory.BannerAdsBlur;
import playfun.ads.android.sdk.component.factory.bannerfactory.BannerAdsWhite;
import playfun.ads.android.sdk.component.model.networkmodel.AdsFunModel;
import playfun.ads.android.sdk.component.model.networkmodel.Data;
import playfun.ads.android.sdk.component.network.Repo;
import playfun.ads.android.sdk.component.observer.AdsServices;
import playfun.ads.android.sdk.component.sate.FunAdsView;
import playfun.ads.android.sdk.component.util.AdsUtils;
import playfun.ads.android.sdk.component.util.MediaSourseInstance;
import playfun.ads.android.sdk.component.util.PopUpType;
import playfun.ads.android.sdk.component.util.ScreenUtil;
import playfun.ads.android.sdk.component.util.UserInfor;
import playfun.ads.android.sdk.component.util.Utils;
import playfun.ads.android.sdk.component.view.TimerView;
import retrofit2.Call;
import retrofit2.Response;

public class RequestAdsFun {
    private AdsFunFactory adsFunFactory;
    private View viewNotice , viewDropdown , viewDropdownText;

    private int iventoriId;
    private String iventoriCode;

    private AdsServices services;

    private Data data;

    private final AdsFunListener listener;

    private Context context;

    private String userId = "";

    private String package_name = "";

    private String version_name = "";

    private int version_code = 0;

    private String advertisingId = "";
    private String isVip = "";
    TextView textCountdownDropdown;

    public RequestAdsFun(String adsKey ,int iventoriId, String inventoryCode, Context context, AdsFunListener listener,String userId
            ,String package_name,String version_name,int version_code, String advertisingId , String isVip) {
        super();
        this.iventoriId = iventoriId;
        this.iventoriCode = inventoryCode;
        this.context = context;
        this.listener = listener;
        this.userId = userId;
        this.package_name = package_name;
        this.version_name = version_name;
        this.version_code = version_code;
        this.advertisingId = advertisingId;
        this.isVip = isVip;
        UserInfor userInfor = UserInfor.getInstance();
        userInfor.setPackage_name(this.package_name);
        userInfor.setIsVip(this.isVip);
        userInfor.setUserId(this.userId);
        userInfor.setVersion_name(this.version_name);
        userInfor.setVersion_code(String.valueOf(this.version_code));
        userInfor.setDevice_resolution("w:" + ScreenUtil.getWidthDevices(context)
                + "\t" + "h:" + ScreenUtil.getHeigtDevices(context));
        userInfor.setPackage_name(context.getPackageName());
        userInfor.setAdvertisingId(this.advertisingId);
        if (ScreenUtil.isLandScape(context)) {
            userInfor.setOrientation("landScape");
            return;
        }
        userInfor.setOrientation("portrait");
    }

    public Context getContext() {
        return context;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public int getIventoriId() {
        return iventoriId;
    }

    public void setIventoriId(int iventoriId) {
        this.iventoriId = iventoriId;
    }

    public String getIventoriCode() {
        return iventoriCode;
    }
    public void setIventoriCode(String iventoriCode) {
        this.iventoriCode = iventoriCode;
    }

    public void showAdsAfterCountdown(int countdown){
        AppCompatActivity activity = (AppCompatActivity) context;
        if(countdown >= 0){
            activity.runOnUiThread(new Runnable() {
                @Override
                public void run() {
                    ViewGroup rootView = activity.findViewById(android.R.id.content);
                    LayoutInflater inflater = LayoutInflater.from(activity);
                    if (viewNotice == null) viewNotice = inflater.inflate(R.layout.count_down_view, null);
                    TextView textCountdown = viewNotice.findViewById(R.id.text_count_down);
                    rootView.addView(viewNotice);
                    new CountDownTimer(countdown * 1000 , 1000){

                        @Override
                        public void onTick(long l) {
                            textCountdown.setText(" " + l/1000 + "s");
                        }

                        @Override
                        public void onFinish() {
                            rootView.removeView(viewNotice);
                            showAds();
                        }
                    }.start();
                }
            });
        }
    }

    public void showAdsDropdown(Data data, AttachViewService attachViewService, String inventoryCode , int inventoryId){
        AppCompatActivity activity = (AppCompatActivity) context;
        activity.runOnUiThread(new Runnable() {
            @Override
            public void run() {
                try {
                    ViewGroup rootView = activity.findViewById(android.R.id.content);
                    LayoutInflater inflater = LayoutInflater.from(activity);

                    if(viewDropdown == null) {
                        viewDropdown = inflater.inflate(R.layout.drop_down_view , null);
                    }else {
                        return;
                    }
                    FrameLayout layout_content_dropdown = viewDropdown.findViewById(R.id.layout_content_dropdown);
                    ImageView banner_imageView_dropdown = viewDropdown.findViewById(R.id.banner_imageView_dropdown);
                    TextView banner_tv_title_dropdown = viewDropdown.findViewById(R.id.banner_tv_title_dropdown);
                    TextView banner_tv_content_dropdown = viewDropdown.findViewById(R.id.banner_tv_content_dropdown);
                    Button btn_download_now_dropdown = viewDropdown.findViewById(R.id.btn_download_now_dropdown);


                    banner_tv_title_dropdown.setText(data.getMetaData().getShortTitle() != null ?
                            data.getMetaData().getShortTitle().getData() : "");
                    banner_tv_content_dropdown.setText(data.getMetaData().getShortDescription() != null ?
                            data.getMetaData().getShortDescription().getData() : "");
                    Glide.with(activity).asBitmap().load(data.getMetaData().getLogoImage().getData() != null ? data.getMetaData().getLogoImage().getData() : "")
                            .into(banner_imageView_dropdown);
                    if(ScreenUtil.isLandScape(activity)){
                        textCountdownDropdown = viewDropdown.findViewById(R.id.text_countdown_dropdown);
                        TimerView crpv = viewDropdown.findViewById(R.id.crpv);
                        crpv.start(data.getCountdownOff().getValue());
                    }

                    btn_download_now_dropdown.setOnClickListener(new View.OnClickListener() {
                        @Override
                        public void onClick(View view) {
                            Utils.handleClick(activity , data.getMetaData().getCta0().getLink());
                        }
                    });
                    banner_tv_title_dropdown.setOnClickListener(new View.OnClickListener() {
                        @Override
                        public void onClick(View view) {
                            Utils.handleClick(activity , data.getMetaData().getCta0().getLink());
                        }
                    });
                    banner_tv_content_dropdown.setOnClickListener(new View.OnClickListener() {
                        @Override
                        public void onClick(View view) {
                            Utils.handleClick(activity , data.getMetaData().getCta0().getLink());
                        }
                    });
                    banner_imageView_dropdown.setOnClickListener(new View.OnClickListener() {
                        @Override
                        public void onClick(View view) {
                            Utils.handleClick(activity , data.getMetaData().getCta0().getLink());
                        }
                    });
                    layout_content_dropdown.setOnClickListener(new View.OnClickListener() {
                        @Override
                        public void onClick(View view) {
                            Utils.handleClick(activity , data.getMetaData().getCta0().getLink());
                        }
                    });

                    if(rootView.indexOfChild(viewDropdown) == -1){
                        Log.d("TAG" , "GO TO HERE");
                    }

                    rootView.addView(viewDropdown);
                    attachViewService.adShowing();
                    viewDropdown.startAnimation(AnimationUtils.loadAnimation(activity, R.anim.top_in));

                    new CountDownTimer(data.getCountdownOff().getValue() *1000 , 1000){

                        @Override
                        public void onTick(long l) {
                            if(ScreenUtil.isLandScape(activity))
                                textCountdownDropdown.setText(" " + l/1000);
                        }

                        @Override
                        public void onFinish() {
                            Animation animation = AnimationUtils.loadAnimation(
                                    activity, R.anim.top_out);
                            animation.setAnimationListener(new Animation.AnimationListener() {
                                @Override
                                public void onAnimationStart(Animation animation) {
                                }

                                @Override
                                public void onAnimationRepeat(Animation animation) {
                                }

                                @Override
                                public void onAnimationEnd(Animation animation) {
                                    ViewGroup rootView = activity
                                            .findViewById(android.R.id.content);
                                    rootView.removeView(viewDropdown);
                                    attachViewService.closeAds();
                                }
                            });
                            viewDropdown.startAnimation(animation);
                        }
                    }.start();
                    Repo.getRePo().trackingView(inventoryId , inventoryCode , data.getRaaId());
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void showAdsDropdownText(Data data, AttachViewService attachViewService, String inventoryCode , int inventoryId){
        AppCompatActivity activity = (AppCompatActivity) context;

        activity.runOnUiThread(new Runnable() {
            @Override
            public void run() {
                try {
                    ViewGroup rootView = activity.findViewById(android.R.id.content);
                    LayoutInflater inflater = LayoutInflater.from(activity);
                    if(viewDropdownText == null) viewDropdownText = inflater.inflate(R.layout.drop_down_view_text , null);
                    FrameLayout layout_content_dropdown = viewDropdownText.findViewById(R.id.layout_content_dropdown);
                    TextView dropdown_content_text = viewDropdownText.findViewById(R.id.dropdown_content_text);
                    dropdown_content_text.setText(data.getMetaData().getLongTitle() != null ?
                            data.getMetaData().getLongTitle().getData() : "");
                    dropdown_content_text.setOnClickListener(new View.OnClickListener() {
                        @Override
                        public void onClick(View view) {
                            Utils.handleClick(activity , data.getMetaData().getCta0().getLink());
                        }
                    });
                    layout_content_dropdown.setOnClickListener(new View.OnClickListener() {
                        @Override
                        public void onClick(View view) {
                            Utils.handleClick(activity , data.getMetaData().getCta0().getLink());
                        }
                    });
                    rootView.addView(viewDropdownText);
                    attachViewService.adShowing();
                    viewDropdownText.startAnimation(AnimationUtils.loadAnimation(activity, R.anim.fade_in));

                    new CountDownTimer(data.getCountdownOff().getValue() *1000 , 1000){

                        @Override
                        public void onTick(long l) {
                        }

                        @Override
                        public void onFinish() {
                            Animation animation = AnimationUtils.loadAnimation(
                                    activity, R.anim.fade_out);
                            animation.setAnimationListener(new Animation.AnimationListener() {
                                @Override
                                public void onAnimationStart(Animation animation) {
                                }

                                @Override
                                public void onAnimationRepeat(Animation animation) {
                                }

                                @Override
                                public void onAnimationEnd(Animation animation) {
                                    ViewGroup rootView = activity
                                            .findViewById(android.R.id.content);
                                    rootView.removeView(viewDropdownText);
                                    attachViewService.closeAds();
                                }
                            });
                            viewDropdownText.startAnimation(animation);
                        }
                    }.start();

                    Repo.getRePo().trackingView(inventoryId , inventoryCode , data.getRaaId());
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void showAds(Data data ,AttachViewService attachViewService, String inventoryCode , int inventoryId){
        switch (data.getTemplateType()){
            case "popup-dropdown":
                showAdsDropdown(data , attachViewService, inventoryCode , inventoryId);
            break;
            case "popup-dropdown-text":
                showAdsDropdownText(data, attachViewService, inventoryCode , inventoryId);
            break;
            default:
                showAds();
                break;

        }
    }

    @SuppressLint("LongLogTag")
    public synchronized void showAds() {
        FunAdsView funAdsView;
        String type = "";
        if (data == null) {
            Log.i(AdsUtils.TAG,"DATA IS NULL");
            return;
        }

        try {
            adsFunFactory = new AdsFunFactory(context);
            type = data.getTemplateType();
            Log.i(AdsUtils.TAG,"AdsFunFactory: " + adsFunFactory.toString());
            Log.i(AdsUtils.TAG,"Data: " + data.toString());
        } catch (Exception e) {
            System.out.printf(AdsUtils.TAG,"AdsFunFactory null");
            System.out.printf(AdsUtils.TAG,e.toString());
            e.printStackTrace();
        }

        try {
            services = new AdsServices.AdsServiceBuilder()
                    .setData(data)
                    .setListener(listener)
                    .build();
            Log.i(AdsUtils.TAG,"AdsServices: " + services.toString());
        } catch (Exception e) {
            System.out.printf(AdsUtils.TAG,"AdsServices is null");
            e.printStackTrace();
        }
        if(type.equals(AdsUtils.INLINE_BLUR) )
            checkBannerBlurIshow();
        if(type.equals(AdsUtils.INLINE_BLUR))
            checkBannerWhiteIshow();
        try {
            funAdsView = initPopUpSdk(type);
            funAdsView.loadFunAds(iventoriId , iventoriCode , data.getRaaId());
            if (funAdsView != null) {
                funAdsView.showFunAds();
                services.attach(funAdsView);
                services.notifyAllObserver();
            }
            Log.i(AdsUtils.TAG,funAdsView.toString());
        } catch (Exception e) {
            System.out.printf(AdsUtils.TAG,"FunadsView is null");
            e.printStackTrace();
        }
    }
    @SuppressLint("LongLogTag")
    private void checkBannerWhiteIshow() {
        try {
            BannerAdsWhite bannerAdsWhite = BannerAdsWhite.getBannerInstacne();
            if (BannerAdsWhite.isShow) {
                bannerAdsWhite.hideFunAds();
            }
        } catch (Exception e) {
            System.out.printf(AdsUtils.TAG,"Can not hide Banner Ads");
            e.printStackTrace();
        }
        Log.i(AdsUtils.TAG,"BannerAds is show: " + "checkBannerIshow");
    }
    @SuppressLint("LongLogTag")
    private void checkBannerBlurIshow() {
        try {
            BannerAdsBlur bannerAdsBlur = BannerAdsBlur.getBannerInstacne();
            if (BannerAdsBlur.isShow) {
                bannerAdsBlur.hideFunAds();
            }
        } catch (Exception e) {
            System.out.printf(AdsUtils.TAG,"Can not hide Banner Ads");
            e.printStackTrace();
        }
        Log.i(AdsUtils.TAG,"BannerAds is show: " + "checkBannerIshow");
    }

    @SuppressLint("LongLogTag")
    private FunAdsView initPopUpSdk(String type) throws IllegalAccessException {
        Log.i(AdsUtils.TAG,"FunAdsView: " + "initPopUpSdk");
        switch (type) {
            case AdsUtils.PICTURE:
                return adsFunFactory.createPopUp(PopUpType.POPUP);
            case AdsUtils.VIDEO:
                return adsFunFactory.createPopUp(PopUpType.VIDEO);
            case AdsUtils.LONG_IMAGES:
                return adsFunFactory.createPopUp(PopUpType.LONG_IMAGE);
            case AdsUtils.INLINE_BLUR:
                return adsFunFactory.createPopUp(PopUpType.BANNER_BLUR);
            case AdsUtils.INLINE_WHITE:
                return adsFunFactory.createPopUp(PopUpType.BANNER_WHITE);
            default:
                throw new IllegalAccessException("Not Support Ads");
        }
    }

    public void requestAds() {
        FundAdsRequestCallBackImpl<AdsFunModel> funModelFundAdsRequestCallBack = new FundAdsRequestCallBackImpl<AdsFunModel>() {

            @Override
            public void success(Response<AdsFunModel> success) {
                try {
                    data = success.body().getData();
                    switch (data.getTemplateType()){
                        case "videos":
                            if (context == null) {
                                return;
                            }
                            if(data.getMetaData().getVideo().getData() != null)
                                MediaSourseInstance.getInstance().buildMediaSource(context.getApplicationContext(), data.getMetaData().getVideo().getData().replace(" ", "%20"));
                            break;
                        case "feed-native":
                        case "banner-native":
                        case "slider-cta-native":
                            if (listener != null) {
                                listener.requestAdsNativeSuccess(data);
                            }
                            break;
                    }
                    if (listener != null) {
                        listener.reQuestAdsSuccess(data ,200);
                    }
                } catch (Exception e) {
                    System.out.println(e.getMessage());
                    System.out.println("Can not get data, Data get is null");
                    e.printStackTrace();
                }
            }

            @Override
            public void error(int error) {
                if (listener != null) {
                    listener.isLoadAdsError();
                }
            }

            @Override
            public void fail(Call<AdsFunModel> call) {
                if (listener != null) {
                    listener.isLoadAdsError();
                    System.out.printf(AdsUtils.TAG,"" + call.toString());
                }
            }
        };
        try {
            Repo.getRePo().requestAds(funModelFundAdsRequestCallBack, iventoriId , iventoriCode);
        } catch (Exception e) {
            System.out.println("can not call request ads");
            e.printStackTrace();
        }

    }

    public static class RequestAdsBuilder {

        private int iventoriId;
        private String iventoriCode;
        private String adsKey;

        private Context context;

        private AdsFunListener listener;

        private String userId = "";

        private String package_name = "";

        private String version_name = "";

        private int version_code = 0;
        private String advertisingId = "";
        private String isVip = "";

        public RequestAdsBuilder() {
        }

        public RequestAdsBuilder of(Context context) {
            this.context = context;
            return this;
        }

        public RequestAdsBuilder context(Context context) {
            this.context = context;
            return this;
        }

        public RequestAdsBuilder adsCode(String iventoriCode) {
            this.iventoriCode = iventoriCode;
            return this;
        }
        public RequestAdsBuilder adsId(int iventoriId) {
            this.iventoriId = iventoriId;
            return this;
        }
        public RequestAdsBuilder adsKey(String adskey) {
            this.adsKey = adskey;
            return this;
        }

        public RequestAdsBuilder addListener(AdsFunListener listener) {
            try {
                this.listener = listener;
            } catch (Exception e) {
                System.out.println("Listener is null");
            }
            return this;
        }

        public RequestAdsBuilder adsUserId(String userId) {
            this.userId = userId;
            return this;
        }

        public RequestAdsBuilder addPakageName(String package_name) {
            this.package_name = package_name;
            return this;
        }

        public RequestAdsBuilder isVip(String isVip){
            this.isVip = isVip;
            return this;
        }

        public RequestAdsBuilder addVersionName(String version_name) {
            this.version_name = version_name;
            return this;
        }

        public RequestAdsBuilder addVersionCode(int version_code) {
            this.version_code = version_code;
            return this;
        }

        public RequestAdsBuilder addAdsVertisingId (String advertisingId) {
            this.advertisingId = advertisingId;
            return this;
        }

        @SuppressLint("LongLogTag")
        public RequestAdsFun build() {
            RequestAdsFun requestAdsFun = null;
            try {
                requestAdsFun = new RequestAdsFun(adsKey, iventoriId,iventoriCode, context, listener,userId,package_name,version_name,version_code,advertisingId , isVip);
            } catch (Exception e) {
                System.out.printf(AdsUtils.TAG,"Context is null");
                e.printStackTrace();
            }
            return requestAdsFun;
        }
    }
}
