package playfun.ads.android.sdk.component.model.networkmodel;

import android.os.Parcel;
import android.os.Parcelable;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;

public class ImageModel implements Parcelable {
    @SerializedName("label")
    @Expose
    private String label;
    @SerializedName("name")
    @Expose
    private String name;
    @SerializedName("type")
    @Expose
    private String type;
    @SerializedName("data")
    @Expose
    private String data;

    protected ImageModel(Parcel in) {
        label = in.readString();
        name = in.readString();
        type = in.readString();
        data = in.readString();
    }

    public static final Creator<LogoImage> CREATOR = new Creator<LogoImage>() {
        @Override
        public LogoImage createFromParcel(Parcel in) {
            return new LogoImage(in);
        }

        @Override
        public LogoImage[] newArray(int size) {
            return new LogoImage[size];
        }
    };

    public String getLabel() {
        return label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getData() {
        return data;
    }

    public void setData(String data) {
        this.data = data;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int i) {
        parcel.writeString(label);
        parcel.writeString(name);
        parcel.writeString(type);
        parcel.writeString(data);
    }
}
