package playfun.ads.android.sdk.component.factory.bannerfactory;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.app.AppCompatActivity;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.bumptech.glide.Glide;
import com.bumptech.glide.request.RequestOptions;
import com.bumptech.glide.request.target.SimpleTarget;
import com.bumptech.glide.request.transition.Transition;

import playfun.ads.android.sdk.R;
import playfun.ads.android.sdk.component.callback.AdsFunListener;
import playfun.ads.android.sdk.component.model.networkmodel.Cta0;
import playfun.ads.android.sdk.component.model.networkmodel.Data;
import playfun.ads.android.sdk.component.network.Repo;
import playfun.ads.android.sdk.component.util.AdsUtils;
import playfun.ads.android.sdk.component.util.ImageHelper;

public class BannerAdsWhite extends Banner {
    private final Context context;
    private View view;
    private ViewGroup viewGroup;
    private Cta0 action;
    private Button btn_close;
    private AppCompatActivity activity;
    private TextView tv_content,tv_titile;
    private Button btnDownload;
    private ImageView banner_image;
    private Data data;
    private static BannerAdsWhite INSTANCE;
    public static boolean isShow;
    private static AdsFunListener listener;
    @SuppressLint("LongLogTag")
    public BannerAdsWhite(Context context) {
        super(context);
        Log.i(AdsUtils.TAG,"BannerAds");
        this.context = context;
        INSTANCE = this;

    }

    public static BannerAdsWhite getBannerInstacne() {
        try {
            return INSTANCE;
        } catch (Exception e) {
            System.out.println("banner is null");
        }
        return INSTANCE;
    }
    @SuppressLint("LongLogTag")
    public void addViewIntoRoot() {
        RelativeLayout.LayoutParams lay = new RelativeLayout.LayoutParams(
                RelativeLayout.LayoutParams.MATCH_PARENT,LayoutParams.WRAP_CONTENT);
        lay.bottomMargin = (int) getResources().getDimension(R.dimen._23sdp);
        lay.addRule(RelativeLayout.ALIGN_PARENT_BOTTOM);
        viewGroup.addView(view,lay);
        isShow = true;
        if (listener !=null) {
            listener.isShowAds(true);
            Repo.getRePo().trackingView();
        }
        Log.i(AdsUtils.TAG,"BannerAds" + "addViewIntoRoot" + isShow);
    }

    public BannerAdsWhite(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.context = context;
        initView();
    }

    public BannerAdsWhite(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.context = context;
        initView();
    }

    @SuppressLint("LongLogTag")
    private void initView() {
        view = LayoutInflater.from(context).inflate(R.layout.banner_white,this,true);
        banner_image = view.findViewById(R.id.banner_imageView);
        btn_close = view.findViewById(R.id.btn_close);
        tv_content = view.findViewById(R.id.banner_tv_content);
        tv_titile = view.findViewById(R.id.banner_tv_title);
        btnDownload = view.findViewById(R.id.btn_download_now);
        try {
            activity = (AppCompatActivity) context;
            viewGroup = activity
                    .findViewById(android.R.id.content);
        } catch (Exception e) {
            System.out.println("ViewGroup banner is null");
        }

        btn_close.setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View v) {
                hideFunAds();
            }
        });

        banner_image.setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View view) {
                handleClick();
            }
        });
        tv_content.setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View view) {
                handleClick();
            }
        });
        tv_titile.setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View view) {
                handleClick();
            }
        });
        btnDownload.setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View v) {
                handleClick();

            }
        });
        Log.d("adsView","initView banner");
        Log.i(AdsUtils.TAG,"BannerAds" + "initView");
    }

    private void handleClick(){
        try {
            if(data.getMetaData().getCta0().getLink() != null) {
                Intent intent = new Intent(Intent.ACTION_VIEW);
                intent.setData(Uri.parse(data.getMetaData().getCta0().getLink() != null ? data.getMetaData().getCta0().getLink() : ""));
                context.startActivity(intent);
            }

        } catch (Exception e) {
            System.out.println("Action banner is null");
        }
    }
    @Override
    public void hideFunAds() {

        if (view.getParent() != null) {
            viewGroup.removeView(view);
            Log.d("adsView","hideFunAds" + "bannerAds");
            if (listener !=null) {
                isShow = false;
                listener.isCloseAds(true);
            }
        }
    }

    @Override
    public void showFunAds() {
        initView();
        Log.d("adsView","showFunAds" + view.getRootView());
    }

    @Override
    public void loadFunAds(int inventoryId , String inventoryCode , int raaid) {
        Log.d("adsView","loadFunAds" + "bannerAds");
        Repo.getRePo().trackingView(inventoryId , inventoryCode , raaid);
    }

    public void drawAds() {
        try {
            Glide.with(getContext()).asBitmap().load(data.getMetaData().getLogoImage().getData() != null ? data.getMetaData().getLogoImage().getData() : "").apply(new RequestOptions().override((int) getResources()
                    .getDimension(R.dimen._34sdp),(int) getResources().getDimension(R.dimen._34sdp))).into(new SimpleTarget<Bitmap>() {
                @Override
                public void onResourceReady(@NonNull Bitmap resource, @Nullable Transition<? super Bitmap> transition) {
                    banner_image.setImageBitmap(ImageHelper.getRoundedCornerBitmap(resource, ImageHelper.getCornerPixel(resource,28)));
                }
            });
            tv_content.setText(data.getMetaData().getShortDescription().getData() != null ? data.getMetaData().getShortDescription().getData() : "");
            tv_titile.setText(data.getMetaData().getShortTitle().getData() != null ? data.getMetaData().getShortTitle().getData() : "");
            btnDownload.setText(action.getLabel() != null ? action.getLabel() : "");
            Log.d("adsView","drawAds" + "bannerAds");
        } catch (Resources.NotFoundException e) {
            e.printStackTrace();
        }
    }
    @Override
    public void updateAds(Data data) {
        Log.d("adsView","updateAds_banner");
        try {
            this.data = data;
            if(data.getMetaData().getCta0() != null) {
                this.action = data.getMetaData().getCta0();
            }
            drawAds();
        } catch (Exception e) {
            System.out.println("Data banner is null");
        }
    }

    @Override
    public void sendListener(AdsFunListener listener) {
        super.sendListener(listener);
        Log.d("adsView","sendListener banner");
        if (view.getParent() == null) {
            addViewIntoRoot();
        }
        try {
            BannerAdsWhite.listener = listener;
        } catch (Exception e) {
            System.out.println("Listener banner is null");
        }

    }
}