/*
 * Decompiled with CFR 0.152.
 */
package playfun.ads.android.sdk.component.network;

import android.annotation.SuppressLint;
import android.util.Log;
import okhttp3.ResponseBody;
import playfun.ads.android.sdk.component.callback.FundAdsRequestCallBackImpl;
import playfun.ads.android.sdk.component.callback.GetListInventoryIdCallbackImpl;
import playfun.ads.android.sdk.component.model.networkmodel.AdsFunModel;
import playfun.ads.android.sdk.component.model.networkmodel.InventoryIdModel;
import playfun.ads.android.sdk.component.network.APIServices;
import playfun.ads.android.sdk.component.network.RetrofitHelper;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class Repo {
    private static Repo INSTANCE = null;
    private APIServices apiServices;
    private APIServices apiServicesPixel;
    public static int eventoryId;
    public static String inventoriCode;
    public static int raaid;

    @SuppressLint(value={"LongLogTag"})
    private Repo() {
        try {
            this.apiServices = RetrofitHelper.createServiceProduct(APIServices.class);
            this.apiServicesPixel = RetrofitHelper.createServicePixel(APIServices.class);
            Log.i((String)"playfun.ads.android.sdk.component", (String)("APIServices: " + this.apiServices.toString()));
            Log.i((String)"playfun.ads.android.sdk.component", (String)("APIServices: " + this.apiServicesPixel.toString()));
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("can not initalize API services");
        }
    }

    public static final synchronized Repo getRePo() {
        if (INSTANCE == null) {
            INSTANCE = new Repo();
        }
        return INSTANCE;
    }

    public void trackingView(int inventoryId, String inventoryCode, int raaid) {
        inventoriCode = inventoryCode;
        eventoryId = inventoryId;
        Repo.raaid = raaid;
        this.trackingView();
    }

    public void trackingView(int raaid) {
        Repo.raaid = raaid;
        this.trackingView();
    }

    public void trackingView() {
        try {
            Log.d((String)"TAG", (String)("eventoryId : " + eventoryId + " raaid : " + raaid));
            this.apiServicesPixel.trackingShowView(raaid, eventoryId, inventoriCode).enqueue((Callback)new Callback<ResponseBody>(){

                public void onResponse(Call<ResponseBody> call, Response<ResponseBody> response) {
                    Log.i((String)"tracking_funds", (String)("trackingShowView" + response.code()));
                }

                public void onFailure(Call<ResponseBody> call, Throwable t) {
                }
            });
        }
        catch (Exception e) {
            System.out.println("can not tracking show view, API services is null");
        }
    }

    public void getListInventoryId(final GetListInventoryIdCallbackImpl getListInventoryIdCallback, String adsKey) {
        try {
            this.apiServices.getListInventoryId(adsKey).enqueue((Callback)new Callback<InventoryIdModel>(){

                public void onResponse(Call<InventoryIdModel> call, Response<InventoryIdModel> response) {
                    try {
                        if (response.isSuccessful()) {
                            getListInventoryIdCallback.onSuccess(response);
                        } else {
                            getListInventoryIdCallback.onError(response.code(), response.message());
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }

                public void onFailure(Call<InventoryIdModel> call, Throwable t) {
                    getListInventoryIdCallback.onFail(call);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void requestAds(final FundAdsRequestCallBackImpl requestCallBack, final int ivenStoryId, final String inventoryCode) {
        try {
            this.apiServices.fetchAds(inventoryCode).enqueue((Callback)new Callback<AdsFunModel>(){

                @SuppressLint(value={"LongLogTag"})
                public void onResponse(Call<AdsFunModel> call, Response<AdsFunModel> response) {
                    try {
                        if (response.code() == 200) {
                            AdsFunModel adsFunModel = (AdsFunModel)response.body();
                            requestCallBack.success(response);
                            eventoryId = ivenStoryId;
                            inventoriCode = inventoryCode;
                            raaid = adsFunModel.getData().getRaaId();
                            Log.i((String)"playfun.ads.android.sdk.component", (String)("response" + response));
                        } else {
                            requestCallBack.error(response.code());
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }

                public void onFailure(Call<AdsFunModel> call, Throwable t) {
                    requestCallBack.fail(call);
                }
            });
        }
        catch (Exception e) {
            System.out.println("Can not get ads, API services is null");
        }
    }
}

