/*
 * Decompiled with CFR 0.152.
 */
package playfun.ads.android.sdk.component.factory.nativeads;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.bumptech.glide.Glide;
import java.util.ArrayList;
import java.util.List;
import playfun.ads.android.sdk.R;
import playfun.ads.android.sdk.component.factory.nativeads.adapter.AdapterBottomAds;
import playfun.ads.android.sdk.component.model.networkmodel.Data;
import playfun.ads.android.sdk.component.model.networkmodel.DataImage;

public class NativeAdsBottom
extends RelativeLayout {
    private ViewPager viewPager;
    AdapterBottomAds adapter;
    List<DataImage> listImage = new ArrayList<DataImage>();
    private ImageView img_icon_game;
    private TextView text_title_game;
    private TextView text_description_game;
    private TextView tv_download_game;
    private ImageView icon_download_game;
    private RelativeLayout view_download_game;
    private LinearLayout layout_content_bottom_native;

    public NativeAdsBottom(Context context) {
        this(context, null);
    }

    public NativeAdsBottom(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public NativeAdsBottom(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        LayoutInflater.from((Context)context).inflate(R.layout.native_ads_bottom, (ViewGroup)this);
        this.img_icon_game = (ImageView)this.findViewById(R.id.img_icon_game);
        this.text_title_game = (TextView)this.findViewById(R.id.text_title_game);
        this.text_description_game = (TextView)this.findViewById(R.id.text_description_game);
        this.tv_download_game = (TextView)this.findViewById(R.id.tv_download_game);
        this.icon_download_game = (ImageView)this.findViewById(R.id.icon_download_game);
        this.view_download_game = (RelativeLayout)this.findViewById(R.id.view_download_game);
        this.layout_content_bottom_native = (LinearLayout)this.findViewById(R.id.layout_content_bottom_native);
        this.viewPager = (ViewPager)this.findViewById(R.id.viewPager);
        this.viewPager.setClipToPadding(false);
        this.viewPager.setPadding(30, 0, 30, 0);
        this.adapter = new AdapterBottomAds(context, this.listImage);
        this.viewPager.setAdapter((PagerAdapter)this.adapter);
    }

    public void setData(final Context context, final Data data) {
        try {
            this.adapter.setListImage(data.getMetaData().getMultipleFile().getDataImage());
            this.adapter.notifyDataSetChanged();
            this.viewPager.invalidate();
            Glide.with((Context)context).load(data.getMetaData().getLogoImage().getData()).into(this.img_icon_game);
            this.text_title_game.setText((CharSequence)data.getMetaData().getShortTitle().getData());
            this.text_description_game.setText((CharSequence)data.getMetaData().getShortDescription().getData());
            View.OnClickListener onClickListener = new View.OnClickListener(){

                public void onClick(View view) {
                    String urlClick = data.getMetaData().getCta0().getLink();
                    Intent intent = new Intent("android.intent.action.VIEW");
                    intent.setFlags(0x30000000);
                    intent.setData(Uri.parse((String)urlClick));
                    context.startActivity(intent);
                }
            };
            this.view_download_game.setOnClickListener(onClickListener);
            this.tv_download_game.setOnClickListener(onClickListener);
            this.icon_download_game.setOnClickListener(onClickListener);
            this.text_title_game.setOnClickListener(onClickListener);
            this.text_description_game.setOnClickListener(onClickListener);
            this.img_icon_game.setOnClickListener(onClickListener);
            this.layout_content_bottom_native.setOnClickListener(onClickListener);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

