package playfun.ads.android.sdk.component.view;

import android.content.Context;
import android.support.v4.widget.NestedScrollView;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
public class InteractiveScrollView extends NestedScrollView {
    private OnBottomReachedListener mListener;

    public InteractiveScrollView(Context context, AttributeSet attrs,
                                 int defStyle) {
        super(context, attrs, defStyle);
    }

    public InteractiveScrollView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public InteractiveScrollView(Context context) {
        super(context);
    }

    @Override
    protected void onScrollChanged(int l, int t, int oldl, int oldt) {
        View view = (View) getChildAt(getChildCount()-1);
        int diff = (view.getBottom()-(getHeight()+getScrollY()));

        Log.d("bottom_sheet" ,"diff-" + diff + "-Bottom-"+ view.getBottom()+"-Height" + getHeight() + "-ScrollY" + getScrollY());
        if (diff <= 670 && mListener != null) {
            mListener.onBottomReached();
        } else if (getScrollY() <= 0 && mListener != null) {
            mListener.onTopReached(t);
        } else{
            if(t<oldt){
                if (mListener != null && diff >= 600){
                    mListener.onScrolledDown(t);
                }
            }else if (t>oldt){
                if (mListener != null){
                    mListener.onScrolledUp(t);
                }
            }
        }
        super.onScrollChanged(l, t, oldl, oldt);
    }


    // Getters & Setters

    public OnBottomReachedListener getOnBottomReachedListener() {
        return mListener;
    }

    public void setOnBottomReachedListener(
            OnBottomReachedListener onBottomReachedListener) {
        mListener = onBottomReachedListener;
    }


    /**
     * Event listener.
     */
    public interface OnBottomReachedListener{
        void onBottomReached();
        void onTopReached(int scrollY);
        void onScrolledDown(int scrollY);
        void onScrolledUp(int scrollY);
    }
}
