/*
 * Decompiled with CFR 0.152.
 */
package playfun.ads.android.sdk.component.view;

import android.content.Context;
import android.support.v4.widget.NestedScrollView;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;

public class InteractiveScrollView
extends NestedScrollView {
    private OnBottomReachedListener mListener;

    public InteractiveScrollView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public InteractiveScrollView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public InteractiveScrollView(Context context) {
        super(context);
    }

    protected void onScrollChanged(int l, int t, int oldl, int oldt) {
        View view = this.getChildAt(this.getChildCount() - 1);
        int diff = view.getBottom() - (this.getHeight() + this.getScrollY());
        Log.d((String)"bottom_sheet", (String)("diff-" + diff + "-Bottom-" + view.getBottom() + "-Height" + this.getHeight() + "-ScrollY" + this.getScrollY()));
        if (diff <= 670 && this.mListener != null) {
            this.mListener.onBottomReached();
        } else if (this.getScrollY() <= 0 && this.mListener != null) {
            this.mListener.onTopReached(t);
        } else if (t < oldt) {
            if (this.mListener != null && diff >= 600) {
                this.mListener.onScrolledDown(t);
            }
        } else if (t > oldt && this.mListener != null) {
            this.mListener.onScrolledUp(t);
        }
        super.onScrollChanged(l, t, oldl, oldt);
    }

    public OnBottomReachedListener getOnBottomReachedListener() {
        return this.mListener;
    }

    public void setOnBottomReachedListener(OnBottomReachedListener onBottomReachedListener) {
        this.mListener = onBottomReachedListener;
    }

    public static interface OnBottomReachedListener {
        public void onBottomReached();

        public void onTopReached(int var1);

        public void onScrolledDown(int var1);

        public void onScrolledUp(int var1);
    }
}

