/*
 * Decompiled with CFR 0.152.
 */
package playfun.ads.android.sdk.component.observer;

import java.util.ArrayList;
import java.util.List;
import playfun.ads.android.sdk.component.callback.AdsFunListener;
import playfun.ads.android.sdk.component.model.networkmodel.Data;
import playfun.ads.android.sdk.component.observer.FunObserver;
import playfun.ads.android.sdk.component.observer.Subject;

public class AdsServices
implements Subject {
    private Data data;
    private AdsFunListener adsFunListener;
    private AdsFunListener listener;
    private List<FunObserver> list = new ArrayList<FunObserver>();

    public AdsServices(Data data, AdsFunListener listener) {
        this.data = data;
        this.listener = listener;
    }

    @Override
    public void attach(FunObserver observer) {
        if (!this.list.contains(observer)) {
            this.list.add(observer);
        }
    }

    @Override
    public void detach(FunObserver observer) {
        if (this.list.contains(observer)) {
            this.list.remove(observer);
        }
    }

    @Override
    public void notifyAllObserver() {
        for (FunObserver observer : this.list) {
            observer.updateAds(this.data);
            observer.sendListener(this.listener);
        }
    }

    public void removeAllObserver() {
        if (this.list != null && this.list.size() > 0) {
            this.list.isEmpty();
        }
    }

    public int getObserver() {
        return this.list.size();
    }

    public static class AdsServiceBuilder {
        private Data data;
        private AdsFunListener listener;

        public AdsServiceBuilder setData(Data data) {
            this.data = data;
            return this;
        }

        public AdsServiceBuilder setListener(AdsFunListener listener) {
            this.listener = listener;
            return this;
        }

        public AdsServices build() {
            return new AdsServices(this.data, this.listener);
        }
    }
}

