package playfun.ads.android.sdk.component.factory.popupfactory;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.Typeface;
import android.net.Uri;
import android.os.Bundle;
import android.os.CountDownTimer;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.SpannableStringBuilder;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.bumptech.glide.Glide;
import com.bumptech.glide.request.target.SimpleTarget;
import com.bumptech.glide.request.transition.Transition;
import com.google.android.exoplayer2.ExoPlayerFactory;
import com.google.android.exoplayer2.Player;
import com.google.android.exoplayer2.SimpleExoPlayer;

import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.ui.PlayerView;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.Util;
import playfun.ads.android.sdk.R;
import playfun.ads.android.sdk.component.util.AdsUtils;
import playfun.ads.android.sdk.component.util.ImageHelper;
import playfun.ads.android.sdk.component.util.MediaSourseInstance;
import playfun.ads.android.sdk.component.util.ScreenUtil;
import playfun.ads.android.sdk.component.view.FunAdsBannerView;


public class PopUpAdsDialogVideo extends BasePopUp implements Player.EventListener {

    public PlayerView playerView;

    public SimpleExoPlayer player;

    private RelativeLayout mButtonDownload, frame_layout_finish,mButton_Download_finish;
    private FunAdsBannerView funads_banner_view;
    private FrameLayout view_countdown_off;
    private TextView txt_countdown_off;

    private TextView mTvTile,mTvContent,mTv_Download,mTv_title_finish,mTv_content_finish;
    
    private View view;

    private String mAction;

    private ImageView mImageIcon,mImage_icon_finish,image_background_popupfinish;
    
    private MediaSource mediaSource;

    private Button mButton_Play,mButton_Replay;
    
    private TextView txtReplay;

    private FrameLayout mFrameLayout;

    private RelativeLayout btn_close;

    @SuppressLint("LongLogTag")
    @Override
    public void onCreate( Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Log.i(AdsUtils.TAG,"PopUpAdsDialogVideo: " + "onCreate");
    }

    @Override
    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
    }

    @Override
    public void onAttach(Context context) {
        super.onAttach(context);
    }

    @Override
    public void onStart() {
        super.onStart();
        if (Util.SDK_INT > 23) {
            initializePlayer();
            if (playerView != null) {
                playerView.onResume();
            }
        }
    }

    @Override
    public View onCreateView( LayoutInflater inflater,  ViewGroup container,  Bundle savedInstanceState) {
        view = inflater.inflate(R.layout.popup_portrait_video,container,true);
        playerView = view.findViewById(R.id.video_view);
        btn_close = view.findViewById(R.id.btn_close_popupvideo);
        view_countdown_off = view.findViewById(R.id.view_countdown_off);
        txt_countdown_off = view.findViewById(R.id.txt_countdown_off);
        playerView.setShutterBackgroundColor(Color.TRANSPARENT);
        playerView.setKeepContentOnPlayerReset(true);
        mButtonDownload = view.findViewById(R.id.btn_download);
        mImageIcon = view.findViewById(R.id.image_small_content);
        mTvContent = view.findViewById(R.id.tv_content);
        mTvTile = view.findViewById(R.id.tv_title);
        mFrameLayout = view.findViewById(R.id.framePoup);
        mTv_Download = view.findViewById(R.id.tv_download);

        if (ScreenUtil.isLandScape(getActivity())) {
            initViewLandScape(view);
        } else {
            initViewPortrail(view);
        }
        Typeface typeface = Typeface.createFromAsset(
                getActivity().getAssets(),
                "sftnormal.ttf");
        int textSize = (int) getResources().getDimension(R.dimen._11sdp);
        int marginRigth = (int) getResources().getDimension(R.dimen._11sdp);
        int marginTop = (int) getResources().getDimension(R.dimen._2sdp);
        int corner = (int) getResources().getDimension(R.dimen._4sdp);
        int marginLeft = (int) getResources().getDimension(R.dimen._4sdp);
        SpannableStringBuilder builder = AdsUtils.setTexSpanBoder(data.getMetaData().getShortTitle().getData() != null ? data.getMetaData().getShortTitle().getData() : "","Free",textSize,typeface,marginRigth,marginLeft,marginTop,corner);
        mTvContent.setText(data.getMetaData().getShortDescription().getData() != null ? data.getMetaData().getShortDescription().getData() : "");
        mTvTile.setText(builder);
        Glide.with(getActivity()).asBitmap().load(data.getMetaData().getLogoImage().getData()  != null ? data.getMetaData().getLogoImage().getData() : "").into(new SimpleTarget<Bitmap>() {
            @Override
            public void onResourceReady(@NonNull Bitmap resource, @Nullable Transition<? super Bitmap> transition) {
                if (ScreenUtil.isLandScape(getActivity())) {
                    mImageIcon.setImageBitmap(ImageHelper.getRoundedCornerBitmap(resource, ImageHelper.getCornerPixel(resource,28)));
                    mImage_icon_finish.setImageBitmap(ImageHelper.getRoundedCornerBitmap(resource, ImageHelper.getCornerPixel(resource,28)));
                    mTvTile.setText(data.getMetaData().getShortTitle().getData() != null ? data.getMetaData().getShortTitle().getData() : "");
                } else {
                    mImageIcon.setImageBitmap(ImageHelper.getRoundedCornerBitmap(resource, ImageHelper.getCornerPixel(resource,28)));
                }

            }
        });

        try {
            if(data.getCountdownOff() != null){
                view_countdown_off.setVisibility(View.VISIBLE);
                btn_close.setVisibility(View.GONE);
                new CountDownTimer(data.getCountdownOff().getValue() * 1000 , 1000){

                    @Override
                    public void onTick(long l) {
                        txt_countdown_off.setText("" + l/1000);
                    }

                    @Override
                    public void onFinish() {
                        view_countdown_off.setVisibility(View.GONE);
                        if(data.getCountdownOff().getDoShowClose()){
                            btn_close.setVisibility(View.VISIBLE);
                        }else{
                            dismiss();
                        }
                    }
                }.start();
            }
            if (data.getMetaData().getCta0() != null && data.getMetaData().getCta0().getLink() != null) {
                mTv_Download.setText(cta0Action.getLabel());
                mAction = data.getMetaData().getCta0().getLink();
            }
        } catch (Exception e) {
            System.out.println("Can not get action, Action is null");
        }

        mButtonDownload.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                goToStore();
            }
        });
        mImageIcon.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                goToStore();
            }
        });
        mTvContent.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                goToStore();
            }
        });
        mTvTile.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                goToStore();
            }
        });
        btn_close.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                System.out.println("Close_PopUp" + "Close");
                dismiss();
                player.release();
            }
        });
        Log.i(AdsUtils.TAG,"PopUpAdsDialogVideo: " + "onCreateView");
        initPlayer();
        return view;
    }

    private void initViewPortrail(View view) {
        mButton_Play = view.findViewById(R.id.btn_playvideo);
        funads_banner_view = view.findViewById(R.id.funads_banner_view);
        funads_banner_view.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                goToStore();
            }
        });
        mButton_Play.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                player.prepare(mediaSource);
                player.setPlayWhenReady(true);
                handleViewStatePlay();
            }
        });
    }

    private void initViewLandScape(View view) {
        mTv_content_finish = view.findViewById(R.id.tv_content_popupfinish);
        mTv_title_finish = view.findViewById(R.id.tv_title_popupfinish);
        mImage_icon_finish = view.findViewById(R.id.image_icon_popupfinish);
        frame_layout_finish = view.findViewById(R.id.frame_layout_finish);
        mButton_Download_finish = view.findViewById(R.id.btn_download_popupfinish);
        image_background_popupfinish = view.findViewById(R.id.image_background_popupfinish);
        mButton_Replay = view.findViewById(R.id.btn_replay);
        txtReplay = view.findViewById(R.id.txt_replay);

        try {
            Glide.with(getActivity()).load(data.getMetaData().getImage().getData() != null ? data.getMetaData().getImage().getData() : "").into(image_background_popupfinish);
            image_background_popupfinish.animate().alpha(0.05f);
        } catch (Exception e) {
            System.out.println("can not set image, data is null");
        }

        mButton_Replay.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                player.prepare(mediaSource);
                player.setPlayWhenReady(true);
                handleViewStatePlay();
            }
        });

        txtReplay.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                player.prepare(mediaSource);
                player.setPlayWhenReady(true);
                handleViewStatePlay();
            }
        });

        mButton_Download_finish.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                goToStore();
            }
        });
        mTv_content_finish.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                goToStore();
            }
        });
        mTv_title_finish.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                goToStore();
            }
        });
        image_background_popupfinish.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                goToStore();
            }
        });
    }

    private void goToStore() {
        try {
            Intent intent = new Intent(Intent.ACTION_VIEW);
            intent.setFlags(Intent.FLAG_ACTIVITY_SINGLE_TOP|Intent.FLAG_ACTIVITY_NEW_TASK);
            intent.setData(Uri.parse(mAction));
            getActivity().startActivity(intent);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @SuppressLint("NewApi")
    private void initPlayer() {
        if (getActivity()== null) {
            return;
        }

        try {
            if (player == null) {
                player = ExoPlayerFactory.newSimpleInstance(getActivity());
                playerView.setPlayer(player);
                player.addListener(this);
            }
        } catch (Exception e) {
            System.out.println("can not initalize, Player view is null");
        }

        Log.i(AdsUtils.TAG,"PopUpAdsDialogVideo: " + "initPlayer");
    }

    private synchronized void initializePlayer() {
        new Thread(new Runnable() {
            @Override
            public void run() {
                mediaSource = buildMediaSource();
                try {
                    if (mediaSource != null) {
                        if (player == null) {
                            initPlayer();
                        }
                        player.prepare(mediaSource);
                        player.setPlayWhenReady(true);
                    }
                    Log.i(AdsUtils.TAG,"PopUpAdsDialogVideo: " + "initializePlayer" + mediaSource.toString());
                } catch (Exception e) {
                    System.out.println("player is null");
                }
            }
        }).start();
    }


    @Override
    public void onPause() {
        super.onPause();
        if (Util.SDK_INT <= 23) {
            if (playerView != null) {
                playerView.onPause();
            }
            releasePlayer();
        }
    }

    @Override
    public void onResume() {
        super.onResume();
        int width = 0, height = 0;
        width = ViewGroup.LayoutParams.WRAP_CONTENT;
        if(ScreenUtil.isLandScape(getActivity())) {
            height = ViewGroup.LayoutParams.WRAP_CONTENT;
        } else {
            height = ViewGroup.LayoutParams.WRAP_CONTENT;
        }
        getDialog().getWindow().setLayout(width, height);
        if (Util.SDK_INT <= 23 || player == null) {
            initPlayer();
            initializePlayer();
            if (playerView != null) {
                playerView.onResume();
            }
        }
        handleViewStatePlay();
    }

    private MediaSource buildMediaSource() {
        MediaSource videoSource = null;
        try {
            videoSource = MediaSourseInstance.getInstance().getVideoSource();
        } catch (Exception e) {
            System.out.println("Media sourse is null");
        }
        return videoSource;
    }

    @Override
    public void onStop() {
        super.onStop();
        if (Util.SDK_INT > 23) {
            if (playerView != null) {
                playerView.onPause();
            }
            releasePlayer();
        }
    }

    @Override
    public void onPlayerStateChanged(boolean playWhenReady, int playbackState) {
        Log.d("Exodebug","onPlayerStateChanged" + playWhenReady + "/" + playbackState);

        switch (playbackState) {
            case Player.STATE_READY:
            case Player.STATE_BUFFERING:
                break;
            case Player.STATE_ENDED:
               initFrameFinishVideo();
                break;
            default:
                break;
        }
    }

    private void handleViewStatePlay() {
        if (getActivity()== null) {
            return;
        }

        if (ScreenUtil.isLandScape(getActivity())) {
            frame_layout_finish.setVisibility(View.GONE);
        } else {
            mButton_Play.setVisibility(View.GONE);
        }

    }

    private void initFrameFinishVideo() {
        try {
            player.seekTo(player.getDuration()-4000);
            playerView.onPause();
            player.setPlayWhenReady(false);
            if (ScreenUtil.isLandScape(getActivity())) {
                mTv_title_finish.setText(data.getMetaData().getShortTitle().getData() != null ? data.getMetaData().getShortTitle().getData() : "");
                frame_layout_finish.setVisibility(View.VISIBLE);
                mTv_content_finish.setText(data.getMetaData().getShortDescription().getData() != null ? data.getMetaData().getShortDescription().getData() : "");
            } else {
                mButton_Play.setVisibility(View.VISIBLE);
            }
        } catch (Exception e) {
            System.out.println("Player is null");
        }

    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        releasePlayer();
    }

    private void releasePlayer() {
        if (player != null) {
            player.release();
            player = null;
        }
    }

    @Override
    public void onLoadingChanged(boolean isLoading) {
        if (isLoading) {
            mFrameLayout.postDelayed(new Runnable() {
                @Override
                public void run() {
                    mFrameLayout.setVisibility(View.VISIBLE);
                }
            },400);
        }
    }

}


