/*
 * Decompiled with CFR 0.152.
 */
package playfun.ads.android.sdk.component.factory.nativeads;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.content.res.TypedArray;
import android.net.Uri;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.request.RequestOptions;
import com.google.android.exoplayer2.ExoPlayerFactory;
import com.google.android.exoplayer2.Player;
import com.google.android.exoplayer2.SimpleExoPlayer;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.ui.PlayerView;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.Util;
import com.google.gson.Gson;
import playfun.ads.android.sdk.R;
import playfun.ads.android.sdk.component.callback.AdsFunListener;
import playfun.ads.android.sdk.component.factory.RequestAdsFun;
import playfun.ads.android.sdk.component.model.networkmodel.Data;
import playfun.ads.android.sdk.component.util.MediaSourseInstance;

public class NativeAdsFeedVideo
extends RelativeLayout
implements Player.EventListener {
    RequestAdsFun requestAdsFun;
    String code;
    String packageName;
    String versionName;
    int versionCode;
    private ImageView img_logo_video;
    private TextView text_title_video;
    private TextView text_description_video;
    private TextView text_install_video;
    private Button btn_playnow_video;
    private PlayerView video_view_video;
    private LinearLayout view_title_video;
    private LinearLayout layout_install_video;
    private MediaSource mediaSource;
    public PlayerView playerView;
    public SimpleExoPlayer player;

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (Util.SDK_INT <= 23) {
            if (this.playerView != null) {
                this.playerView.onPause();
            }
            this.releasePlayer();
        }
    }

    private void releasePlayer() {
        if (this.player != null) {
            this.player.release();
            this.player = null;
        }
    }

    public NativeAdsFeedVideo(Context context) {
        this(context, null);
    }

    public NativeAdsFeedVideo(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public NativeAdsFeedVideo(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        LayoutInflater.from((Context)context).inflate(R.layout.native_ads_feed_video, (ViewGroup)this);
        this.img_logo_video = (ImageView)this.findViewById(R.id.img_logo_video);
        this.video_view_video = (PlayerView)this.findViewById(R.id.video_view_video);
        this.text_title_video = (TextView)this.findViewById(R.id.text_title_video);
        this.text_description_video = (TextView)this.findViewById(R.id.text_description_video);
        this.text_install_video = (TextView)this.findViewById(R.id.text_install_video);
        this.view_title_video = (LinearLayout)this.findViewById(R.id.view_title_video);
        this.layout_install_video = (LinearLayout)this.findViewById(R.id.layout_install_video);
        this.btn_playnow_video = (Button)this.findViewById(R.id.btn_playnow_video);
        this.requestNativeAds(context, attrs);
    }

    private void requestNativeAds(final Context context, AttributeSet attrs) {
        TypedArray typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.NativeAdsFeeds, 0, 0);
        this.code = typedArray.getString(R.styleable.NativeAdsFeeds_inventoryId);
        this.versionName = typedArray.getString(R.styleable.NativeAdsFeeds_versionName);
        this.packageName = typedArray.getString(R.styleable.NativeAdsFeeds_packagename);
        this.versionCode = typedArray.getInt(R.styleable.NativeAdsFeeds_versionCode, 1);
        AdsFunListener funListener = new AdsFunListener(){

            @Override
            public void reQuestAdsSuccess(Data data, int code) {
                android.util.Log.d((String)"TAG", (String)"reQuestAdsSuccess");
            }

            @Override
            public void requestAdsNativeSuccess(final Data data) {
                Gson gson = new Gson();
                String dataStr = gson.toJson((Object)data);
                android.util.Log.d((String)"TAG", (String)("Something data : " + dataStr));
                Glide.with((Context)context).asBitmap().load(data.getMetaData().getLogoImage().getData() != null ? data.getMetaData().getLogoImage().getData() : "").apply(new RequestOptions().override((int)NativeAdsFeedVideo.this.getResources().getDimension(R.dimen._32sdp), (int)NativeAdsFeedVideo.this.getResources().getDimension(R.dimen._32sdp))).into(NativeAdsFeedVideo.this.img_logo_video);
                NativeAdsFeedVideo.this.text_title_video.setText((CharSequence)data.getMetaData().getLongTitle().getData());
                NativeAdsFeedVideo.this.text_description_video.setText((CharSequence)data.getMetaData().getLongDescription().getData());
                View.OnClickListener onClickListener = new View.OnClickListener(){

                    public void onClick(View view) {
                        android.util.Log.d((String)"TAG", (String)"click to here");
                        Intent intent = new Intent("android.intent.action.VIEW");
                        intent.setFlags(0x30000000);
                        intent.setData(Uri.parse((String)data.getMetaData().getCta0().getLink()));
                        context.startActivity(intent);
                    }
                };
                NativeAdsFeedVideo.this.img_logo_video.setOnClickListener(onClickListener);
                NativeAdsFeedVideo.this.text_title_video.setOnClickListener(onClickListener);
                NativeAdsFeedVideo.this.text_description_video.setOnClickListener(onClickListener);
                NativeAdsFeedVideo.this.text_install_video.setOnClickListener(onClickListener);
                NativeAdsFeedVideo.this.view_title_video.setOnClickListener(onClickListener);
                NativeAdsFeedVideo.this.layout_install_video.setOnClickListener(onClickListener);
                NativeAdsFeedVideo.this.btn_playnow_video.setOnClickListener(onClickListener);
                if (Util.SDK_INT > 23) {
                    NativeAdsFeedVideo.this.initializePlayer(context);
                    if (NativeAdsFeedVideo.this.playerView != null) {
                        NativeAdsFeedVideo.this.playerView.onResume();
                    }
                }
            }

            @Override
            public void isShowAds(boolean isShow) {
                android.util.Log.d((String)"TAG", (String)"isShowAds");
            }

            @Override
            public void isCloseAds(boolean isClose) {
                android.util.Log.d((String)"TAG", (String)"isCloseAds");
            }

            @Override
            public void isLoadAdsError() {
                android.util.Log.d((String)"TAG", (String)"isLoadAdsError");
            }
        };
        this.requestAdsFun = new RequestAdsFun.RequestAdsBuilder().adsCode(this.code).of(context).addListener(funListener).adsUserId("userId").addPakageName(this.packageName).addVersionCode(this.versionCode).addVersionName(this.versionName).build();
        this.requestAdsFun.requestAds();
    }

    private synchronized void initializePlayer(final Context context) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NativeAdsFeedVideo.this.mediaSource = NativeAdsFeedVideo.this.buildMediaSource();
                try {
                    if (NativeAdsFeedVideo.this.mediaSource != null) {
                        if (NativeAdsFeedVideo.this.player == null) {
                            NativeAdsFeedVideo.this.initPlayer(context);
                        }
                        NativeAdsFeedVideo.this.player.prepare(NativeAdsFeedVideo.this.mediaSource);
                        NativeAdsFeedVideo.this.player.setPlayWhenReady(true);
                    }
                    Log.i((String)"playfun.ads.android.sdk.component", (String)("PopUpAdsDialogVideo: initializePlayer" + NativeAdsFeedVideo.this.mediaSource.toString()));
                }
                catch (Exception e) {
                    System.out.println("player is null");
                }
            }
        }).start();
    }

    @SuppressLint(value={"NewApi"})
    private void initPlayer(Context context) {
        if (context == null) {
            return;
        }
        try {
            if (this.player == null) {
                this.player = ExoPlayerFactory.newSimpleInstance((Context)context);
                this.playerView.setPlayer((Player)this.player);
                this.player.addListener((Player.EventListener)this);
            }
        }
        catch (Exception e) {
            System.out.println("can not initalize, Player view is null");
        }
        Log.i((String)"playfun.ads.android.sdk.component", (String)"PopUpAdsDialogVideo: initPlayer");
    }

    private MediaSource buildMediaSource() {
        MediaSource videoSource = null;
        try {
            videoSource = MediaSourseInstance.getInstance().getVideoSource();
        }
        catch (Exception e) {
            System.out.println("Media sourse is null");
        }
        return videoSource;
    }
}

