/*
 * Decompiled with CFR 0.152.
 */
package playfun.ads.android.sdk.component.factory;

import android.annotation.SuppressLint;
import android.content.Context;
import android.util.Log;
import java.util.List;
import playfun.ads.android.sdk.component.callback.GetListInventoryIdCallbackImpl;
import playfun.ads.android.sdk.component.callback.GetListInventoryListener;
import playfun.ads.android.sdk.component.model.networkmodel.DataInventory;
import playfun.ads.android.sdk.component.model.networkmodel.InventoryIdModel;
import playfun.ads.android.sdk.component.network.Repo;
import playfun.ads.android.sdk.component.util.Preference;
import retrofit2.Call;
import retrofit2.Response;

public class RequestListInventoryId {
    private String adsKey;
    private Context context;
    private String userId;
    private String packageName;
    private String versionName;
    private String versionCode;
    private String advertisingId;
    private GetListInventoryListener listener;
    private List<DataInventory> dataInventorys;

    public RequestListInventoryId(String adsKey, Context context, GetListInventoryListener listener, String userId, String packageName, String versionName, String versionCode, String advertisingId) {
        this.adsKey = adsKey;
        this.context = context;
        this.userId = userId;
        this.packageName = packageName;
        this.versionName = versionName;
        this.versionCode = versionCode;
        this.advertisingId = advertisingId;
        this.listener = listener;
    }

    public void getListInventoryId() {
        GetListInventoryIdCallbackImpl<InventoryIdModel> getListInventoryIdCallback = new GetListInventoryIdCallbackImpl<InventoryIdModel>(){

            @Override
            public void onSuccess(Response<InventoryIdModel> onSuccess) {
                try {
                    RequestListInventoryId.this.dataInventorys = ((InventoryIdModel)onSuccess.body()).getData();
                    if (RequestListInventoryId.this.listener != null) {
                        RequestListInventoryId.this.listener.getListInventoryIdSuccess(RequestListInventoryId.this.dataInventorys);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void onError(int errorCode, String message) {
                if (RequestListInventoryId.this.listener != null) {
                    RequestListInventoryId.this.listener.getListInventoryIdError(errorCode, message);
                }
            }

            @Override
            public void onFail(Call<InventoryIdModel> call) {
                if (RequestListInventoryId.this.listener != null) {
                    RequestListInventoryId.this.listener.getListInventoryIdFail();
                    System.out.printf("playfun.ads.android.sdk.component", "" + call.toString());
                }
            }
        };
        try {
            Repo.getRePo().getListInventoryId(getListInventoryIdCallback, this.adsKey);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getListInventoryJson(Context context) {
        Log.d((String)"Tag", (String)("json result" + Preference.getString(context, "LIST_INVENTORY")));
        return Preference.getString(context, "LIST_INVENTORY");
    }

    public GetListInventoryListener getListInventoryListener() {
        return this.listener;
    }

    public static class RequestListInventoryIdBuilder {
        private String adsKey;
        private Context context;
        private String userId;
        private String packageName;
        private String versionName;
        private String versionCode;
        private String advertisingId;
        private GetListInventoryListener listener;

        public RequestListInventoryIdBuilder of(Context context) {
            this.context = context;
            return this;
        }

        public RequestListInventoryIdBuilder context(Context context) {
            this.context = context;
            return this;
        }

        public RequestListInventoryIdBuilder addAdsKey(String adsKey) {
            this.adsKey = adsKey;
            return this;
        }

        public RequestListInventoryIdBuilder addUserId(String userId) {
            this.userId = userId;
            return this;
        }

        public RequestListInventoryIdBuilder addPackageName(String packageName) {
            this.packageName = packageName;
            return this;
        }

        public RequestListInventoryIdBuilder addVersionName(String versionName) {
            this.versionName = versionName;
            return this;
        }

        public RequestListInventoryIdBuilder addVersionCode(String versionCode) {
            this.versionCode = versionCode;
            return this;
        }

        public RequestListInventoryIdBuilder addAdvertisingId(String advertisingId) {
            this.advertisingId = advertisingId;
            return this;
        }

        public RequestListInventoryIdBuilder addListener(GetListInventoryListener getListInventoryListener) {
            this.listener = getListInventoryListener;
            return this;
        }

        @SuppressLint(value={"LongLogTag"})
        public RequestListInventoryId build() {
            RequestListInventoryId requestListInventoryId = null;
            try {
                requestListInventoryId = new RequestListInventoryId(this.adsKey, this.context, this.listener, this.userId, this.packageName, this.versionName, this.versionCode, this.advertisingId);
            }
            catch (Exception e) {
                System.out.printf("playfun.ads.android.sdk.component", "Context is null");
                e.printStackTrace();
            }
            return requestListInventoryId;
        }
    }
}

