/*
 * Decompiled with CFR 0.152.
 */
package playfun.ads.android.sdk.component.view;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import java.util.ArrayList;
import playfun.ads.android.sdk.R;

public class DrawView
extends View
implements View.OnTouchListener {
    private Canvas mCanvas;
    private Path mPath;
    public Paint mPaint;
    Rect rect;
    private ArrayList<Path> paths = new ArrayList();
    public Bitmap bmp;
    public Bitmap image;
    public int h = 0;
    public int w = 0;
    private float mX;
    private float mY;
    private static final float TOUCH_TOLERANCE = 0.0f;

    public DrawView(Context context) {
        super(context);
        this.setFocusable(true);
        this.setFocusableInTouchMode(true);
        this.setOnTouchListener(this);
        this.bmp = BitmapFactory.decodeResource((Resources)this.getResources(), (int)R.drawable.imagescroll);
        this.mPaint = new Paint();
        this.mPaint.setAntiAlias(true);
        this.mPaint.setDither(true);
        this.mPaint.setColor(-16776961);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setStrokeJoin(Paint.Join.ROUND);
        this.mPaint.setStrokeCap(Paint.Cap.ROUND);
        this.mPaint.setStrokeWidth(6.0f);
        this.mCanvas = new Canvas();
        this.mPath = new Path();
        this.paths.add(this.mPath);
        this.h = this.bmp.getHeight() / 2;
        this.rect = new Rect();
        this.rect.set(0, 0, this.bmp.getWidth(), this.h);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
    }

    protected void onDraw(Canvas canvas) {
        if (this.h > this.bmp.getHeight()) {
            return;
        }
        this.image = Bitmap.createBitmap((Bitmap)this.bmp, (int)0, (int)0, (int)this.bmp.getWidth(), (int)this.h);
        Rect bount = new Rect();
        bount.set(0, 20, this.image.getWidth(), this.image.getHeight() - 20);
        canvas.drawBitmap(this.image, bount, this.rect, this.mPaint);
        Log.d((String)"canvast_ads", (String)("draw" + this.rect.height() + "-" + this.image.getHeight()));
    }

    private void touch_start(float x, float y) {
        this.mPath.reset();
        this.mPath.moveTo(x, y);
        this.mX = x;
        this.mY = y;
    }

    private void touch_move(float x, float y) {
        float dx = Math.abs(x - this.mX);
        float dy = Math.abs(y - this.mY);
        if (dx >= 0.0f || dy >= 0.0f) {
            this.mPath.quadTo(this.mX, this.mY, (x + this.mX) / 2.0f, (y + this.mY) / 2.0f);
            this.mX = x;
            this.mY = y;
        }
        Log.d((String)"canvast_ads", (String)("touch_move" + dx + "/" + dy));
    }

    private void touch_up() {
        this.mPath.lineTo(this.mX, this.mY);
        this.mCanvas.drawPath(this.mPath, this.mPaint);
        this.mPath = new Path();
        this.paths.add(this.mPath);
        this.h += 20;
        Log.d((String)"canvast_ads", (String)("touch_up" + this.mX + "/" + this.mY));
    }

    public boolean onTouch(View arg0, MotionEvent event) {
        float x = event.getX();
        float y = event.getY();
        Log.d((String)"canvast_ads", (String)("onTouch" + x + "/" + y));
        switch (event.getAction()) {
            case 0: {
                this.touch_start(x, y);
                this.invalidate();
                break;
            }
            case 2: {
                this.touch_move(x, y);
                this.invalidate();
                break;
            }
            case 1: {
                this.touch_up();
                this.invalidate();
            }
        }
        return true;
    }
}

