/*
 * Decompiled with CFR 0.152.
 */
package playfun.ads.android.sdk.component.network;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.concurrent.TimeUnit;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.ResponseBody;
import okhttp3.logging.HttpLoggingInterceptor;
import playfun.ads.android.sdk.component.network.CustomInterceptor;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

public class RetrofitHelper {
    private static final String TAG = RetrofitHelper.class.getSimpleName();

    public static <T> T createServiceProduct(Class<T> service) {
        Retrofit retrofit = new Retrofit.Builder().baseUrl("https://ads-api.playfun.vn/").addConverterFactory((Converter.Factory)new NullOnEmptyConverterFactory()).addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)RetrofitHelper.getGson())).client(RetrofitHelper.provideOkHttpClient()).build();
        return (T)retrofit.create(service);
    }

    public static <T> T createServicePixel(Class<T> service) {
        Retrofit retrofit = new Retrofit.Builder().baseUrl("https://storage.googleapis.com/prod-adsfun").addConverterFactory((Converter.Factory)new NullOnEmptyConverterFactory()).addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)RetrofitHelper.getGson())).client(RetrofitHelper.provideOkHttpClient()).build();
        return (T)retrofit.create(service);
    }

    private static Gson getGson() {
        return new GsonBuilder().setLenient().create();
    }

    private static OkHttpClient provideOkHttpClient() {
        HttpLoggingInterceptor logging = new HttpLoggingInterceptor();
        logging.setLevel(HttpLoggingInterceptor.Level.NONE);
        return new OkHttpClient.Builder().addInterceptor((Interceptor)new CustomInterceptor()).addInterceptor((Interceptor)logging).connectTimeout(30L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS).writeTimeout(30L, TimeUnit.SECONDS).retryOnConnectionFailure(true).build();
    }

    private static class NullOnEmptyConverterFactory
    extends Converter.Factory {
        private NullOnEmptyConverterFactory() {
        }

        public Converter<ResponseBody, ?> responseBodyConverter(Type type, Annotation[] annotations, Retrofit retrofit) {
            final Converter delegate = retrofit.nextResponseBodyConverter((Converter.Factory)this, type, annotations);
            return new Converter<ResponseBody, Object>(){

                public Object convert(ResponseBody value) throws IOException {
                    if (value.contentLength() == 0L) {
                        return null;
                    }
                    return delegate.convert((Object)value);
                }
            };
        }
    }
}

