package playfun.ads.android.sdk.component.factory;

import android.annotation.SuppressLint;
import android.content.Context;
import android.util.Log;

import playfun.ads.android.sdk.component.callback.AdsFunListener;
import playfun.ads.android.sdk.component.callback.FundAdsRequestCallBackImpl;
import playfun.ads.android.sdk.component.factory.bannerfactory.BannerAdsBlur;
import playfun.ads.android.sdk.component.factory.bannerfactory.BannerAdsWhite;
import playfun.ads.android.sdk.component.model.networkmodel.AdsFunModel;
import playfun.ads.android.sdk.component.model.networkmodel.Data;
import playfun.ads.android.sdk.component.network.Repo;
import playfun.ads.android.sdk.component.observer.AdsServices;
import playfun.ads.android.sdk.component.sate.FunAdsView;
import playfun.ads.android.sdk.component.util.AdsUtils;
import playfun.ads.android.sdk.component.util.MediaSourseInstance;
import playfun.ads.android.sdk.component.util.PopUpType;
import playfun.ads.android.sdk.component.util.ScreenUtil;
import playfun.ads.android.sdk.component.util.UserInfor;
import retrofit2.Call;
import retrofit2.Response;

public class RequestAdsFun {
    private AdsFunFactory adsFunFactory;

    private String iventoriId;

    private AdsServices services;

    private Data data;

    private AdsFunListener listener;

    private Context context;

    private String userId = "";

    private String package_name = "";

    private String version_name = "";

    private int version_code = 0;

    private String advertisingId = "";
    private String isVip = "";

    public RequestAdsFun(String iventoriId, Context context, AdsFunListener listener,String userId
            ,String package_name,String version_name,int version_code, String advertisingId , String isVip) {
        super();
        this.iventoriId = iventoriId;
        this.context = context;
        this.listener = listener;
        this.userId = userId;
        this.package_name = package_name;
        this.version_name = version_name;
        this.version_code = version_code;
        this.advertisingId = advertisingId;
        this.isVip = isVip;
        UserInfor userInfor = UserInfor.getInstance();
        userInfor.setPackage_name(this.package_name);
        userInfor.setIsVip(this.isVip);
        userInfor.setUserId(this.userId);
        userInfor.setVersion_name(this.version_name);
        userInfor.setVersion_code(String.valueOf(this.version_code));
        userInfor.setDevice_resolution(String.valueOf("w:" + ScreenUtil.getWidthDevices(context)
                + "\t" + "h:" + ScreenUtil.getHeigtDevices(context) ));
        userInfor.setPackage_name(context.getPackageName());
        userInfor.setAdvertisingId(this.advertisingId);
        if (ScreenUtil.isLandScape(context)) {
            userInfor.setOrientation("landScape");
            return;
        }
        userInfor.setOrientation("portrait");
    }

    public Context getContext() {
        return context;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public String getIventoriId() {
        return iventoriId;
    }

    public void setIventoriId(String iventoriId) {
        this.iventoriId = iventoriId;
    }


    @SuppressLint("LongLogTag")
    public synchronized void showAds() {
        FunAdsView funAdsView;
        String type = "";
        if (data == null) {
            Log.i(AdsUtils.TAG,"DATA IS NULL");
            return;
        }

        try {
            adsFunFactory = new AdsFunFactory(context);
            type = data.getTemplateType();
            Log.i(AdsUtils.TAG,"AdsFunFactory: " + adsFunFactory.toString());
            Log.i(AdsUtils.TAG,"Data: " + data.toString());
        } catch (Exception e) {
            System.out.printf(AdsUtils.TAG,"AdsFunFactory null");
            System.out.printf(AdsUtils.TAG,e.toString());
            e.printStackTrace();
        }

        try {
            services = new AdsServices.AdsServiceBuilder()
                    .setData(data)
                    .setListener(listener)
                    .build();
            Log.i(AdsUtils.TAG,"AdsServices: " + services.toString());
        } catch (Exception e) {
            System.out.printf(AdsUtils.TAG,"AdsServices is null");
            e.printStackTrace();
        }
        if(type.equals(AdsUtils.INLINE_BLUR) )
            checkBannerBlurIshow();
        if(type.equals(AdsUtils.INLINE_BLUR))
            checkBannerWhiteIshow();
        try {
            funAdsView = initPopUpSdk(type);
            if (funAdsView != null) {
                funAdsView.showFunAds();
                services.attach(funAdsView);
                services.notifyAllObserver();
            }
            Log.i(AdsUtils.TAG,funAdsView.toString());
        } catch (Exception e) {
            System.out.printf(AdsUtils.TAG,"FunadsView is null");
            e.printStackTrace();
        }
    }
    @SuppressLint("LongLogTag")
    private void checkBannerWhiteIshow() {
        try {
            BannerAdsWhite bannerAdsWhite = BannerAdsWhite.getBannerInstacne();
            if (bannerAdsWhite.isShow) {
                bannerAdsWhite.hideFunAds();
            }
        } catch (Exception e) {
            System.out.printf(AdsUtils.TAG,"Can not hide Banner Ads");
            e.printStackTrace();
        }
        Log.i(AdsUtils.TAG,"BannerAds is show: " + "checkBannerIshow");
    }
    @SuppressLint("LongLogTag")
    private void checkBannerBlurIshow() {
        try {
            BannerAdsBlur bannerAdsBlur = BannerAdsBlur.getBannerInstacne();
            if (bannerAdsBlur.isShow) {
                bannerAdsBlur.hideFunAds();
            }
        } catch (Exception e) {
            System.out.printf(AdsUtils.TAG,"Can not hide Banner Ads");
            e.printStackTrace();
        }
        Log.i(AdsUtils.TAG,"BannerAds is show: " + "checkBannerIshow");
    }

    @SuppressLint("LongLogTag")
    private FunAdsView initPopUpSdk(String type) throws IllegalAccessException {
        Log.i(AdsUtils.TAG,"FunAdsView: " + "initPopUpSdk");
        switch (type) {
            case AdsUtils.PICTURE:
                return adsFunFactory.createPopUp(PopUpType.POPUP);
            case AdsUtils.VIDEO:
                return adsFunFactory.createPopUp(PopUpType.VIDEO);
            case AdsUtils.LONG_IMAGES:
                return adsFunFactory.createPopUp(PopUpType.LONG_IMAGE);
            case AdsUtils.INLINE_BLUR:
                return adsFunFactory.createPopUp(PopUpType.BANNER_BLUR);
            case AdsUtils.INLINE_WHITE:
                return adsFunFactory.createPopUp(PopUpType.BANNER_WHITE);
            default:
                throw new IllegalAccessException("Not Support Ads");
        }
    }

    public void requestAds() {
        FundAdsRequestCallBackImpl<AdsFunModel> funModelFundAdsRequestCallBack = new FundAdsRequestCallBackImpl<AdsFunModel>() {

            @Override
            public void success(Response<AdsFunModel> success) {
                try {
                    data = success.body().getData();
                    if (data.getTemplateType().equals("videos")) {
                        if (context == null) {
                            return;
                        }
                        if(data.getMetaData().getVideo().getData() != null)
                            MediaSourseInstance.getInstance().buildMediaSource(context.getApplicationContext(), data.getMetaData().getVideo().getData().replace(" ", "%20"));
                    }
                    if (listener != null) {
                        listener.reQuestAdsSuccess(200);
                    }
                } catch (Exception e) {
                    System.out.println(e.getMessage());
                    System.out.println("Can not get data, Data get is null");
                    e.printStackTrace();
                }
            }

            @Override
            public void error(int error) {
                if (listener != null) {
                    listener.isLoadAdsError();
                }
            }

            @Override
            public void fail(Call<AdsFunModel> call) {
                if (listener != null) {
                    listener.isLoadAdsError();
                    System.out.printf(AdsUtils.TAG,"" + call.toString());
                }
            }
        };
        try {
            Repo.getRePo().requestAds(funModelFundAdsRequestCallBack, iventoriId);
        } catch (Exception e) {
            System.out.println("can not call request ads");
            e.printStackTrace();
        }

    }

    public static class RequestAdsBuilder {

        private String iventoriId;

        private Context context;

        private AdsFunListener listener;

        private String userId = "";

        private String package_name = "";

        private String version_name = "";

        private int version_code = 0;
        private String advertisingId = "";
        private String isVip = "";

        public RequestAdsBuilder() {
        }

        public RequestAdsBuilder of(Context context) {
            this.context = context;
            return this;
        }

        public RequestAdsBuilder context(Context context) {
            this.context = context;
            return this;
        }

        public RequestAdsBuilder adsId(String iventoriId) {
            this.iventoriId = iventoriId;
            return this;
        }

        public RequestAdsBuilder addListener(AdsFunListener listener) {
            try {
                this.listener = listener;
            } catch (Exception e) {
                System.out.println("Listener is null");
            }
            return this;
        }

        public RequestAdsBuilder adsUserId(String userId) {
            this.userId = userId;
            return this;
        }

        public RequestAdsBuilder addPakageName(String package_name) {
            this.package_name = package_name;
            return this;
        }

        public RequestAdsBuilder isVip(String isVip){
            this.isVip = isVip;
            return this;
        }

        public RequestAdsBuilder addVersionName(String version_name) {
            this.version_name = version_name;
            return this;
        }

        public RequestAdsBuilder addVersionCode(int version_code) {
            this.version_code = version_code;
            return this;
        }

        public RequestAdsBuilder addAdsVertisingId (String advertisingId) {
            this.advertisingId = advertisingId;
            return this;
        }

        @SuppressLint("LongLogTag")
        public RequestAdsFun build() {
            RequestAdsFun requestAdsFun = null;
            try {
                requestAdsFun = new RequestAdsFun(iventoriId, context, listener,userId,package_name,version_name,version_code,advertisingId , isVip);
            } catch (Exception e) {
                System.out.printf(AdsUtils.TAG,"Context is null");
                e.printStackTrace();
            }
            return requestAdsFun;
        }
    }
}
