/*
 * Decompiled with CFR 0.152.
 */
package playfun.ads.android.sdk.component.blur;

import android.app.Activity;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.Choreographer;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import java.lang.ref.WeakReference;
import playfun.ads.android.sdk.R;
import playfun.ads.android.sdk.component.blur.BlurKit;

public class BlurLayout
extends FrameLayout {
    public static final float DEFAULT_DOWNSCALE_FACTOR = 0.12f;
    public static final int DEFAULT_BLUR_RADIUS = 12;
    public static final int DEFAULT_FPS = 60;
    private float mDownscaleFactor;
    private int mBlurRadius;
    private int mFPS;
    private WeakReference<View> mActivityView;
    private Choreographer.FrameCallback invalidationLoop = new Choreographer.FrameCallback(){

        public void doFrame(long frameTimeNanos) {
            BlurLayout.this.invalidate();
            Choreographer.getInstance().postFrameCallbackDelayed((Choreographer.FrameCallback)this, (long)(1000 / BlurLayout.this.mFPS));
        }
    };

    public BlurLayout(Context context) {
        super(context, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BlurLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        BlurKit.init(context);
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.BlurLayout, 0, 0);
        try {
            this.mDownscaleFactor = a.getFloat(R.styleable.BlurLayout_downscaleFactor, 0.12f);
            this.mBlurRadius = a.getInteger(R.styleable.BlurLayout_blurRadius, 12);
            this.mFPS = a.getInteger(R.styleable.BlurLayout_fps, 60);
        }
        finally {
            a.recycle();
        }
        if (this.mFPS > 0) {
            Choreographer.getInstance().postFrameCallback(this.invalidationLoop);
        }
    }

    public void invalidate() {
        super.invalidate();
        Bitmap bitmap = this.blur();
        if (bitmap != null) {
            this.setBackground((Drawable)new BitmapDrawable(bitmap));
        }
    }

    private Bitmap blur() {
        Bitmap bitmap;
        if (this.getContext() == null) {
            return null;
        }
        if (this.mActivityView == null || this.mActivityView.get() == null) {
            this.mActivityView = new WeakReference<View>(this.getActivityView());
            if (this.mActivityView.get() == null) {
                return null;
            }
        }
        Point pointRelativeToActivityView = this.getPositionInScreen();
        this.setAlpha(0.0f);
        int screenWidth = ((View)this.mActivityView.get()).getWidth();
        int screenHeight = ((View)this.mActivityView.get()).getHeight();
        int width = (int)((float)this.getWidth() * this.mDownscaleFactor);
        int height = (int)((float)this.getHeight() * this.mDownscaleFactor);
        int x = (int)((float)pointRelativeToActivityView.x * this.mDownscaleFactor);
        int y = (int)((float)pointRelativeToActivityView.y * this.mDownscaleFactor);
        int xPadding = this.getWidth() / 8;
        int yPadding = this.getHeight() / 8;
        int leftOffset = -xPadding;
        leftOffset = x + leftOffset >= 0 ? leftOffset : 0;
        int rightOffset = xPadding;
        rightOffset = x + this.getWidth() + rightOffset <= screenWidth ? rightOffset : screenWidth - this.getWidth() - x;
        int topOffset = -yPadding;
        topOffset = y + topOffset >= 0 ? topOffset : 0;
        int bottomOffset = yPadding;
        bottomOffset = y + height + bottomOffset <= screenHeight ? bottomOffset : 0;
        try {
            bitmap = this.getDownscaledBitmapForView((View)this.mActivityView.get(), new Rect(pointRelativeToActivityView.x + leftOffset, pointRelativeToActivityView.y + topOffset, pointRelativeToActivityView.x + this.getWidth() + Math.abs(leftOffset) + rightOffset, pointRelativeToActivityView.y + this.getHeight() + Math.abs(topOffset) + bottomOffset), this.mDownscaleFactor);
        }
        catch (NullPointerException e) {
            return null;
        }
        bitmap = BlurKit.getInstance().blur(bitmap, this.mBlurRadius);
        bitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)((int)((float)Math.abs(leftOffset) * this.mDownscaleFactor)), (int)((int)((float)Math.abs(topOffset) * this.mDownscaleFactor)), (int)width, (int)height);
        this.setAlpha(1.0f);
        return bitmap;
    }

    private View getActivityView() {
        Activity activity;
        try {
            activity = (Activity)this.getContext();
        }
        catch (ClassCastException e) {
            return null;
        }
        return activity.getWindow().getDecorView().findViewById(0x1020002);
    }

    private Point getPositionInScreen() {
        return this.getPositionInScreen((View)this);
    }

    private Point getPositionInScreen(View view) {
        ViewGroup parent;
        if (this.getParent() == null) {
            return new Point();
        }
        try {
            parent = (ViewGroup)view.getParent();
        }
        catch (Exception e) {
            return new Point();
        }
        if (parent == null) {
            return new Point();
        }
        Point point = this.getPositionInScreen((View)parent);
        point.offset((int)view.getX(), (int)view.getY());
        return point;
    }

    private Bitmap getDownscaledBitmapForView(View view, Rect crop, float downscaleFactor) throws NullPointerException {
        View screenView = view.getRootView();
        int width = (int)((float)crop.width() * downscaleFactor);
        int height = (int)((float)crop.height() * downscaleFactor);
        if (screenView.getWidth() <= 0 || screenView.getHeight() <= 0 || width <= 0 || height <= 0) {
            throw new NullPointerException();
        }
        float dx = (float)(-crop.left) * downscaleFactor;
        float dy = (float)(-crop.top) * downscaleFactor;
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_4444);
        Canvas canvas = new Canvas(bitmap);
        Matrix matrix = new Matrix();
        matrix.preScale(downscaleFactor, downscaleFactor);
        matrix.postTranslate(dx, dy);
        canvas.setMatrix(matrix);
        screenView.draw(canvas);
        return bitmap;
    }

    public void setDownscaleFactor(float downscaleFactor) {
        this.mDownscaleFactor = downscaleFactor;
        this.invalidate();
    }

    public void setBlurRadius(int blurRadius) {
        this.mBlurRadius = blurRadius;
        this.invalidate();
    }

    public void setFPS(int fps) {
        this.mFPS = fps;
    }
}

