/*
 * Decompiled with CFR 0.152.
 */
package playfun.ads.android.sdk.component.factory.popupfactory;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.AssetManager;
import android.graphics.Bitmap;
import android.graphics.Typeface;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.SpannableStringBuilder;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.request.RequestOptions;
import com.bumptech.glide.request.target.SimpleTarget;
import com.bumptech.glide.request.target.Target;
import com.bumptech.glide.request.transition.Transition;
import playfun.ads.android.sdk.R;
import playfun.ads.android.sdk.component.blur.BlurLayout;
import playfun.ads.android.sdk.component.factory.popupfactory.BasePopUp;
import playfun.ads.android.sdk.component.util.AdsUtils;
import playfun.ads.android.sdk.component.util.ImageHelper;
import playfun.ads.android.sdk.component.util.ScreenUtil;

public class PopUpAdsDialog
extends BasePopUp {
    private ImageView mLagreImageView;
    private ImageView mSmallImage;
    private Button mClose;
    private RelativeLayout mDownload;
    private RelativeLayout rlt_down;
    private BlurLayout rlt_down_land;
    private String mAction;
    private TextView mTitle;
    private TextView mContent;
    private TextView mTvDownLoad;

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    @Override
    @SuppressLint(value={"LongLogTag"})
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.popup_portrait_withbutton, container, true);
        this.initView(view);
        Log.i((String)"playfun.ads.android.sdk.component", (String)"PopUpAdsDialog: onCreateView");
        return view;
    }

    @SuppressLint(value={"LongLogTag"})
    private void initView(View view) {
        this.mClose = (Button)view.findViewById(R.id.btn_close_popup);
        this.mContent = (TextView)view.findViewById(R.id.tv_content);
        this.mTitle = (TextView)view.findViewById(R.id.tv_title);
        this.mLagreImageView = (ImageView)view.findViewById(R.id.image_main_content);
        this.mSmallImage = (ImageView)view.findViewById(R.id.image_small_content);
        this.mDownload = (RelativeLayout)view.findViewById(R.id.btn_download);
        this.mTvDownLoad = (TextView)view.findViewById(R.id.tv_download);
        if (!ScreenUtil.isLandScape((Context)this.getActivity())) {
            this.rlt_down = (RelativeLayout)view.findViewById(R.id.rlt_down);
            this.rlt_down.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    PopUpAdsDialog.this.handleClick();
                }
            });
        } else {
            this.rlt_down_land = (BlurLayout)view.findViewById(R.id.rlt_down_land);
            this.rlt_down_land.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    PopUpAdsDialog.this.handleClick();
                }
            });
        }
        try {
            if (this.data.getMetaData().getCta0() != null && this.data.getMetaData().getCta0().getLink() != null) {
                this.mTvDownLoad.setText((CharSequence)this.data.getMetaData().getCta0().getLabel());
                this.mAction = this.data.getMetaData().getCta0().getLink();
            }
            Typeface typeface = Typeface.createFromAsset((AssetManager)this.getActivity().getAssets(), (String)"sftnormal.ttf");
            int textSize = (int)this.getResources().getDimension(R.dimen._11sdp);
            int marginRigth = (int)this.getResources().getDimension(R.dimen._7sdp);
            int marginTop = (int)this.getResources().getDimension(R.dimen._2sdp);
            int corner = (int)this.getResources().getDimension(R.dimen._4sdp);
            int marginLeft = (int)this.getResources().getDimension(R.dimen._4sdp);
            SpannableStringBuilder builder = AdsUtils.setTexSpanBoder(this.data.getMetaData().getShortTitle().getData() != null ? this.data.getMetaData().getShortTitle().getData() : "", "Free", textSize, typeface, marginRigth, marginLeft, marginTop, corner);
            this.mTitle.setText((CharSequence)builder);
            Glide.with((Activity)this.getActivity()).asBitmap().load(this.data.getMetaData().getImageBanner().getData() != null ? this.data.getMetaData().getImageBanner().getData() : "").apply(new RequestOptions().override((int)this.getResources().getDimension(R.dimen._351sdp), (int)this.getResources().getDimension(R.dimen._177sdp))).into(this.mLagreImageView);
            Glide.with((Activity)this.getActivity()).asBitmap().load(this.data.getMetaData().getLogoImage().getData() != null ? this.data.getMetaData().getLogoImage().getData() : "").into((Target)new SimpleTarget<Bitmap>(){

                public void onResourceReady(@NonNull Bitmap resource, @Nullable Transition<? super Bitmap> transition) {
                    if (ScreenUtil.isLandScape((Context)PopUpAdsDialog.this.getActivity())) {
                        PopUpAdsDialog.this.mTitle.setText((CharSequence)(PopUpAdsDialog.this.data.getMetaData().getShortTitle().getData() != null ? PopUpAdsDialog.this.data.getMetaData().getShortTitle().getData() : ""));
                        PopUpAdsDialog.this.mSmallImage.setImageBitmap(ImageHelper.getRoundedCornerBitmap(resource, ImageHelper.getCornerPixel(resource, 20)));
                    } else {
                        PopUpAdsDialog.this.mSmallImage.setImageBitmap(ImageHelper.getRoundedCornerBitmap(resource, ImageHelper.getCornerPixel(resource, 20)));
                    }
                }
            });
            this.mContent.setText((CharSequence)(this.data.getMetaData().getShortDescription().getData() != null ? this.data.getMetaData().getShortDescription().getData() : ""));
        }
        catch (Exception e) {
            System.out.println("Action is null");
        }
        this.mClose.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                System.out.println("Close_PopUpClose");
                PopUpAdsDialog.this.dismiss();
            }
        });
        this.mContent.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                PopUpAdsDialog.this.handleClick();
            }
        });
        this.mTitle.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                PopUpAdsDialog.this.handleClick();
            }
        });
        this.mLagreImageView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                PopUpAdsDialog.this.handleClick();
            }
        });
        this.mSmallImage.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                PopUpAdsDialog.this.handleClick();
            }
        });
        this.mDownload.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PopUpAdsDialog.this.handleClick();
            }
        });
        Log.i((String)"playfun.ads.android.sdk.component", (String)"PopUpAdsDialog: initView");
    }

    private void handleClick() {
        try {
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.setFlags(0x30000000);
            intent.setData(Uri.parse((String)this.mAction));
            this.startActivity(intent);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onResume() {
        super.onResume();
    }

    public void onPause() {
        super.onPause();
    }

    public void onStop() {
        super.onStop();
    }
}

