package playfun.ads.android.sdk.component.network;

import android.annotation.SuppressLint;
import android.util.Log;

import playfun.ads.android.sdk.component.callback.FundAdsRequestCallBackImpl;
import playfun.ads.android.sdk.component.callback.GetListInventoryIdCallbackImpl;
import playfun.ads.android.sdk.component.model.networkmodel.AdsFunModel;
import playfun.ads.android.sdk.component.model.networkmodel.InventoryIdModel;
import playfun.ads.android.sdk.component.util.AdsUtils;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class Repo {
    private static Repo INSTANCE = null;

    private APIServices apiServices,apiServicesPixel;

    public static int eventoryId;
    public static String inventoriCode;
    public static int raaid;

    @SuppressLint("LongLogTag")
    private Repo() {
        try {
            apiServices = RetrofitHelper.createServiceProduct(APIServices.class);
            apiServicesPixel = RetrofitHelper.createServicePixel(APIServices.class);
            Log.i(AdsUtils.TAG,"APIServices: " + apiServices.toString());
            Log.i(AdsUtils.TAG,"APIServices: " + apiServicesPixel.toString());
        } catch (Exception e) {
            e.printStackTrace();
            System.out.println("can not initalize API services");
        }

    }

    public synchronized static final Repo getRePo() {
        if (INSTANCE == null) {
            INSTANCE = new Repo();
        }
        return INSTANCE;
    }

    public void trackingView(int inventoryId , String inventoryCode , int raaid){
        this.inventoriCode = inventoryCode;
        this.eventoryId = inventoryId;
        this.raaid = raaid;
        trackingView();
    }
    public void trackingView(int raaid){
        this.raaid = raaid;
        trackingView();
    }
    public void trackingView() {
        try {
            Log.d("TAG" , "eventoryId : " +  eventoryId + " raaid : " + raaid);
            apiServicesPixel.trackingShowView(eventoryId , inventoriCode , raaid).enqueue(new Callback<ResponseBody>() {
                @Override
                public void onResponse(Call<ResponseBody> call, retrofit2.Response<ResponseBody> response) {
                    Log.i("tracking_funds","trackingShowView" + response.code());
                }

                @Override
                public void onFailure(Call<ResponseBody> call, Throwable t) {

                }
            });
        } catch (Exception e) {
            System.out.println("can not tracking show view, API services is null");
        }

    }

    public void getListInventoryId(GetListInventoryIdCallbackImpl getListInventoryIdCallback , String adsKey){
        try {
             apiServices.getListInventoryId(adsKey).enqueue(new Callback<InventoryIdModel>() {
                @Override
                public void onResponse(Call<InventoryIdModel> call, Response<InventoryIdModel> response) {
                    try {
                        if(response.isSuccessful()){
                            getListInventoryIdCallback.onSuccess(response);
                        }else{
                            getListInventoryIdCallback.onError(response.code(), response.message());
                        }
                    }catch (Exception e){
                        e.printStackTrace();
                    }
                }

                @Override
                public void onFailure(Call<InventoryIdModel> call, Throwable t) {
                    getListInventoryIdCallback.onFail(call);
                }
            });
        }catch (Exception e){
            e.printStackTrace();
        }
    }

    public void requestAds(FundAdsRequestCallBackImpl requestCallBack , int ivenStoryId , String inventoryCode) {

        try {
            apiServices.fetchAds(inventoryCode).enqueue(new Callback<AdsFunModel>() {
                @SuppressLint("LongLogTag")
                @Override
                public void onResponse(Call<AdsFunModel> call, Response<AdsFunModel> response) {
                    try {
                        if (response.code() == 200) {
                            AdsFunModel adsFunModel = response.body();
                            requestCallBack.success(response);
                            eventoryId = ivenStoryId;
                            inventoriCode = inventoryCode;
                            raaid = adsFunModel.getData().getRaaId();
                            Log.i(AdsUtils.TAG,"response" + response);
                        } else {
                            //TODO @Dương các đoạn error từ server sau này cần bắn event lên log tool & details lỗi để mình còn maintain .
                            requestCallBack.error(response.code());
                        }
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }

                @Override
                public void onFailure(Call<AdsFunModel> call, Throwable t) {
                    requestCallBack.fail(call);
                }
            });
        } catch (Exception e) {
            System.out.println("Can not get ads, API services is null");
        }


    }
}
