package playfun.ads.android.sdk.component.network;

import java.io.IOException;

import playfun.ads.android.sdk.component.util.UserInfor;
import okhttp3.CacheControl;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.logging.HttpLoggingInterceptor;

public class CustomInterceptor implements Interceptor {
    @Override
    public Response intercept(Chain chain) throws IOException {
        Request originalRequest = chain.request();

        UserInfor userInfor = UserInfor.getInstance();
        Headers headers = new Headers.Builder()
                .add("device-name", userInfor.getDevice_name())
                .add("device-os", userInfor.getDevice_os())
                .add("device-resolution", userInfor.getDevice_resolution())
                .add("userId", userInfor.getUserId())
                .add("advertisingId", userInfor.getAdvertisingId())
                .add("package_name", userInfor.getPackage_name())
                .add("version_name", userInfor.getVersion_name())
                .add("version_code", userInfor.getVersion_code())
                .add("orientation", userInfor.getOrientation())
                .add("isVip", userInfor.getIsVip())
                .build();
        Request newRequest = originalRequest.newBuilder()
                .cacheControl(CacheControl.FORCE_CACHE) //  Đặt kiểm soát header là của request này, replace lên mọi header đã có.
                .headers(headers) //Removes all headers on this builder and adds headers.
                .method(originalRequest.method(), null) // Adds request method and request body
                .removeHeader("Authorization") // Removes all the headers with this name
                .build();

        Response response = chain.proceed(newRequest);
        return response;
    }
}
