package playfun.ads.android.sdk.component.util;

import android.content.Context;
import android.net.Uri;

import com.google.android.exoplayer2.source.ExtractorMediaSource;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.upstream.DefaultDataSourceFactory;
import com.google.android.exoplayer2.util.Util;

public class MediaSourseInstance {

    private MediaSource videoSource;

    public static MediaSourseInstance INSTANCE = null;
    private MediaSourseInstance() {

    }

    public static synchronized MediaSourseInstance getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new MediaSourseInstance();
        }
        return INSTANCE;
    }

    public void buildMediaSource(Context context, String url) {
        DefaultDataSourceFactory fac = new DefaultDataSourceFactory(context,
                Util.getUserAgent(context, "ADS"));
        videoSource = new ExtractorMediaSource.Factory(fac)
                .createMediaSource(Uri.parse(url));
    }

    public MediaSource getVideoSource() {
        return videoSource;
    }
}
