package playfun.ads.android.sdk.component.observer;

import java.util.ArrayList;
import java.util.List;

import playfun.ads.android.sdk.component.callback.AdsFunListener;
import playfun.ads.android.sdk.component.model.networkmodel.Data;

public class AdsServices implements Subject {

    private Data data;

    private AdsFunListener adsFunListener;

    private AdsFunListener listener;

    private List<FunObserver> list = new ArrayList<>();

    public AdsServices(Data data,AdsFunListener listener) {
        this.data = data;
        this.listener = listener;
    }

    @Override
    public void attach(FunObserver observer) {
        if (!list.contains(observer)) {
            list.add(observer);
        }
    }

    @Override
    public void detach(FunObserver observer) {

        if (list.contains(observer)) {
            list.remove(observer);
        }
    }

    @Override
    public void notifyAllObserver() {

        for (FunObserver observer : list) {
            observer.updateAds(data);
            observer.sendListener(listener);
        }
    }

    public void removeAllObserver() {
        if (list!= null && list.size() > 0) {
            list.isEmpty();
        }
    }

    public int getObserver() {
        return list.size();
    }


    public static class AdsServiceBuilder {
        private Data data;

        private AdsFunListener listener;

        public AdsServiceBuilder setData(Data data) {
            this.data = data;
            return this;
        }

        public AdsServiceBuilder setListener(AdsFunListener listener) {
            this.listener = listener;
            return this;
        }


        public AdsServices build() {
            return new AdsServices(data,listener);
        }
    }
}
