package playfun.ads.android.sdk.component.factory.popupfactory;

import android.app.DialogFragment;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import java.util.List;

import playfun.ads.android.sdk.R;
import playfun.ads.android.sdk.component.callback.AdsFunListener;
import playfun.ads.android.sdk.component.model.networkmodel.Action;
import playfun.ads.android.sdk.component.model.networkmodel.Cta0;
import playfun.ads.android.sdk.component.model.networkmodel.Data;
import playfun.ads.android.sdk.component.network.Repo;
import playfun.ads.android.sdk.component.observer.FunObserver;
import playfun.ads.android.sdk.component.util.AdsUtils;
import playfun.ads.android.sdk.component.util.ScreenUtil;

public class BasePopUp extends DialogFragment implements FunObserver {

    public static AdsFunListener listener;
    public Data data;

    public Cta0 cta0Action;
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (ScreenUtil.isLandScape(getActivity())) {
            setStyle(DialogFragment.STYLE_NO_FRAME,R.style.DialogStyle_LandScape);
        } else {
            setStyle(DialogFragment.STYLE_NO_FRAME,R.style.DialogStyle);
        }
        if (savedInstanceState != null) {
            this.data = savedInstanceState.getParcelable(AdsUtils.KEY_DATA);
            this.cta0Action = data.getMetaData().getCta0();
        }
    }

    @Override
    public View onCreateView(LayoutInflater inflater,ViewGroup container,Bundle savedInstanceState) {
        return super.onCreateView(inflater, container, savedInstanceState);
    }

    @Override
    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putParcelable(AdsUtils.KEY_DATA,data);
    }

    @Override
    public void onResume() {
        super.onResume();
        if (listener!=null) {
            listener.isShowAds(true);
        }
        if (!getDialog().isShowing()) {
            getDialog().show();
        }
        Repo.getRePo().trackingView();
    }

    @Override
    public void updateAds(Data data) {
        Log.d("adsView","updateAds_popup");
        try {
            this.data = data;
            this.cta0Action = data.getMetaData().getCta0();
        } catch (Exception e) {
            System.out.println("Data is null");
        }
    }

    @Override
    public void sendListener(AdsFunListener listener) {
        this.listener = listener;

    }

    public void sendAction() {
        Intent intent = new Intent(Intent.ACTION_VIEW);
        intent.setFlags(Intent.FLAG_ACTIVITY_SINGLE_TOP|Intent.FLAG_ACTIVITY_NEW_TASK);
        intent.setData(Uri.parse(data.getMetaData().getCta0().getLink()));
        startActivity(intent);
    }

    @Override
    public void onDismiss(DialogInterface dialog) {
        super.onDismiss(dialog);
        if (listener!=null) {
            listener.isCloseAds(true);
        }
    }
}
