/*
 * Decompiled with CFR 0.152.
 */
package pl.serwersms.apiv2;

import java.util.ArrayList;
import java.util.HashMap;
import pl.serwersms.apiv2.SerwerSMS;

public class Message {
    private SerwerSMS master = null;

    public Message(SerwerSMS object) throws Exception {
        this.master = object;
    }

    public String sendSms(String phone, String text, String sender, HashMap<String, String> params) {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("phone", phone);
        options.put("text", text);
        options.put("sender", sender);
        params.putAll(options);
        return this.master.send("messages/send_sms", params);
    }

    public String sendPersonalized(ArrayList<HashMap<String, String>> messages, String sender, HashMap<String, String> params) {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("sender", sender);
        StringBuffer messageList = new StringBuffer();
        for (HashMap<String, String> temp : messages) {
            messageList.append(temp.get("phone"));
            messageList.append(":");
            messageList.append(temp.get("text"));
            messageList.append("]|[");
        }
        String message = messageList.toString();
        Integer length = message.length();
        if (length > 3) {
            length = length - 3;
            message = message.substring(0, length);
        }
        options.put("messages", message);
        params.putAll(options);
        return this.master.send("messages/send_personalized", params);
    }

    public String sendVoice(String phone, HashMap<String, String> params) {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("phone", phone);
        params.putAll(options);
        return this.master.send("messages/send_voice", params);
    }

    public String sendMms(String phone, String title, HashMap<String, String> params) {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("phone", phone);
        options.put("title", title);
        params.putAll(options);
        return this.master.send("messages/send_mms", params);
    }

    public String view(String id, HashMap<String, String> params) {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("id", id);
        params.putAll(options);
        return this.master.send("messages/view", params);
    }

    public String reports(HashMap<String, String> params) {
        return this.master.send("messages/reports", params);
    }

    public String delete(String id, String unique_id) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("id", id);
        params.put("unique_id", unique_id);
        return this.master.send("messages/delete", params);
    }

    public String recived(String type, HashMap<String, String> params) {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("type", type);
        params.putAll(options);
        return this.master.send("messages/recived", params);
    }

    public String sendNd(String phone, String text) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("phone", phone);
        params.put("text", text);
        return this.master.send("messages/send_nd", params);
    }

    public String sendNdi(String phone, String text, String ndi_number) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("phone", phone);
        params.put("text", text);
        params.put("ndi_number", ndi_number);
        return this.master.send("messages/send_ndi", params);
    }
}

