/*
 * Decompiled with CFR 0.152.
 */
package pl.rjuszczyk.panorama.viewer;

import android.content.res.Resources;
import android.graphics.Bitmap;
import java.util.HashMap;
import java.util.Map;
import pl.rjuszczyk.panorama.viewer.MyLog;
import pl.rjuszczyk.panorama.viewer.TextureHelper;

public class RawImageDrawer {
    HashMap<Integer, Integer> textures = new HashMap();
    HashMap<Integer, Integer> texturesToReferencesCount = new HashMap();
    Resources resources;

    public RawImageDrawer(Resources r) {
        this.resources = r;
    }

    public void loadTexture(int r_id) {
        int mTextureDataHandle = TextureHelper.loadTexture(this.resources, r_id);
        this.textures.put(r_id, mTextureDataHandle);
    }

    public void loadTexture(Bitmap bitmap) {
        boolean a = this.isPowerOfTwo(bitmap.getHeight());
        boolean b = this.isPowerOfTwo(bitmap.getWidth());
        Bitmap bitmapScaled = bitmap;
        if (!a || !b) {
            int height = a ? bitmap.getHeight() : this.nextPowerOfTwo(bitmap.getHeight());
            int width = b ? bitmap.getWidth() : this.nextPowerOfTwo(bitmap.getWidth());
            bitmapScaled = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)width, (int)height, (boolean)true);
        }
        int mTextureDataHandle = TextureHelper.loadTexture(bitmapScaled);
        this.textures.put(bitmap.hashCode(), mTextureDataHandle);
    }

    private boolean isPowerOfTwo(int number) {
        for (int n = 1; n < number; n <<= 1) {
            if (n != number) continue;
            return true;
        }
        return false;
    }

    private int nextPowerOfTwo(int number) {
        int n;
        for (n = 1; n < number; n <<= 1) {
        }
        return n;
    }

    public int getTextureHandlerOrLoad(Bitmap bitmap) {
        if (!this.textures.containsKey(bitmap.hashCode())) {
            MyLog.e("texutre", "" + bitmap.hashCode());
            this.loadTexture(bitmap);
        }
        int currentReferenceCount = 0;
        int handle = this.textures.get(bitmap.hashCode());
        if (this.texturesToReferencesCount.containsKey(handle)) {
            currentReferenceCount = this.texturesToReferencesCount.get(handle);
        }
        this.texturesToReferencesCount.put(handle, ++currentReferenceCount);
        return handle;
    }

    public void releaseHandle(int handle) {
        int count = this.texturesToReferencesCount.get(handle);
        if (--count == 0) {
            this.texturesToReferencesCount.remove(handle);
        } else {
            this.texturesToReferencesCount.put(handle, count);
        }
        if (count == 0) {
            int removeThisKey = -1;
            for (Map.Entry<Integer, Integer> integerIntegerEntry : this.textures.entrySet()) {
                if (integerIntegerEntry.getValue() != handle) continue;
                removeThisKey = integerIntegerEntry.getKey();
            }
            if (removeThisKey != -1) {
                this.textures.remove(removeThisKey);
            }
            TextureHelper.releaseTexture(handle);
        }
    }

    public int getTextureHandlerOrLoad(int r_id) {
        if (!this.textures.containsKey(r_id)) {
            MyLog.e("texutre", "" + r_id);
            this.loadTexture(r_id);
        }
        int handle = this.textures.get(r_id);
        int currentReferenceCount = 0;
        if (this.texturesToReferencesCount.containsKey(handle)) {
            currentReferenceCount = this.texturesToReferencesCount.get(handle);
        }
        this.texturesToReferencesCount.put(handle, ++currentReferenceCount);
        return handle;
    }

    public int getTextureHandle(int r_id) {
        if (!this.textures.containsKey(r_id)) {
            return -1;
        }
        return this.textures.get(r_id);
    }
}

