/*
 * Decompiled with CFR 0.152.
 */
package pl.rjuszczyk.panorama.viewer;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.PointF;
import android.opengl.GLSurfaceView;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.OrientationEventListener;
import android.view.ScaleGestureDetector;
import java.util.Timer;
import java.util.TimerTask;
import pl.rjuszczyk.panorama.R;
import pl.rjuszczyk.panorama.gyroscope.GyroscopeHandler;
import pl.rjuszczyk.panorama.gyroscope.GyroscopeHandlerOld;
import pl.rjuszczyk.panorama.multitouch.MoveGestureDetector;
import pl.rjuszczyk.panorama.multitouch.RotateGestureDetector;
import pl.rjuszczyk.panorama.viewer.MatrixCalculator;
import pl.rjuszczyk.panorama.viewer.MyLog;
import pl.rjuszczyk.panorama.viewer.OnDrawListener;
import pl.rjuszczyk.panorama.viewer.PanoramaRenderer;
import pl.rjuszczyk.panorama.viewer.RawImageDrawer;

public class PanoramaGLSurfaceView
extends GLSurfaceView {
    public float MAX_X_ROT = Float.NaN;
    public float MIN_X_ROT = Float.NaN;
    public float MAX_Y_ROT = Float.NaN;
    public float MIN_Y_ROT = Float.NaN;
    public float MAX_SCALE = 0.3f;
    public float MIN_SCALE = 0.5f;
    private float DEFAULT_TOUCH_SCALE = 0.06f;
    private float TOUCH_SCALE = 0.06f;
    MoveGestureDetector mMoveDetector;
    RawImageDrawer mImageDrawer;
    RotateGestureDetector mRotateGestureDetector;
    GestureDetector mFlingDetector;
    GyroscopeHandler gyroscopeHandler;
    GyroscopeHandler gyroscopeHandler2;
    GyroscopeHandlerOld gyroscopeHandlerOld;
    private float mDefaultModelScale = 1.0f;
    private PanoramaRenderer mPanoramaRenderer;
    private float mScaleFactor = 1.0f;
    int beginEvents = 0;
    private ScaleGestureDetector mScaleGestureDetector;
    private boolean isGyroAvailable;
    private boolean useVerticalGyro;
    private int currentGyroHandler = 1;
    private float[] currentRotationMatrix;
    private float[] currentRotationMatrix2;
    private float currentProgress = 0.0f;
    private int targetProgress;
    boolean autoCorrection = false;
    private Timer timer;
    private int mDeviceOrientation;

    public PanoramaGLSurfaceView(Context context) {
        super(context);
        if (this.isInEditMode()) {
            return;
        }
        this.mScaleGestureDetector = new ScaleGestureDetector(context, (ScaleGestureDetector.OnScaleGestureListener)new ScaleListener());
        this.mMoveDetector = new MoveGestureDetector(context, new MoveListener());
        this.mRotateGestureDetector = new RotateGestureDetector(context, new MyRotateGestureDetector());
        this.mScaleFactor = this.mDefaultModelScale;
        this.mImageDrawer = new RawImageDrawer(this.getResources());
        this.mPanoramaRenderer = new PanoramaRenderer(context, this.mImageDrawer, R.raw.sphere);
        this.mPanoramaRenderer.MAX_X_ROT = this.MAX_X_ROT;
        this.mPanoramaRenderer.MIN_X_ROT = this.MIN_X_ROT;
        this.mPanoramaRenderer.MAX_Y_ROT = this.MAX_Y_ROT;
        this.mPanoramaRenderer.MIN_Y_ROT = this.MIN_Y_ROT;
        this.mPanoramaRenderer.MAX_SCALE = this.MAX_SCALE;
        this.mPanoramaRenderer.MIN_SCALE = this.MIN_SCALE;
        this.mPanoramaRenderer.isGyroAvailable = this.isGyroAvailable;
        this.mPanoramaRenderer.useVerticalGyro = this.useVerticalGyro;
        this.mPanoramaRenderer.setModelScale(this.mDefaultModelScale);
        this.setEGLContextClientVersion(2);
        super.setEGLConfigChooser(8, 8, 8, 8, 16, 0);
        this.setRenderer(this.mPanoramaRenderer);
    }

    public PanoramaGLSurfaceView(Context context, AttributeSet attrs) {
        super(context, attrs);
        if (this.isInEditMode()) {
            return;
        }
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.PanoramaGLSurfaceView, 0, 0);
        int imageResource = a.getResourceId(R.styleable.PanoramaGLSurfaceView_img, -1);
        boolean lockVertical = a.getBoolean(R.styleable.PanoramaGLSurfaceView_lockVertical, false);
        boolean useGyro = a.getBoolean(R.styleable.PanoramaGLSurfaceView_useGyro, true);
        float maxX = a.getFloat(R.styleable.PanoramaGLSurfaceView_maxX, Float.NaN);
        float minX = a.getFloat(R.styleable.PanoramaGLSurfaceView_minX, Float.NaN);
        float maxY = a.getFloat(R.styleable.PanoramaGLSurfaceView_maxY, Float.NaN);
        float minY = a.getFloat(R.styleable.PanoramaGLSurfaceView_minY, Float.NaN);
        float maxScale = a.getFloat(R.styleable.PanoramaGLSurfaceView_maxScale, Float.NaN);
        float minScale = a.getFloat(R.styleable.PanoramaGLSurfaceView_minScale, Float.NaN);
        int mappingType = a.getInt(R.styleable.PanoramaGLSurfaceView_mappingType, 0);
        if (!Float.isNaN(maxScale) && !Float.isNaN(minScale)) {
            this.MAX_SCALE = maxScale;
            this.MIN_SCALE = minScale;
        }
        if (!(!useGyro || lockVertical || Float.isNaN(maxX) && Float.isNaN(minX) && Float.isNaN(maxY) && Float.isNaN(minY))) {
            throw new RuntimeException("cant set max min if it is using gyro without lock vertical");
        }
        this.isGyroAvailable = useGyro;
        this.useVerticalGyro = lockVertical;
        if (Float.isNaN(maxX) != Float.isNaN(minX)) {
            throw new RuntimeException("You have to specify both maxX and minX");
        }
        if (Float.isNaN(maxY) != Float.isNaN(minY)) {
            throw new RuntimeException("You have to specify both maxY and minY");
        }
        this.MAX_X_ROT = maxX;
        this.MIN_X_ROT = minX;
        this.MAX_Y_ROT = maxY;
        this.MIN_Y_ROT = minY;
        a.recycle();
        this.mScaleGestureDetector = new ScaleGestureDetector(context, (ScaleGestureDetector.OnScaleGestureListener)new ScaleListener());
        this.mMoveDetector = new MoveGestureDetector(context, new MoveListener());
        this.mRotateGestureDetector = new RotateGestureDetector(context, new MyRotateGestureDetector());
        this.mFlingDetector = new GestureDetector(this.getContext(), new GestureDetector.OnGestureListener(){

            public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
                ((PanoramaGLSurfaceView)PanoramaGLSurfaceView.this).mPanoramaRenderer.speedX = -PanoramaGLSurfaceView.this.TOUCH_SCALE * velocityX;
                ((PanoramaGLSurfaceView)PanoramaGLSurfaceView.this).mPanoramaRenderer.speedY = -PanoramaGLSurfaceView.this.TOUCH_SCALE * velocityY;
                return false;
            }

            public void onLongPress(MotionEvent e) {
            }

            public boolean onDown(MotionEvent motionEvent) {
                return false;
            }

            public void onShowPress(MotionEvent motionEvent) {
            }

            public boolean onSingleTapUp(MotionEvent event) {
                return false;
            }

            public boolean onScroll(MotionEvent motionEvent, MotionEvent motionEvent1, float v, float v1) {
                return false;
            }
        });
        this.mScaleFactor = this.mDefaultModelScale;
        this.mImageDrawer = new RawImageDrawer(this.getResources());
        int modelResource = mappingType == 0 ? R.raw.sphere : -1;
        this.mPanoramaRenderer = new PanoramaRenderer(context, this.mImageDrawer, modelResource);
        this.mPanoramaRenderer.setModelScale(this.mDefaultModelScale);
        this.setEGLContextClientVersion(2);
        super.setEGLConfigChooser(8, 8, 8, 8, 16, 0);
        this.setRenderer(this.mPanoramaRenderer);
        if (imageResource != -1) {
            this.setTexDrawableResourceID(imageResource);
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        boolean retVal = this.mRotateGestureDetector.onTouchEvent(event);
        retVal = this.mScaleGestureDetector.onTouchEvent(event) || retVal;
        retVal = this.mMoveDetector.onTouchEvent(event) || retVal;
        retVal = this.mFlingDetector.onTouchEvent(event) || retVal;
        return retVal || super.onTouchEvent(event);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.isInEditMode()) {
            return;
        }
        OrientationEventListener orientationEventListener = new OrientationEventListener(this.getContext(), 3){

            public void onOrientationChanged(int orientation) {
                PanoramaGLSurfaceView.this.mDeviceOrientation = orientation;
            }
        };
    }

    public void onPause() {
        this.gyroscopeHandler.stop();
        this.gyroscopeHandler2.stop();
        this.gyroscopeHandlerOld.stop();
        if (this.autoCorrection) {
            this.timer.cancel();
        }
    }

    public void onResume() {
        if (this.isInEditMode()) {
            return;
        }
        this.gyroscopeHandler = new GyroscopeHandler();
        this.gyroscopeHandler2 = new GyroscopeHandler();
        this.gyroscopeHandlerOld = new GyroscopeHandlerOld();
        this.currentGyroHandler = 2;
        this.gyroscopeHandler.start(this.getContext(), new GyroscopeHandler.OnGyroscopeChanged(){

            @Override
            public void onGyroscopeChange(double x, double y, double z) {
            }

            @Override
            public void onGyroscopeChanged2(float[] currentRotationMatrix) {
                if (!PanoramaGLSurfaceView.this.useVerticalGyro && PanoramaGLSurfaceView.this.isGyroAvailable) {
                    PanoramaGLSurfaceView.access$802(PanoramaGLSurfaceView.this, currentRotationMatrix);
                    if (PanoramaGLSurfaceView.this.currentGyroHandler == 2) {
                        PanoramaGLSurfaceView.this.currentProgress = PanoramaGLSurfaceView.this.lerp(0.01f, PanoramaGLSurfaceView.this.currentProgress, PanoramaGLSurfaceView.this.targetProgress);
                        if ((double)PanoramaGLSurfaceView.this.currentProgress < 0.01 && PanoramaGLSurfaceView.this.targetProgress == 0) {
                            PanoramaGLSurfaceView.this.currentProgress = 0.0f;
                        }
                        if ((double)PanoramaGLSurfaceView.this.currentProgress > 0.99 && PanoramaGLSurfaceView.this.targetProgress == 1) {
                            PanoramaGLSurfaceView.this.currentProgress = 1.0f;
                        }
                        MyLog.d("gyro1", "onGyroscopeChanged2: currentProgress = " + PanoramaGLSurfaceView.this.currentProgress);
                    } else {
                        if (PanoramaGLSurfaceView.this.currentRotationMatrix == null || PanoramaGLSurfaceView.this.currentRotationMatrix2 == null) {
                            return;
                        }
                        float[] rotationMatrix = PanoramaGLSurfaceView.this.getCurrentRotationMatrix(PanoramaGLSurfaceView.this.currentRotationMatrix, PanoramaGLSurfaceView.this.currentRotationMatrix2, PanoramaGLSurfaceView.this.currentProgress);
                        PanoramaGLSurfaceView.this.setModelRotationMatrix(rotationMatrix);
                    }
                }
            }

            @Override
            public void onGyroscopeNotAvailable() {
                PanoramaGLSurfaceView.this.isGyroAvailable = false;
            }
        });
        this.gyroscopeHandler2.start(this.getContext(), new GyroscopeHandler.OnGyroscopeChanged(){

            @Override
            public void onGyroscopeChange(double x, double y, double z) {
            }

            @Override
            public void onGyroscopeChanged2(float[] currentRotationMatrix) {
                if (!PanoramaGLSurfaceView.this.useVerticalGyro && PanoramaGLSurfaceView.this.isGyroAvailable) {
                    PanoramaGLSurfaceView.access$1202(PanoramaGLSurfaceView.this, currentRotationMatrix);
                    if (PanoramaGLSurfaceView.this.currentGyroHandler == 1) {
                        PanoramaGLSurfaceView.this.currentProgress = PanoramaGLSurfaceView.this.lerp(0.01f, PanoramaGLSurfaceView.this.currentProgress, PanoramaGLSurfaceView.this.targetProgress);
                        MyLog.d("gyro2", "onGyroscopeChanged2: currentProgress = " + PanoramaGLSurfaceView.this.currentProgress);
                        if ((double)PanoramaGLSurfaceView.this.currentProgress < 0.01 && PanoramaGLSurfaceView.this.targetProgress == 0) {
                            PanoramaGLSurfaceView.this.currentProgress = 0.0f;
                        }
                        if ((double)PanoramaGLSurfaceView.this.currentProgress > 0.99 && PanoramaGLSurfaceView.this.targetProgress == 1) {
                            PanoramaGLSurfaceView.this.currentProgress = 1.0f;
                        }
                    } else {
                        if (PanoramaGLSurfaceView.this.currentRotationMatrix == null || PanoramaGLSurfaceView.this.currentRotationMatrix2 == null) {
                            return;
                        }
                        float[] rotationMatrix = PanoramaGLSurfaceView.this.getCurrentRotationMatrix(PanoramaGLSurfaceView.this.currentRotationMatrix, PanoramaGLSurfaceView.this.currentRotationMatrix2, PanoramaGLSurfaceView.this.currentProgress);
                        PanoramaGLSurfaceView.this.setModelRotationMatrix(rotationMatrix);
                    }
                }
            }

            @Override
            public void onGyroscopeNotAvailable() {
                PanoramaGLSurfaceView.this.isGyroAvailable = false;
            }
        });
        this.gyroscopeHandlerOld.start(this.getContext(), new GyroscopeHandlerOld.OnGyroscopeChanged(){

            @Override
            public void onGyroscopeChange(double x, double y, double z) {
                if (PanoramaGLSurfaceView.this.useVerticalGyro && PanoramaGLSurfaceView.this.isGyroAvailable) {
                    if (PanoramaGLSurfaceView.this.getResources().getConfiguration().orientation == 2) {
                        int orientation = 90 * Math.round(PanoramaGLSurfaceView.this.mDeviceOrientation / 90);
                        if (orientation == 90 || orientation == 0) {
                            PanoramaGLSurfaceView.this.mPanoramaRenderer.setModelRotationX((float)(-(z - 90.0)));
                            PanoramaGLSurfaceView.this.mPanoramaRenderer.setModelRotationY((float)(-(x + 90.0)));
                        } else {
                            PanoramaGLSurfaceView.this.mPanoramaRenderer.setModelRotationX((float)(-(z + 90.0)));
                            PanoramaGLSurfaceView.this.mPanoramaRenderer.setModelRotationY((float)(-x));
                        }
                    } else if (PanoramaGLSurfaceView.this.getResources().getConfiguration().orientation == 1) {
                        PanoramaGLSurfaceView.this.mPanoramaRenderer.setModelRotationX((float)y);
                        PanoramaGLSurfaceView.this.mPanoramaRenderer.setModelRotationY((float)(-x));
                    }
                }
            }

            @Override
            public void onGyroscopeNotAvailable() {
            }
        });
        if (this.autoCorrection) {
            this.timer = new Timer();
            this.timer.scheduleAtFixedRate(new TimerTask(){

                @Override
                public void run() {
                    PanoramaGLSurfaceView.this.reset();
                }
            }, 0L, 10000L);
        }
    }

    private void setModelRotationMatrix(float[] rotationMatrix) {
        this.mPanoramaRenderer.setModelRotationMatrix(rotationMatrix);
    }

    public void setOnDrawListener(OnDrawListener onDrawListener) {
        this.mPanoramaRenderer.setOnDrawListener(onDrawListener);
    }

    float[] getCurrentRotationMatrix(float[] matrix1, float[] matrix2, float progress) {
        float[] matrixResult = new float[matrix1.length];
        for (int i = 0; i < matrix1.length; ++i) {
            matrixResult[i] = this.lerp(progress, matrix1[i], matrix2[i]);
        }
        return matrixResult;
    }

    float lerp(float t, float a, float b) {
        return (1.0f - t) * a + t * b;
    }

    public void reset() {
        if (this.gyroscopeHandler == null || this.gyroscopeHandler2 == null) {
            return;
        }
        if (this.currentGyroHandler == 1) {
            this.gyroscopeHandler.reset();
            this.gyroscopeHandler.restart();
            this.currentGyroHandler = 2;
            this.targetProgress = 0;
        } else {
            this.gyroscopeHandler2.reset();
            this.gyroscopeHandler2.restart();
            this.currentGyroHandler = 1;
            this.targetProgress = 1;
        }
    }

    public void setPanoramaResourceId(int tex_resourceID) {
        this.mPanoramaRenderer.setTex_resourceID(tex_resourceID);
    }

    public void setTexDrawableResourceID(int tex_resourceID) {
        this.mPanoramaRenderer.setTex_resourceID(tex_resourceID);
    }

    public void setPanoramaBitmap(Bitmap bitmap) {
        this.mPanoramaRenderer.setTextureBitmap(bitmap);
    }

    public float[] getMVPMatrix() {
        return this.mPanoramaRenderer.getMVPMatrix();
    }

    public PointF unProject(double latitude, double longitude) {
        float[] posNew = MatrixCalculator.calculateOnScreenPosNormalized(this.getMVPMatrix(), latitude, longitude);
        int w = this.getWidth();
        int h = this.getHeight();
        int x = (int)((float)w * (1.0f + posNew[0]) / 2.0f);
        int y = (int)((float)h * (1.0f + posNew[1]) / 2.0f);
        y = h - y;
        return new PointF((float)x, (float)y);
    }

    static /* synthetic */ float[] access$802(PanoramaGLSurfaceView x0, float[] x1) {
        x0.currentRotationMatrix = x1;
        return x1;
    }

    static /* synthetic */ float[] access$1202(PanoramaGLSurfaceView x0, float[] x1) {
        x0.currentRotationMatrix2 = x1;
        return x1;
    }

    private class MoveListener
    implements MoveGestureDetector.OnMoveGestureListener {
        private MoveListener() {
        }

        @Override
        public boolean onMove(MoveGestureDetector detector) {
            if (PanoramaGLSurfaceView.this.beginEvents != 0) {
                return true;
            }
            float distanceX = detector.getFocusDelta().x;
            float distanceY = detector.getFocusDelta().y;
            PanoramaGLSurfaceView.this.mPanoramaRenderer.rotate(-distanceX * PanoramaGLSurfaceView.this.TOUCH_SCALE, -distanceY * PanoramaGLSurfaceView.this.TOUCH_SCALE);
            return true;
        }

        @Override
        public boolean onMoveBegin(MoveGestureDetector detector) {
            return true;
        }

        @Override
        public void onMoveEnd(MoveGestureDetector detector) {
        }
    }

    private class MyRotateGestureDetector
    implements RotateGestureDetector.OnRotateGestureListener {
        private MyRotateGestureDetector() {
        }

        @Override
        public boolean onRotate(RotateGestureDetector detector) {
            PanoramaGLSurfaceView.this.mPanoramaRenderer.rotateZ(detector.getRotationDegreesDelta());
            return true;
        }

        @Override
        public boolean onRotateBegin(RotateGestureDetector detector) {
            ++PanoramaGLSurfaceView.this.beginEvents;
            return true;
        }

        @Override
        public void onRotateEnd(RotateGestureDetector detector) {
            --PanoramaGLSurfaceView.this.beginEvents;
        }
    }

    private class ScaleListener
    extends ScaleGestureDetector.SimpleOnScaleGestureListener {
        private ScaleListener() {
        }

        public boolean onScale(ScaleGestureDetector detector) {
            PanoramaGLSurfaceView.this.mScaleFactor = PanoramaGLSurfaceView.this.mPanoramaRenderer.getModelScale() / detector.getScaleFactor();
            PanoramaGLSurfaceView.this.mScaleFactor = Math.max(0.3f, Math.min(PanoramaGLSurfaceView.this.mScaleFactor, 1.5f));
            PanoramaGLSurfaceView.this.TOUCH_SCALE = PanoramaGLSurfaceView.this.DEFAULT_TOUCH_SCALE * PanoramaGLSurfaceView.this.mScaleFactor;
            PanoramaGLSurfaceView.this.mPanoramaRenderer.setModelScale(PanoramaGLSurfaceView.this.mScaleFactor);
            PanoramaGLSurfaceView.this.invalidate();
            return true;
        }

        public boolean onScaleBegin(ScaleGestureDetector detector) {
            ++PanoramaGLSurfaceView.this.beginEvents;
            return true;
        }

        public void onScaleEnd(ScaleGestureDetector detector) {
            --PanoramaGLSurfaceView.this.beginEvents;
            super.onScaleEnd(detector);
        }
    }
}

