/*
 * Decompiled with CFR 0.152.
 */
package pl.rjuszczyk.panorama.gyroscope;

import android.annotation.TargetApi;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.util.Log;
import java.text.DecimalFormat;
import pl.rjuszczyk.panorama.gyroscope.FusedGyroscopeSensor;
import pl.rjuszczyk.panorama.gyroscope.FusedGyroscopeSensorListener;
import pl.rjuszczyk.panorama.gyroscope.GyroscopeHandler;
import pl.rjuszczyk.panorama.gyroscope.MeanFilter;
import pl.rjuszczyk.panorama.gyroscope.Utils;

public class GyroscopeHandlerOld
implements SensorEventListener,
FusedGyroscopeSensorListener {
    public static final float EPSILON = 1.0E-9f;
    private static final String tag = GyroscopeHandler.class.getSimpleName();
    private static final float NS2S = 1.0E-9f;
    private static final int MEAN_FILTER_WINDOW = 10;
    private static final int MIN_SAMPLE_COUNT = 30;
    public Context mContext;
    OnGyroscopeChanged mOnGyroscopeChanged;
    private boolean hasInitialOrientation = false;
    private boolean stateInitializedCalibrated = false;
    private boolean stateInitializedRaw = false;
    private boolean useFusedEstimation = false;
    private boolean useRadianUnits = false;
    private DecimalFormat df;
    private float[] currentRotationMatrixCalibrated;
    private float[] deltaRotationMatrixCalibrated;
    private float[] deltaRotationVectorCalibrated;
    private float[] gyroscopeOrientationCalibrated;
    private float[] currentRotationMatrixRaw;
    private float[] deltaRotationMatrixRaw;
    private float[] deltaRotationVectorRaw;
    private float[] gyroscopeOrientationRaw;
    private float[] initialRotationMatrix;
    private float[] acceleration;
    private float[] magnetic;
    private FusedGyroscopeSensor fusedGyroscopeSensor;
    private int accelerationSampleCount = 0;
    private int magneticSampleCount = 0;
    private long timestampOldCalibrated = 0L;
    private long timestampOldRaw = 0L;
    private MeanFilter accelerationFilter;
    private MeanFilter magneticFilter;
    private SensorManager sensorManager;

    public void start(Context context, OnGyroscopeChanged onGyroscopeChanged) {
        this.mOnGyroscopeChanged = onGyroscopeChanged;
        this.mContext = context;
        this.initUI();
        this.initMaths();
        this.initSensors();
        this.initFilters();
        this.restart();
    }

    public void stop() {
        this.reset();
        this.mContext = null;
    }

    public void onSensorChanged(SensorEvent event) {
        FusedGyroscopeSensor.changeArray(this.mContext, event.values);
        if (event.sensor.getType() == 1) {
            this.onAccelerationSensorChanged(event.values, event.timestamp);
        }
        if (event.sensor.getType() == 2) {
            this.onMagneticSensorChanged(event.values, event.timestamp);
        }
        if (event.sensor.getType() == 4) {
            this.onGyroscopeSensorChanged(event.values, event.timestamp);
        }
        if (event.sensor.getType() == 16) {
            this.onGyroscopeSensorUncalibratedChanged(event.values, event.timestamp);
        }
    }

    @Override
    public void onAngularVelocitySensorChanged(float[] angularVelocity, long timeStamp) {
    }

    public void onAccelerationSensorChanged(float[] acceleration, long timeStamp) {
        System.arraycopy(acceleration, 0, this.acceleration, 0, acceleration.length);
        this.acceleration = this.accelerationFilter.filterFloat(this.acceleration);
        ++this.accelerationSampleCount;
        if (this.accelerationSampleCount > 30 && this.magneticSampleCount > 30 && !this.hasInitialOrientation) {
            this.calculateOrientation();
        }
    }

    public void onGyroscopeSensorChanged(float[] gyroscope, long timestamp) {
        if (!this.hasInitialOrientation) {
            return;
        }
        if (!this.stateInitializedCalibrated) {
            this.currentRotationMatrixCalibrated = this.matrixMultiplication(this.currentRotationMatrixCalibrated, this.initialRotationMatrix);
            this.stateInitializedCalibrated = true;
        }
        if (this.timestampOldCalibrated != 0L && this.stateInitializedCalibrated) {
            float dT = (float)(timestamp - this.timestampOldCalibrated) * 1.0E-9f;
            float axisX = gyroscope[0];
            float axisY = gyroscope[1];
            float axisZ = gyroscope[2];
            float omegaMagnitude = (float)Math.sqrt(axisX * axisX + axisY * axisY + axisZ * axisZ);
            if (omegaMagnitude > 1.0E-9f) {
                axisX /= omegaMagnitude;
                axisY /= omegaMagnitude;
                axisZ /= omegaMagnitude;
            }
            float thetaOverTwo = omegaMagnitude * dT / 2.0f;
            float sinThetaOverTwo = (float)Math.sin(thetaOverTwo);
            float cosThetaOverTwo = (float)Math.cos(thetaOverTwo);
            this.deltaRotationVectorCalibrated[0] = sinThetaOverTwo * axisX;
            this.deltaRotationVectorCalibrated[1] = sinThetaOverTwo * axisY;
            this.deltaRotationVectorCalibrated[2] = sinThetaOverTwo * axisZ;
            this.deltaRotationVectorCalibrated[3] = cosThetaOverTwo;
            SensorManager.getRotationMatrixFromVector((float[])this.deltaRotationMatrixCalibrated, (float[])this.deltaRotationVectorCalibrated);
            this.currentRotationMatrixCalibrated = this.matrixMultiplication(this.currentRotationMatrixCalibrated, this.deltaRotationMatrixCalibrated);
            SensorManager.getOrientation((float[])this.currentRotationMatrixCalibrated, (float[])this.gyroscopeOrientationCalibrated);
        }
        this.timestampOldCalibrated = timestamp;
        if (this.useRadianUnits) {
            Log.d((String)"sensor", (String)("x= " + this.df.format(this.gyroscopeOrientationCalibrated[0]) + "\ty= " + this.df.format(this.gyroscopeOrientationCalibrated[1]) + "\tz= " + this.df.format(this.gyroscopeOrientationCalibrated[2])));
        } else if (this.mOnGyroscopeChanged != null) {
            this.mOnGyroscopeChanged.onGyroscopeChange(Math.toDegrees(this.gyroscopeOrientationCalibrated[0]), Math.toDegrees(this.gyroscopeOrientationCalibrated[1]), Math.toDegrees(this.gyroscopeOrientationCalibrated[2]));
        }
    }

    public void onGyroscopeSensorUncalibratedChanged(float[] gyroscope, long timestamp) {
        if (!this.hasInitialOrientation) {
            return;
        }
        if (!this.stateInitializedRaw) {
            this.currentRotationMatrixRaw = this.matrixMultiplication(this.currentRotationMatrixRaw, this.initialRotationMatrix);
            this.stateInitializedRaw = true;
        }
        if (this.timestampOldRaw != 0L && this.stateInitializedRaw) {
            float dT = (float)(timestamp - this.timestampOldRaw) * 1.0E-9f;
            float axisX = gyroscope[0];
            float axisY = gyroscope[1];
            float axisZ = gyroscope[2];
            float omegaMagnitude = (float)Math.sqrt(axisX * axisX + axisY * axisY + axisZ * axisZ);
            if (omegaMagnitude > 1.0E-9f) {
                axisX /= omegaMagnitude;
                axisY /= omegaMagnitude;
                axisZ /= omegaMagnitude;
            }
            float thetaOverTwo = omegaMagnitude * dT / 2.0f;
            float sinThetaOverTwo = (float)Math.sin(thetaOverTwo);
            float cosThetaOverTwo = (float)Math.cos(thetaOverTwo);
            this.deltaRotationVectorRaw[0] = sinThetaOverTwo * axisX;
            this.deltaRotationVectorRaw[1] = sinThetaOverTwo * axisY;
            this.deltaRotationVectorRaw[2] = sinThetaOverTwo * axisZ;
            this.deltaRotationVectorRaw[3] = cosThetaOverTwo;
            SensorManager.getRotationMatrixFromVector((float[])this.deltaRotationMatrixRaw, (float[])this.deltaRotationVectorRaw);
            this.currentRotationMatrixRaw = this.matrixMultiplication(this.currentRotationMatrixRaw, this.deltaRotationMatrixRaw);
            SensorManager.getOrientation((float[])this.currentRotationMatrixRaw, (float[])this.gyroscopeOrientationRaw);
        }
        this.timestampOldRaw = timestamp;
    }

    public void onMagneticSensorChanged(float[] magnetic, long timeStamp) {
        System.arraycopy(magnetic, 0, this.magnetic, 0, magnetic.length);
        this.magnetic = this.magneticFilter.filterFloat(this.magnetic);
        ++this.magneticSampleCount;
    }

    private void calculateOrientation() {
        this.hasInitialOrientation = SensorManager.getRotationMatrix((float[])this.initialRotationMatrix, null, (float[])this.acceleration, (float[])this.magnetic);
        if (this.hasInitialOrientation) {
            this.sensorManager.unregisterListener((SensorEventListener)this, this.sensorManager.getDefaultSensor(1));
            this.sensorManager.unregisterListener((SensorEventListener)this, this.sensorManager.getDefaultSensor(2));
        }
    }

    private void initFilters() {
        this.accelerationFilter = new MeanFilter();
        this.accelerationFilter.setWindowSize(10);
        this.magneticFilter = new MeanFilter();
        this.magneticFilter.setWindowSize(10);
    }

    private void initMaths() {
        this.acceleration = new float[3];
        this.magnetic = new float[3];
        this.initialRotationMatrix = new float[9];
        this.deltaRotationVectorCalibrated = new float[4];
        this.deltaRotationMatrixCalibrated = new float[9];
        this.currentRotationMatrixCalibrated = new float[9];
        this.gyroscopeOrientationCalibrated = new float[3];
        this.currentRotationMatrixCalibrated[0] = 1.0f;
        this.currentRotationMatrixCalibrated[4] = 1.0f;
        this.currentRotationMatrixCalibrated[8] = 1.0f;
        this.deltaRotationVectorRaw = new float[4];
        this.deltaRotationMatrixRaw = new float[9];
        this.currentRotationMatrixRaw = new float[9];
        this.gyroscopeOrientationRaw = new float[3];
        this.currentRotationMatrixRaw[0] = 1.0f;
        this.currentRotationMatrixRaw[4] = 1.0f;
        this.currentRotationMatrixRaw[8] = 1.0f;
    }

    private void initSensors() {
        this.sensorManager = (SensorManager)this.mContext.getSystemService("sensor");
        this.fusedGyroscopeSensor = new FusedGyroscopeSensor(this.mContext);
    }

    private void initUI() {
        this.df = new DecimalFormat("#.##");
    }

    private float[] matrixMultiplication(float[] a, float[] b) {
        float[] result = new float[]{a[0] * b[0] + a[1] * b[3] + a[2] * b[6], a[0] * b[1] + a[1] * b[4] + a[2] * b[7], a[0] * b[2] + a[1] * b[5] + a[2] * b[8], a[3] * b[0] + a[4] * b[3] + a[5] * b[6], a[3] * b[1] + a[4] * b[4] + a[5] * b[7], a[3] * b[2] + a[4] * b[5] + a[5] * b[8], a[6] * b[0] + a[7] * b[3] + a[8] * b[6], a[6] * b[1] + a[7] * b[4] + a[8] * b[7], a[6] * b[2] + a[7] * b[5] + a[8] * b[8]};
        return result;
    }

    @TargetApi(value=18)
    private void restart() {
        boolean enabled;
        this.sensorManager.registerListener((SensorEventListener)this, this.sensorManager.getDefaultSensor(1), 0);
        this.sensorManager.registerListener((SensorEventListener)this, this.sensorManager.getDefaultSensor(2), 0);
        if (!this.useFusedEstimation && !(enabled = this.sensorManager.registerListener((SensorEventListener)this, this.sensorManager.getDefaultSensor(4), 0))) {
            this.mOnGyroscopeChanged.onGyroscopeNotAvailable();
        }
        if (Utils.hasKitKat()) {
            this.sensorManager.registerListener((SensorEventListener)this, this.sensorManager.getDefaultSensor(16), 0);
        }
        if (this.useFusedEstimation) {
            boolean hasGravity = this.sensorManager.registerListener((SensorEventListener)this.fusedGyroscopeSensor, this.sensorManager.getDefaultSensor(9), 0);
            if (!hasGravity) {
                this.sensorManager.registerListener((SensorEventListener)this.fusedGyroscopeSensor, this.sensorManager.getDefaultSensor(1), 0);
            }
            this.sensorManager.registerListener((SensorEventListener)this.fusedGyroscopeSensor, this.sensorManager.getDefaultSensor(2), 0);
            boolean enabled2 = this.sensorManager.registerListener((SensorEventListener)this.fusedGyroscopeSensor, this.sensorManager.getDefaultSensor(4), 0);
            if (!enabled2) {
                this.mOnGyroscopeChanged.onGyroscopeNotAvailable();
            }
            this.fusedGyroscopeSensor.registerObserver(this);
        }
    }

    @TargetApi(value=18)
    private void reset() {
        this.sensorManager.unregisterListener((SensorEventListener)this, this.sensorManager.getDefaultSensor(1));
        this.sensorManager.unregisterListener((SensorEventListener)this, this.sensorManager.getDefaultSensor(2));
        if (!this.useFusedEstimation) {
            this.sensorManager.unregisterListener((SensorEventListener)this, this.sensorManager.getDefaultSensor(4));
        }
        if (Utils.hasKitKat()) {
            this.sensorManager.unregisterListener((SensorEventListener)this, this.sensorManager.getDefaultSensor(16));
        }
        if (this.useFusedEstimation) {
            this.sensorManager.unregisterListener((SensorEventListener)this.fusedGyroscopeSensor, this.sensorManager.getDefaultSensor(9));
            this.sensorManager.unregisterListener((SensorEventListener)this.fusedGyroscopeSensor, this.sensorManager.getDefaultSensor(1));
            this.sensorManager.unregisterListener((SensorEventListener)this.fusedGyroscopeSensor, this.sensorManager.getDefaultSensor(2));
            this.sensorManager.unregisterListener((SensorEventListener)this.fusedGyroscopeSensor, this.sensorManager.getDefaultSensor(4));
            this.fusedGyroscopeSensor.removeObserver(this);
        }
        this.initMaths();
        this.accelerationSampleCount = 0;
        this.magneticSampleCount = 0;
        this.hasInitialOrientation = false;
        this.stateInitializedCalibrated = false;
        this.stateInitializedRaw = false;
    }

    private void showGyroscopeNotAvailableAlert() {
        AlertDialog.Builder alertDialogBuilder = new AlertDialog.Builder(this.mContext);
        alertDialogBuilder.setTitle((CharSequence)"Gyroscope Not Available");
        alertDialogBuilder.setMessage((CharSequence)"Your device is not equipped with a gyroscope or it is not responding...").setCancelable(false).setNegativeButton((CharSequence)"I'll look around...", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int id) {
                dialog.cancel();
            }
        });
        AlertDialog alertDialog = alertDialogBuilder.create();
        alertDialog.show();
    }

    public void onAccuracyChanged(Sensor sensor, int accuracy) {
    }

    public static interface OnGyroscopeChanged {
        public void onGyroscopeChange(double var1, double var3, double var5);

        public void onGyroscopeNotAvailable();
    }
}

