/*
 * Decompiled with CFR 0.152.
 */
package pl.rjuszczyk.panorama.gyroscope;

import android.annotation.TargetApi;
import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import java.util.ArrayList;
import pl.rjuszczyk.panorama.gyroscope.FusedGyroscopeSensorListener;
import pl.rjuszczyk.panorama.gyroscope.MeanFilter;

@TargetApi(value=9)
public class FusedGyroscopeSensor
implements SensorEventListener {
    public static final float FILTER_COEFFICIENT = 0.5f;
    public static final float EPSILON = 1.0E-9f;
    private static final String tag = FusedGyroscopeSensor.class.getSimpleName();
    private static final float NS2S = 1.0E-9f;
    Context mContext;
    private ArrayList<FusedGyroscopeSensorListener> observersAngularVelocity;
    private boolean hasOrientation = false;
    private float dT = 0.0f;
    private float omegaMagnitude = 0.0f;
    private float thetaOverTwo = 0.0f;
    private float sinThetaOverTwo = 0.0f;
    private float cosThetaOverTwo = 0.0f;
    private float[] gravity = new float[]{0.0f, 0.0f, 0.0f};
    private float[] gyroscope = new float[3];
    private float[] gyroMatrix = new float[9];
    private float[] gyroOrientation = new float[3];
    private float[] magnetic = new float[3];
    private float[] orientation = new float[3];
    private float[] fusedOrientation = new float[3];
    private float[] rotationMatrix = new float[9];
    private float[] absoluteFrameOrientation = new float[3];
    private float[] deltaVector = new float[4];
    private float[] deltaMatrix = new float[9];
    private long timeStamp;
    private boolean initState = false;
    private MeanFilter meanFilterAcceleration;
    private MeanFilter meanFilterMagnetic;

    public FusedGyroscopeSensor(Context context) {
        this.mContext = context;
        this.observersAngularVelocity = new ArrayList();
        this.meanFilterAcceleration = new MeanFilter();
        this.meanFilterAcceleration.setWindowSize(10);
        this.meanFilterMagnetic = new MeanFilter();
        this.meanFilterMagnetic.setWindowSize(10);
        this.gyroOrientation[0] = 0.0f;
        this.gyroOrientation[1] = 0.0f;
        this.gyroOrientation[2] = 0.0f;
        this.gyroMatrix[0] = 1.0f;
        this.gyroMatrix[1] = 0.0f;
        this.gyroMatrix[2] = 0.0f;
        this.gyroMatrix[3] = 0.0f;
        this.gyroMatrix[4] = 1.0f;
        this.gyroMatrix[5] = 0.0f;
        this.gyroMatrix[6] = 0.0f;
        this.gyroMatrix[7] = 0.0f;
        this.gyroMatrix[8] = 1.0f;
    }

    public static void changeArray(Context context, float[] array) {
        if (context == null || context.getResources().getConfiguration().orientation == 2) {
            return;
        }
        float g0 = array[0];
        float g1 = array[1];
        float g2 = array[2];
        array[0] = g1;
        array[1] = g2;
        array[2] = g0;
    }

    public void onSensorChanged(SensorEvent event) {
        FusedGyroscopeSensor.changeArray(this.mContext, event.values);
        if (event.sensor.getType() == 1) {
            this.onAccelerationSensorChanged(event.values, event.timestamp);
        }
        if (event.sensor.getType() == 9) {
            this.onGravitySensorChanged(event.values, event.timestamp);
        }
        if (event.sensor.getType() == 2) {
            this.onMagneticSensorChanged(event.values, event.timestamp);
        }
        if (event.sensor.getType() == 4) {
            this.onGyroscopeSensorChanged(event.values, event.timestamp);
        }
    }

    public void notifyObservers() {
        System.arraycopy(this.gyroOrientation, 0, this.absoluteFrameOrientation, 0, 3);
        for (FusedGyroscopeSensorListener g : this.observersAngularVelocity) {
            g.onAngularVelocitySensorChanged(this.absoluteFrameOrientation, this.timeStamp);
        }
    }

    public void registerObserver(FusedGyroscopeSensorListener g) {
        this.observersAngularVelocity.add(g);
    }

    public void removeObserver(FusedGyroscopeSensorListener g) {
        int i = this.observersAngularVelocity.indexOf(g);
        if (i >= 0) {
            this.observersAngularVelocity.remove(i);
        }
    }

    private void calculateOrientation() {
        if (SensorManager.getRotationMatrix((float[])this.rotationMatrix, null, (float[])this.gravity, (float[])this.magnetic)) {
            SensorManager.getOrientation((float[])this.rotationMatrix, (float[])this.orientation);
            this.hasOrientation = true;
        }
    }

    private float[] getRotationMatrixFromOrientation(float[] orientation) {
        float[] xM = new float[9];
        float[] yM = new float[9];
        float[] zM = new float[9];
        float sinX = (float)Math.sin(orientation[1]);
        float cosX = (float)Math.cos(orientation[1]);
        float sinY = (float)Math.sin(orientation[2]);
        float cosY = (float)Math.cos(orientation[2]);
        float sinZ = (float)Math.sin(orientation[0]);
        float cosZ = (float)Math.cos(orientation[0]);
        xM[0] = 1.0f;
        xM[1] = 0.0f;
        xM[2] = 0.0f;
        xM[3] = 0.0f;
        xM[4] = cosX;
        xM[5] = sinX;
        xM[6] = 0.0f;
        xM[7] = -sinX;
        xM[8] = cosX;
        yM[0] = cosY;
        yM[1] = 0.0f;
        yM[2] = sinY;
        yM[3] = 0.0f;
        yM[4] = 1.0f;
        yM[5] = 0.0f;
        yM[6] = -sinY;
        yM[7] = 0.0f;
        yM[8] = cosY;
        zM[0] = cosZ;
        zM[1] = sinZ;
        zM[2] = 0.0f;
        zM[3] = -sinZ;
        zM[4] = cosZ;
        zM[5] = 0.0f;
        zM[6] = 0.0f;
        zM[7] = 0.0f;
        zM[8] = 1.0f;
        float[] resultMatrix = this.matrixMultiplication(xM, yM);
        resultMatrix = this.matrixMultiplication(zM, resultMatrix);
        return resultMatrix;
    }

    private void getRotationVectorFromGyro(float timeFactor) {
        this.omegaMagnitude = (float)Math.sqrt(Math.pow(this.gyroscope[0], 2.0) + Math.pow(this.gyroscope[1], 2.0) + Math.pow(this.gyroscope[2], 2.0));
        if (this.omegaMagnitude > 1.0E-9f) {
            this.gyroscope[0] = this.gyroscope[0] / this.omegaMagnitude;
            this.gyroscope[1] = this.gyroscope[1] / this.omegaMagnitude;
            this.gyroscope[2] = this.gyroscope[2] / this.omegaMagnitude;
        }
        this.thetaOverTwo = this.omegaMagnitude * timeFactor;
        this.sinThetaOverTwo = (float)Math.sin(this.thetaOverTwo);
        this.cosThetaOverTwo = (float)Math.cos(this.thetaOverTwo);
        this.deltaVector[0] = this.sinThetaOverTwo * this.gyroscope[0];
        this.deltaVector[1] = this.sinThetaOverTwo * this.gyroscope[1];
        this.deltaVector[2] = this.sinThetaOverTwo * this.gyroscope[2];
        this.deltaVector[3] = this.cosThetaOverTwo;
    }

    private float[] matrixMultiplication(float[] A, float[] B) {
        float[] result = new float[]{A[0] * B[0] + A[1] * B[3] + A[2] * B[6], A[0] * B[1] + A[1] * B[4] + A[2] * B[7], A[0] * B[2] + A[1] * B[5] + A[2] * B[8], A[3] * B[0] + A[4] * B[3] + A[5] * B[6], A[3] * B[1] + A[4] * B[4] + A[5] * B[7], A[3] * B[2] + A[4] * B[5] + A[5] * B[8], A[6] * B[0] + A[7] * B[3] + A[8] * B[6], A[6] * B[1] + A[7] * B[4] + A[8] * B[7], A[6] * B[2] + A[7] * B[5] + A[8] * B[8]};
        return result;
    }

    private void calculateFusedOrientation() {
        float oneMinusCoeff = 0.5f;
        if ((double)this.gyroOrientation[0] < -1.5707963267948966 && (double)this.orientation[0] > 0.0) {
            this.fusedOrientation[0] = (float)(0.5 * ((double)this.gyroOrientation[0] + Math.PI * 2) + (double)(oneMinusCoeff * this.orientation[0]));
            this.fusedOrientation[0] = (float)((double)this.fusedOrientation[0] - ((double)this.fusedOrientation[0] > Math.PI ? Math.PI * 2 : 0.0));
        } else if ((double)this.orientation[0] < -1.5707963267948966 && (double)this.gyroOrientation[0] > 0.0) {
            this.fusedOrientation[0] = (float)((double)(0.5f * this.gyroOrientation[0]) + (double)oneMinusCoeff * ((double)this.orientation[0] + Math.PI * 2));
            this.fusedOrientation[0] = (float)((double)this.fusedOrientation[0] - ((double)this.fusedOrientation[0] > Math.PI ? Math.PI * 2 : 0.0));
        } else {
            this.fusedOrientation[0] = 0.5f * this.gyroOrientation[0] + oneMinusCoeff * this.orientation[0];
        }
        if ((double)this.gyroOrientation[1] < -1.5707963267948966 && (double)this.orientation[1] > 0.0) {
            this.fusedOrientation[1] = (float)(0.5 * ((double)this.gyroOrientation[1] + Math.PI * 2) + (double)(oneMinusCoeff * this.orientation[1]));
            this.fusedOrientation[1] = (float)((double)this.fusedOrientation[1] - ((double)this.fusedOrientation[1] > Math.PI ? Math.PI * 2 : 0.0));
        } else if ((double)this.orientation[1] < -1.5707963267948966 && (double)this.gyroOrientation[1] > 0.0) {
            this.fusedOrientation[1] = (float)((double)(0.5f * this.gyroOrientation[1]) + (double)oneMinusCoeff * ((double)this.orientation[1] + Math.PI * 2));
            this.fusedOrientation[1] = (float)((double)this.fusedOrientation[1] - ((double)this.fusedOrientation[1] > Math.PI ? Math.PI * 2 : 0.0));
        } else {
            this.fusedOrientation[1] = 0.5f * this.gyroOrientation[1] + oneMinusCoeff * this.orientation[1];
        }
        if ((double)this.gyroOrientation[2] < -1.5707963267948966 && (double)this.orientation[2] > 0.0) {
            this.fusedOrientation[2] = (float)(0.5 * ((double)this.gyroOrientation[2] + Math.PI * 2) + (double)(oneMinusCoeff * this.orientation[2]));
            this.fusedOrientation[2] = (float)((double)this.fusedOrientation[2] - ((double)this.fusedOrientation[2] > Math.PI ? Math.PI * 2 : 0.0));
        } else if ((double)this.orientation[2] < -1.5707963267948966 && (double)this.gyroOrientation[2] > 0.0) {
            this.fusedOrientation[2] = (float)((double)(0.5f * this.gyroOrientation[2]) + (double)oneMinusCoeff * ((double)this.orientation[2] + Math.PI * 2));
            this.fusedOrientation[2] = (float)((double)this.fusedOrientation[2] - ((double)this.fusedOrientation[2] > Math.PI ? Math.PI * 2 : 0.0));
        } else {
            this.fusedOrientation[2] = 0.5f * this.gyroOrientation[2] + oneMinusCoeff * this.orientation[2];
        }
        this.gyroMatrix = this.getRotationMatrixFromOrientation(this.fusedOrientation);
        System.arraycopy(this.fusedOrientation, 0, this.gyroOrientation, 0, 3);
        this.notifyObservers();
    }

    public void onAccelerationSensorChanged(float[] gravity, long timeStamp) {
        System.arraycopy(gravity, 0, this.gravity, 0, gravity.length);
        this.gravity = this.meanFilterAcceleration.filterFloat(this.gravity);
        this.calculateOrientation();
    }

    public void onMagneticSensorChanged(float[] magnetic, long timeStamp) {
        System.arraycopy(magnetic, 0, this.magnetic, 0, magnetic.length);
        this.magnetic = this.meanFilterMagnetic.filterFloat(this.magnetic);
    }

    public void onGravitySensorChanged(float[] gravity, long timeStamp) {
        System.arraycopy(gravity, 0, this.gravity, 0, gravity.length);
        this.gravity = this.meanFilterAcceleration.filterFloat(this.gravity);
        this.calculateOrientation();
    }

    public void onGyroscopeSensorChanged(float[] gyroscope, long timeStamp) {
        if (!this.hasOrientation) {
            return;
        }
        if (!this.initState) {
            this.gyroMatrix = this.matrixMultiplication(this.gyroMatrix, this.rotationMatrix);
            this.initState = true;
        }
        if (this.timeStamp != 0L) {
            this.dT = (float)(timeStamp - this.timeStamp) * 1.0E-9f;
            System.arraycopy(gyroscope, 0, this.gyroscope, 0, 3);
            this.getRotationVectorFromGyro(this.dT / 2.0f);
        }
        this.timeStamp = timeStamp;
        SensorManager.getRotationMatrixFromVector((float[])this.deltaMatrix, (float[])this.deltaVector);
        this.gyroMatrix = this.matrixMultiplication(this.gyroMatrix, this.deltaMatrix);
        SensorManager.getOrientation((float[])this.gyroMatrix, (float[])this.gyroOrientation);
        this.calculateFusedOrientation();
    }

    public void onAccuracyChanged(Sensor sensor, int accuracy) {
    }
}

