/*
 * Decompiled with CFR 0.152.
 */
package junitparams.internal;

import java.lang.reflect.Field;
import junitparams.internal.InvokeParameterisedMethod;
import junitparams.internal.TestMethod;
import org.junit.internal.AssumptionViolatedException;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.model.Statement;

public class ParameterisedTestMethodRunner {
    public final TestMethod method;
    private int count;

    public ParameterisedTestMethodRunner(TestMethod testMethod) {
        this.method = testMethod;
    }

    public int nextCount() {
        return this.count++;
    }

    public int count() {
        return this.count;
    }

    Object currentParamsFromAnnotation() {
        return this.method.parametersSets()[this.nextCount()];
    }

    void runTestMethod(Statement methodInvoker, RunNotifier notifier) {
        Description methodDescription = this.method.describe();
        Description methodWithParams = this.findChildForParams(methodInvoker, methodDescription);
        notifier.fireTestStarted(methodWithParams);
        this.runMethodInvoker(notifier, methodDescription, methodInvoker, methodWithParams);
        notifier.fireTestFinished(methodWithParams);
    }

    private void runMethodInvoker(RunNotifier notifier, Description description, Statement methodInvoker, Description methodWithParams) {
        try {
            methodInvoker.evaluate();
        }
        catch (AssumptionViolatedException e) {
            notifier.fireTestAssumptionFailed(new Failure(description, (Throwable)e));
        }
        catch (Throwable e) {
            notifier.fireTestFailure(new Failure(methodWithParams, e));
        }
    }

    private Description findChildForParams(Statement methodInvoker, Description methodDescription) {
        for (Description child : methodDescription.getChildren()) {
            InvokeParameterisedMethod parameterisedInvoker = this.findParameterisedMethodInvokerInChain(methodInvoker);
            if (!child.getMethodName().startsWith(parameterisedInvoker.getParamsAsString())) continue;
            return child;
        }
        return null;
    }

    private InvokeParameterisedMethod findParameterisedMethodInvokerInChain(Statement methodInvoker) {
        while (methodInvoker != null && !(methodInvoker instanceof InvokeParameterisedMethod)) {
            methodInvoker = this.nextChainedInvoker(methodInvoker);
        }
        if (methodInvoker == null) {
            throw new RuntimeException("Cannot find invoker for the parameterised method. Using wrong JUnit version?");
        }
        return (InvokeParameterisedMethod)methodInvoker;
    }

    private Statement nextChainedInvoker(Statement methodInvoker) {
        Field[] declaredFields;
        for (Field field : declaredFields = methodInvoker.getClass().getDeclaredFields()) {
            Statement statement = this.statementOrNull(methodInvoker, field);
            if (statement == null) continue;
            return statement;
        }
        return null;
    }

    private Statement statementOrNull(Statement methodInvoker, Field field) {
        if (field.getType().isAssignableFrom(Statement.class)) {
            return this.getOriginalStatement(methodInvoker, field);
        }
        return null;
    }

    private Statement getOriginalStatement(Statement methodInvoker, Field field) {
        field.setAccessible(true);
        try {
            return (Statement)field.get(methodInvoker);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

