/*
 * Decompiled with CFR 0.152.
 */
package pl.openrnd.multilevellistview;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.FrameLayout;
import android.widget.ListView;
import pl.openrnd.multilevellistview.MultiLevelListAdapter;
import pl.openrnd.multilevellistview.NestType;
import pl.openrnd.multilevellistview.Node;
import pl.openrnd.multilevellistview.OnItemClickListener;
import pl.openrnd.multilevellistview.R;

public class MultiLevelListView
extends FrameLayout {
    private ListView mListView;
    private boolean mAlwaysExpanded;
    private NestType mNestType;
    private MultiLevelListAdapter mAdapter;
    private OnItemClickListener mOnItemClickListener;

    public MultiLevelListView(Context context) {
        super(context);
        this.initView(null);
    }

    public MultiLevelListView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView(attrs);
    }

    public MultiLevelListView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initView(attrs);
    }

    public boolean isAlwaysExpanded() {
        return this.mAlwaysExpanded;
    }

    public void setAlwaysExpanded(boolean alwaysExpanded) {
        if (this.mAlwaysExpanded == alwaysExpanded) {
            return;
        }
        this.mAlwaysExpanded = alwaysExpanded;
        if (this.mAdapter != null) {
            this.mAdapter.reloadData();
        }
    }

    public void setNestType(NestType nestType) {
        if (this.mNestType == nestType) {
            return;
        }
        this.mNestType = nestType;
        this.notifyDataSetChanged();
    }

    public NestType getNestType() {
        return this.mNestType;
    }

    private void initView(AttributeSet attrs) {
        this.confWithAttributes(attrs);
        this.addView((View)this.mListView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.mListView.setOnItemClickListener((AdapterView.OnItemClickListener)new OnProxyItemClickListener());
    }

    private void setList(int listLayoutId) {
        this.mListView = listLayoutId == 0 ? new ListView(this.getContext()) : (ListView)LayoutInflater.from((Context)this.getContext()).inflate(listLayoutId, null);
    }

    private void confWithAttributes(AttributeSet attrs) {
        TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.MultiLevelListView, 0, 0);
        try {
            this.setAlwaysExpanded(typedArray.getBoolean(R.styleable.MultiLevelListView_alwaysExtended, false));
            this.setNestType(NestType.fromValue(typedArray.getInt(R.styleable.MultiLevelListView_nestType, NestType.SINGLE.getValue())));
            this.setList(typedArray.getResourceId(R.styleable.MultiLevelListView_list, 0));
        }
        finally {
            typedArray.recycle();
        }
    }

    public void setAdapter(MultiLevelListAdapter adapter) {
        if (this.mAdapter != null) {
            this.mAdapter.unregisterView(this);
        }
        this.mAdapter = adapter;
        if (adapter == null) {
            return;
        }
        adapter.registerView(this);
    }

    public void setOnItemClickListener(OnItemClickListener listener) {
        this.mOnItemClickListener = listener;
    }

    private void notifyDataSetChanged() {
        if (this.mAdapter != null) {
            this.mAdapter.notifyDataSetChanged();
        }
    }

    ListView getListView() {
        return this.mListView;
    }

    class OnProxyItemClickListener
    implements AdapterView.OnItemClickListener {
        OnProxyItemClickListener() {
        }

        private void notifyItemClicked(View view, Node node) {
            if (MultiLevelListView.this.mOnItemClickListener != null) {
                MultiLevelListView.this.mOnItemClickListener.onItemClicked(MultiLevelListView.this, view, node.getObject(), node.getItemInfo());
            }
        }

        private void notifyGroupItemClicked(View view, Node node) {
            if (MultiLevelListView.this.mOnItemClickListener != null) {
                MultiLevelListView.this.mOnItemClickListener.onGroupItemClicked(MultiLevelListView.this, view, node.getObject(), node.getItemInfo());
            }
        }

        private void onItemClicked(View view, Node node) {
            this.notifyItemClicked(view, node);
        }

        private void scrollToItemIfNeeded(int itemIndex) {
            int first = MultiLevelListView.this.mListView.getFirstVisiblePosition();
            int last = MultiLevelListView.this.mListView.getLastVisiblePosition();
            if (itemIndex < first || itemIndex > last) {
                MultiLevelListView.this.mListView.smoothScrollToPosition(itemIndex);
            }
        }

        private void onGroupItemClicked(View view, Node node) {
            boolean isExpanded = node.isExpanded();
            if (!MultiLevelListView.this.isAlwaysExpanded()) {
                if (isExpanded) {
                    MultiLevelListView.this.mAdapter.collapseNode(node);
                } else {
                    MultiLevelListView.this.mAdapter.extendNode(node, MultiLevelListView.this.mNestType);
                }
            }
            if (MultiLevelListView.this.mNestType == NestType.SINGLE) {
                this.scrollToItemIfNeeded(MultiLevelListView.this.mAdapter.getFlatItems().indexOf(node));
            }
            this.notifyGroupItemClicked(view, node);
        }

        public void onItemClick(AdapterView<?> adapterView, View view, int position, long id) {
            Node node = MultiLevelListView.this.mAdapter.getFlatItems().get(position);
            if (node.isExpandable()) {
                this.onGroupItemClicked(view, node);
            } else {
                this.onItemClicked(view, node);
            }
        }
    }
}

