/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.jlargearrays;

import pl.edu.icm.jlargearrays.FloatLargeArray;
import pl.edu.icm.jlargearrays.LargeArray;
import pl.edu.icm.jlargearrays.LargeArrayType;
import pl.edu.icm.jlargearrays.Utilities;

public class ComplexFloatLargeArray
extends LargeArray {
    private static final long serialVersionUID = 155390537810310407L;
    private FloatLargeArray dataRe;
    private FloatLargeArray dataIm;

    public ComplexFloatLargeArray(long length) {
        this(length, true);
    }

    public ComplexFloatLargeArray(long length, boolean zeroNativeMemory) {
        this.type = LargeArrayType.COMPLEX_FLOAT;
        this.sizeof = 4L;
        if (length <= 0L) {
            throw new IllegalArgumentException(length + " is not a positive long value");
        }
        this.length = length;
        this.dataRe = new FloatLargeArray(length, zeroNativeMemory);
        this.dataIm = new FloatLargeArray(length, zeroNativeMemory);
    }

    public ComplexFloatLargeArray(long length, float[] constantValue) {
        this.type = LargeArrayType.COMPLEX_FLOAT;
        this.sizeof = 4L;
        if (length <= 0L) {
            throw new IllegalArgumentException(length + " is not a positive long value");
        }
        if (constantValue == null || constantValue.length != 2) {
            throw new IllegalArgumentException("constantValue == null || constantValue.length != 2");
        }
        this.length = length;
        this.isConstant = true;
        this.dataRe = new FloatLargeArray(length, constantValue[0]);
        this.dataIm = new FloatLargeArray(length, constantValue[1]);
    }

    public ComplexFloatLargeArray(float[] data) {
        this(new FloatLargeArray(data));
    }

    public ComplexFloatLargeArray(FloatLargeArray data) {
        if (data.length() % 2L != 0L) {
            throw new IllegalArgumentException("The length of the data array must be even.");
        }
        if (data.length() <= 0L) {
            throw new IllegalArgumentException(data.length() + " is not a positive long value");
        }
        this.type = LargeArrayType.COMPLEX_FLOAT;
        this.sizeof = 4L;
        this.length = data.length / 2L;
        this.isConstant = data.isConstant;
        if (this.isConstant) {
            this.dataRe = new FloatLargeArray(this.length, data.getFloat(0L));
            this.dataIm = new FloatLargeArray(this.length, data.getFloat(1L));
        } else {
            this.dataRe = new FloatLargeArray(this.length, false);
            this.dataIm = new FloatLargeArray(this.length, false);
            for (long i = 0L; i < this.length; ++i) {
                this.dataRe.setFloat(i, data.getFloat(2L * i));
                this.dataIm.setFloat(i, data.getFloat(2L * i + 1L));
            }
        }
    }

    public ComplexFloatLargeArray(float[] dataRe, float[] dataIm) {
        this(new FloatLargeArray(dataRe), new FloatLargeArray(dataIm));
    }

    public ComplexFloatLargeArray(FloatLargeArray dataRe, FloatLargeArray dataIm) {
        if (dataRe.length() != dataIm.length()) {
            throw new IllegalArgumentException("The length of the dataRe must be equal to the length of dataIm.");
        }
        if (dataRe.length() <= 0L) {
            throw new IllegalArgumentException(dataRe.length() + " is not a positive long value");
        }
        this.type = LargeArrayType.COMPLEX_FLOAT;
        this.sizeof = 4L;
        this.length = dataRe.length();
        this.dataRe = dataRe;
        this.dataIm = dataIm;
    }

    @Override
    public ComplexFloatLargeArray clone() {
        if (this.isConstant()) {
            return new ComplexFloatLargeArray(this.length, new float[]{this.dataRe.getFloat(0L), this.dataIm.getFloat(0L)});
        }
        ComplexFloatLargeArray v = new ComplexFloatLargeArray(this.length, false);
        Utilities.arraycopy(this, 0L, v, 0L, this.length);
        return v;
    }

    @Override
    public boolean equals(Object o) {
        if (super.equals(o)) {
            ComplexFloatLargeArray la = (ComplexFloatLargeArray)o;
            return this.dataRe.equals(la.dataRe) && this.dataIm.equals(la.dataIm);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = 29 * super.hashCode() + (this.dataRe != null ? this.dataRe.hashCode() : 0);
        return 29 * hash + (this.dataIm != null ? this.dataIm.hashCode() : 0);
    }

    public FloatLargeArray getRealArray() {
        return this.dataRe;
    }

    public FloatLargeArray getImaginaryArray() {
        return this.dataIm;
    }

    public FloatLargeArray getAbsArray() {
        FloatLargeArray out = new FloatLargeArray(this.length, false);
        for (long i = 0L; i < this.length; ++i) {
            double re = this.dataRe.getFloat(i);
            double im = this.dataIm.getFloat(i);
            out.setFloat(i, (float)Math.sqrt(re * re + im * im));
        }
        return out;
    }

    public FloatLargeArray getArgArray() {
        FloatLargeArray out = new FloatLargeArray(this.length, false);
        for (long i = 0L; i < this.length; ++i) {
            double re = this.dataRe.getFloat(i);
            double im = this.dataIm.getFloat(i);
            out.setFloat(i, (float)Math.atan2(im, re));
        }
        return out;
    }

    public float[] get(long i) {
        return this.getComplexFloat(i);
    }

    public float[] getFromNative(long i) {
        return new float[]{this.dataRe.getFromNative(i).floatValue(), this.dataIm.getFromNative(i).floatValue()};
    }

    @Override
    public boolean getBoolean(long i) {
        return this.dataRe.getBoolean(i);
    }

    @Override
    public byte getByte(long i) {
        return this.dataRe.getByte(i);
    }

    @Override
    public short getShort(long i) {
        return this.dataRe.getShort(i);
    }

    @Override
    public int getInt(long i) {
        return this.dataRe.getInt(i);
    }

    @Override
    public long getLong(long i) {
        return this.dataRe.getLong(i);
    }

    @Override
    public float getFloat(long i) {
        return this.dataRe.getFloat(i);
    }

    @Override
    public double getDouble(long i) {
        return this.dataRe.getDouble(i);
    }

    public float[] getComplexFloat(long i) {
        return new float[]{this.dataRe.getFloat(i), this.dataIm.getFloat(i)};
    }

    public double[] getComplexDouble(long i) {
        return new double[]{this.dataRe.getDouble(i), this.dataIm.getDouble(i)};
    }

    public float[] getData() {
        return this.getComplexData();
    }

    @Override
    public boolean[] getBooleanData() {
        return this.dataRe.getBooleanData();
    }

    @Override
    public boolean[] getBooleanData(boolean[] a, long startPos, long endPos, long step) {
        return this.dataRe.getBooleanData(a, startPos, endPos, step);
    }

    @Override
    public byte[] getByteData() {
        return this.dataRe.getByteData();
    }

    @Override
    public byte[] getByteData(byte[] a, long startPos, long endPos, long step) {
        return this.dataRe.getByteData(a, startPos, endPos, step);
    }

    @Override
    public short[] getShortData() {
        return this.dataRe.getShortData();
    }

    @Override
    public short[] getShortData(short[] a, long startPos, long endPos, long step) {
        return this.dataRe.getShortData(a, startPos, endPos, step);
    }

    @Override
    public int[] getIntData() {
        return this.dataRe.getIntData();
    }

    @Override
    public int[] getIntData(int[] a, long startPos, long endPos, long step) {
        return this.dataRe.getIntData(a, startPos, endPos, step);
    }

    @Override
    public long[] getLongData() {
        return this.dataRe.getLongData();
    }

    @Override
    public long[] getLongData(long[] a, long startPos, long endPos, long step) {
        return this.dataRe.getLongData(a, startPos, endPos, step);
    }

    @Override
    public float[] getFloatData() {
        return this.dataRe.getFloatData();
    }

    @Override
    public float[] getFloatData(float[] a, long startPos, long endPos, long step) {
        return this.dataRe.getFloatData(a, startPos, endPos, step);
    }

    @Override
    public double[] getDoubleData() {
        return this.dataRe.getDoubleData();
    }

    @Override
    public double[] getDoubleData(double[] a, long startPos, long endPos, long step) {
        return this.dataRe.getDoubleData(a, startPos, endPos, step);
    }

    public float[] getComplexData() {
        if (2L * this.length > (long)ComplexFloatLargeArray.getMaxSizeOf32bitArray()) {
            return null;
        }
        float[] out = new float[(int)(2L * this.length)];
        int i = 0;
        while ((long)i < this.length) {
            out[2 * i] = this.dataRe.getFloat(i);
            out[2 * i + 1] = this.dataIm.getFloat(i);
            ++i;
        }
        return out;
    }

    public float[] getComplexData(float[] a, long startPos, long endPos, long step) {
        if (startPos < 0L || startPos >= this.length) {
            throw new ArrayIndexOutOfBoundsException("startPos < 0 || startPos >= length");
        }
        if (endPos < 0L || endPos > this.length || endPos < startPos) {
            throw new ArrayIndexOutOfBoundsException("endPos < 0 || endPos > length || endPos < startPos");
        }
        if (step < 1L) {
            throw new IllegalArgumentException("step < 1");
        }
        long len = 2L * (long)Math.ceil((double)(endPos - startPos) / (double)step);
        if (len > (long)ComplexFloatLargeArray.getMaxSizeOf32bitArray()) {
            return null;
        }
        float[] out = a != null && (long)a.length >= len ? a : new float[(int)len];
        int idx = 0;
        for (long i = startPos; i < endPos; i += step) {
            out[idx++] = this.dataRe.getFloat(i);
            out[idx++] = this.dataIm.getFloat(i);
        }
        return out;
    }

    @Override
    public void setToNative(long i, Object value) {
        if (!(value instanceof float[])) {
            throw new IllegalArgumentException(value + " is not an array of floats.");
        }
        this.dataRe.setToNative(i, Float.valueOf(((float[])value)[0]));
        this.dataIm.setToNative(i, Float.valueOf(((float[])value)[1]));
    }

    @Override
    public void setBoolean(long i, boolean value) {
        this.dataRe.setBoolean(i, value);
    }

    @Override
    public void setByte(long i, byte value) {
        this.dataRe.setByte(i, value);
    }

    @Override
    public void setShort(long i, short value) {
        this.dataRe.setShort(i, value);
    }

    @Override
    public void setInt(long i, int value) {
        this.dataRe.setInt(i, value);
    }

    @Override
    public void setLong(long i, long value) {
        this.dataRe.setLong(i, value);
    }

    @Override
    public void setFloat(long i, float value) {
        this.dataRe.setFloat(i, value);
    }

    @Override
    public void setDouble(long i, double value) {
        this.dataRe.setDouble(i, value);
    }

    @Override
    public void set(long i, Object value) {
        if (!(value instanceof float[])) {
            throw new IllegalArgumentException(value + " is not an array of floats.");
        }
        this.setComplexFloat(i, (float[])value);
    }

    public void setComplexFloat(long i, float[] value) {
        this.dataRe.setFloat(i, value[0]);
        this.dataIm.setFloat(i, value[1]);
    }

    public void setComplexDouble(long i, double[] value) {
        this.dataRe.setDouble(i, value[0]);
        this.dataIm.setDouble(i, value[1]);
    }
}

