// Generated by delombok at Thu Apr 07 11:08:41 CEST 2022
package pl.decerto.hyperon.persistence.sync;

import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import java.util.Objects;
import org.smartparam.engine.core.type.ValueHolder;
import pl.decerto.hyperon.persistence.model.def.EntityType;
import pl.decerto.hyperon.persistence.model.def.PropertyDef;
import pl.decerto.hyperon.persistence.model.value.Bundle;
import pl.decerto.hyperon.persistence.model.value.EntityProperty;
import pl.decerto.hyperon.persistence.model.value.RefProperty;
import pl.decerto.hyperon.persistence.model.value.ValueProperty;
import pl.decerto.hyperon.runtime.exception.HyperonRuntimeException;

/**
 * @author przemek hertel
 */
public class BundleSynchronizer {
	@java.lang.SuppressWarnings("all")
	private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(BundleSynchronizer.class);

	public SyncActions diff(Bundle prev, Bundle next) {
		log.debug("starting diff between 2 bundles, previous id:{}, next id:{}", getId(prev), getId(next));
		Instant startTime = Instant.now();
		boolean enabledTrace = log.isTraceEnabled();
		if (enabledTrace) {
			log.trace("enter diff \n prev={} \n next={}", print(prev), print(next));
		}
		SyncData prevData = new SyncData(prev);
		SyncData nextData = new SyncData(next);
		if (enabledTrace) {
			log.trace("prev data: {}", prevData);
			log.trace("next data: {}", nextData);
		}
		SyncActions sync = new SyncActions();
		for (EntityProperty ep : nextData.getEntities()) {
			findEntitiesToInsert(ep, prevData, sync);
		}
		for (EntityProperty prevEntity : prevData.getEntities()) {
			findModifiedEntities(prevEntity, nextData, sync);
		}
		for (RefProperty ref : nextData.getRefs()) {
			log.trace("adding reference entity, id:{}", ref.getId());
			sync.toRef(ref);
		}
		log.debug("diff ended");
		if (enabledTrace) {
			log.trace("execution time:{} ms", Duration.between(startTime, Instant.now()));
			log.trace("sync result:{}", sync);
		}
		return sync;
	}

	private Long getId(Bundle bundle) {
		return Objects.isNull(bundle) ? null : bundle.getId();
	}

	private void findModifiedEntities(EntityProperty prevEntity, SyncData nextData, SyncActions sync) {
		long id = prevEntity.getId();
		EntityProperty nextEntity = nextData.getEntity(id);
		if (nextEntity == null) {
			log.trace("deleting previous entity, id:{}", id);
			sync.toDelete(prevEntity);
		} else if (diff(prevEntity, nextEntity)) {
			log.trace("updating previous entity, id:{}", id);
			sync.toUpdate(prevEntity, nextEntity);
		} else {
			log.trace("there is no difference between previous entity:{} and current one", id);
		}
	}

	private void findEntitiesToInsert(EntityProperty ep, SyncData prevData, SyncActions sync) {
		long id = ep.getId();
		if (id == 0 || !prevData.hasEntity(id)) {
			log.trace("inserting entity, id:{}", id);
			sync.toInsert(ep);
		} else {
			if (prevData.hasEntity(id)) {
				log.trace("previous entity contains entity with id:{}", id);
			} else {
				log.trace("entity id:{} different than 0", id);
			}
		}
	}

	public boolean eq(EntityProperty p1, EntityProperty p2) {
		if (p1.getId() != p2.getId() || !p1.getType().equals(p2.getType())) {
			throw new HyperonRuntimeException("assert failed: incompatible entities, p1=" + p1 + ", p2=" + p2);
		}
		if (p1.getOwnerId() != p2.getOwnerId()) {
			return false;
		}
		if (!p1.getName().equals(p2.getName())) {
			return false;
		}
		// entity definition
		EntityType def = p1.getType().getCompoundType();
		// compare all defined value properties
		for (Map.Entry<String, PropertyDef> e : def.getProps().entrySet()) {
			String propName = e.getKey();
			PropertyDef propDef = e.getValue();
			if (propDef.isSimpleType()) {
				ValueProperty v1 = p1.getValue(propName);
				ValueProperty v2 = p2.getValue(propName);
				if (diff(v1, v2)) {
					return false;
				}
			}
		}
		return true;
	}

	private boolean diff(EntityProperty p1, EntityProperty p2) {
		return !eq(p1, p2);
	}

	public boolean eq(ValueProperty v1, ValueProperty v2) {
		if (isEmpty(v1)) {
			return isEmpty(v2);
		}
		if (isEmpty(v2)) {
			return isEmpty(v1);
		}
		// both are not empty
		ValueHolder h1 = v1.getValue();
		ValueHolder h2 = v2.getValue();
		return h1.compareTo(h2) == 0;
	}

	private boolean isEmpty(ValueProperty v) {
		ValueHolder holder = v != null ? v.getHolder() : null;
		return holder == null || holder.isNull() || holder.getValue() == null || holder.getString().length() == 0;
	}

	public boolean diff(ValueProperty v1, ValueProperty v2) {
		return !eq(v1, v2);
	}

	private String print(Bundle b) {
		return b != null ? b.print() : null;
	}
}
